/**************************************************************************
*
* ROUTINE
*               dist
*
* FUNCTION
*                
*               computes distance measures and the likelihood ratio
*
* SYNOPSIS
*               subroutine dist(m,l,r,rp,dm,sumdm,iframedm)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       m		int	i	filter order
*	l		int	i	number of terms used in cepstral
*					distance measure
*	r		float	i	ifile autocorrelation sequence
*	rp		float	i	ofile autocorrelation sequence
*	dm		float	o	distances array (subframe)
*	sumdm		float	o	distances array (current sum)
*	iframedm	int	o	number of subframes  
*
***************************************************************************
*
* DESCRIPTION
*
*	See references.
*
***************************************************************************
*
* CALLED BY
*
*	distortion	spectdist
*
* CALLS
*
*	find
*
***************************************************************************
* 
* REFERENCES
*
*	"Distance Measures for Speech Processing", A.H. Gray and J.D. Markel,
*	IEEE Trans. on ASSP, Vol. ASSP-24, no. 5, Oct. 1976
*
*	"Quantization and Bit Allocation in Speech Processing",
*	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-24
*	no. 6, Dec. 1976
*
*	"A Note on Quantization and Bit Allocation in Speech Processing",
*	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-25
*	no. 3, June 1977
*		
**************************************************************************/
#define TRUE	1
#define FALSE	0
#define DBFAC	4.342944819
#define fin(z)	DBFAC*log(1.+z+sqrt(z*(2.+z)))
#include "ccsub.h"
#include <math.h>
dist(m,l,r,rp,dm,sumdm,iframedm)
int m, l, *iframedm;
float dm[], r[], rp[], sumdm[];
{
  float c[MAXL*6], cp[MAXL*6], ra[2*MAXNO + 1], rap[2*MAXNO + 1];
  float a[2*MAXNO + 1], ap[2*MAXNO + 1], rc[2*MAXNO + 1], rcp[2*MAXNO + 1];
  float alp, alpp, del, delp, q, q1, q2, sum;
  int qflag = TRUE, i;

  setr(2*MAXNO+1, 0.0, a);
  setr(2*MAXNO+1, 0.0, ap);
  find(m, l, r, c, ra, &alp, a, rc);
  find(m, l, rp, cp, rap, &alpp, ap, rcp);
  del = r[0] * rap[0];
  delp = rp[0] * ra[0];
  for (i = 1; i <= m; i++)
  {
    del += 2.0 * r[i] * rap[i];
    delp += 2.0 * rp[i] * ra[i];
  }
  dm[0] = del / alp;
  dm[1] = delp / alpp;

  q = (dm[0] + dm[1]) / 2.0 - 1.0;
  qflag = (q >= 0.0);
  if (qflag) 
    dm[2] = fin(q);

  q1 = alpp * r[0] / (alp * rp[0]);
  q = (dm[0] / q1 + dm[1] * q1) * 0.5 - 1.0;
  qflag = (q >= 0.);
  if (qflag)
    dm[3] = fin(q);

  q2 = alpp / alp;
  q = (dm[0] / q2 + dm[1] * q2) * 0.5 - 1.0;
  qflag = (q >= 0.);
  if (qflag) 
    dm[4] = fin(q);

  q = sqrt(dm[0] * dm[1]) - 1.0;
  qflag = (q >= 0.);
  if (qflag)
    dm[5] = fin(q);

  sum = 0.0;
  for (i = 0; i < l; i++)
  {
    q = c[i] - cp[i];
    sum += q * q;
  }
  sum *= 2;

  if (sum >= 0.)
  {
    dm[6] = DBFAC * sqrt(sum);
    q = log(q1);
    dm[7] = DBFAC * sqrt(sum + q * q);
    q = log(q2);
    dm[8] = DBFAC * sqrt(sum + q * q);
  }
  else 
    qflag = FALSE;

  if(qflag)
  {
    for (i = 0; i < 9; i++)
      sumdm[i] += dm[i];
    for (i = 2; i < 9; i++)
      sumdm[9] += dm[i] / 7.0;
    (*iframedm)++;
  }

  qflag = TRUE;
}
