/**************************************************************************
*
* ROUTINE
*               biterror
*
* FUNCTION
*
*               introduce random errors in CELP bitstream
*
* SYNOPSIS
*               biterror(ber,mask,stream,streambits,error,total)
*
*   formal
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       ber		float	i	bit error rate
*	mask		int	i	error mask
*	stream		short	i/o	array of binary bits to be corrupted
*	streambits	int	i	number of bits in stream
*	error		int	o	number of bits corrputed
*	total		int	o	total number of bits through coder
*
***************************************************************************
*
* CALLED BY
*
*	celp
*
* CALLS
*
*	random
*
***************************************************************************
*
* DESCRIPTION
*		Bit errors are introduced into the array "stream" at a rate
*	"ber".  Individual bits may be reversed while protecting others by
*	setting bits of the mask array which is read at the beginning of
*	execution.
*		To protect a bit set mask(bit) = 1.  If this is
*	left at 0, the bit is subjected to reversal at the rate specified
*	by "ber".  (The protection scheme above is NOT a function of the
*	Hamming error control coding.)
*
**************************************************************************/
#include <stdio.h>
biterror(ber, mask, stream, streambits, error, total)
float ber;
int mask[], streambits, *error, *total;
short stream[];

{
  float xx, rate;
  int i;

					/* protection mask: read in	*/
  rate = ber / 100.;
  for (i = 0; i < streambits; i++)
  {
    xx = (random2() + 32768) / 65535.;
    if (mask[i] == 0)
    {
      (*total)++;
      if (xx < rate)
      {
	stream[i] ^= 1;
	if (stream[i] != 0 && stream[i] != 1)
	{
	  fprintf(stderr, "biterror: bit stream not ones and zeros\n");
	  exit(1);
	}
	(*error)++;
      }
    }
  }
}
