c==========================================================================
c
c ROUTINE
c               specdist
c
c FUNCTION
c
c               Computes spectral distorion caused by quantization of
c	line spectral frequencies.
c
c SYNOPSIS
c
c	subroutine specdist(unqfreq, newfreq, dm, sumdm, iframedm)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	unqfreq		real	i	unquantized line spectral frequencies
c	newfreq		real	i	quantized line spectral frequencies
c	dm		real	o	distortion array (subframe)
c	sumdm		real	o	distortion array (current sum)
c	iframedm	int	o	number of subframes  
c
c==========================================================================
c
c DESCRIPTION
c
c	Calculate distortions/distances (log spectral error, etc.).
c	See the first reference below for a complete description.  A
c	"reference" system is compared against a "test" system.  Because
c	of the nonsymetric nature of the Itakura-Saito measure which some
c	of these distortion measures are based, poorer measures will be
c	obtained if the "reference" and "test" systems are reversed.
c	Because of gain uncertainties, a few measures are reported.
c	(Peter Kroon generally uses the measure DM(4).)
c
c==========================================================================
c 
c REFERENCES
c
c	"Distance Measures for Speech Processing", A.H. Gray and J.D. Markel,
c	IEEE Trans. on ASSP, Vol. ASSP-24, no. 5, Oct. 1976
c
c	"Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-24
c	no. 6, Dec. 1976
c
c	"A Note on Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-25
c	no. 3, June 1977
c		
c**************************************************************************
c
	subroutine specdist(unqfreq, newfreq, dm, sumdm, iframedm)
	implicit undefined(a-z)
	include 'ccsub.com'
convex	#include "ccsub.com"
	real unqfreq(no), newfreq(no), dm(9), sumdm(10)
	integer iframedm
c
	real unqpc(maxno+1), newpc(maxno+1), unqac(maxno+1), newac(maxno+1)
	real unqrc(maxno), newrc(maxno)
c
c	Convert LSP's to autocorrelation coefficients for input to "dist"
c
	call lsptopc(unqfreq, unqpc)
	call lsptopc(newfreq, newpc)
	call pctorc(unqpc, unqrc, no)
	call pctorc(newpc, newrc, no)
	call rctoac(unqrc, unqac, no)
	call rctoac(newrc, newac, no)
c
c			*find distances between the ac sequences
	call dist(no,4*no,unqac,newac,dm,sumdm,iframedm)
	return
	end
