c==========================================================================
c
c ROUTINE
c               segsnr
c
c FUNCTION
c                
c               calculate average segmental SNR 
c
c SYNOPSIS
c               subroutine segsnr(s, ts, sumsnr, framesnr, snrflag)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       s		real	i	"reference" speech input
c	ts		i*2	i	"test" speech input
c	l		int	i	number of samples
c	sumsnr		real	o	average snr
c	framesnr	int	o	number of calculations averaged
c	snrflag		log	o	flag for valid snr value
c
c==========================================================================
c
c DESCRIPTION
c
c
c**************************************************************************
c
	subroutine segsnr(s, ts, l, sumsnr, framesnr, snrflag)
c
	implicit undefined(a-z)
c
	integer l, framesnr
	real s(l), sumsnr
	integer*2 ts(l)
	logical snrflag
	real seng, neng, snr
	integer j
c
	snrflag = .false.
	seng = 0.
	neng = 0.
	do 10 j = 1, l
	   seng = seng + s(j)**2
	   neng = neng + (s(j)-ts(j))**2
10	continue
	if (neng .gt. 0.) then
	   snr = seng/neng
	   if (snr .gt. 0) then
c	      only include segments whose snr is between -10 dB and 64 dB 
	      if (10*log10(snr).gt.-10. .and. 10*log10(snr).lt.64.)then
		 snrflag = .true.
	         sumsnr = sumsnr + snr
	         framesnr = framesnr + 1
	      else
c		 print *,'segsnr value not valid for analysis'
		 snrflag = .false.
	      end if
	   end if
	end if
	return
	end
