c==========================================================================
c
c NAME
c	rctopc
c
c FUNCTION
c
c	convert reflection coefficients into lpc coefficients.
c
c	BEWARE:  This code does not use memory efficiently.
c
c SYNOPSIS
c
c	subroutine rctopc(rc, pc, p)
c
c   formal 
c                       data	I/O
c	name		type	type	function
c	-------------------------------------------------------------------
c	k		real	i	reflection coefficients (m)
c	pc		real	o	predictor parameters (m+1: a(1)=1.0)
c	p		int	i	predictor order
c
c==========================================================================
c	
c DESCRIPTION
c
c	Converts reflection coefficients into lpc coefficients.
c
c	CELP's LPC predictor coefficient convention is:
c              p+1         -(i-1)
c       A(z) = SUM   a   z          where a  = +1.0
c              i=1    i                    1
c
c
c==========================================================================
c	
c REFERENCES
c
c	Rabiner & Schafer, Digital Processing of Speech Signals,
c	Prentice-Hall, 1978, p. 443, equations 8.131a&b&c.
c
c**************************************************************************
c-
	subroutine rctopc(k, pc, p)
	implicit undefined(a-z)
	integer p
	real k(p), pc(p+1)
	include 'ccsub.h'
convex	#include "ccsub.h"
	integer i, j
	real a(0:maxno, 0:maxno)
c
	do 20 i = 0, p
	   do 10 j = 0, p
	      a(j, i) = 0.0
10	   continue
20	continue
	do 50 i = 1, p
	   a(i, i) = k(i)
	   do 40 j = 1, i-1
	      a(j, i) = a(j, i-1) - k(i)*a(i-j, i-1)
40	   continue
50	continue
	pc(1) = 1.0
	do 60 j = 1, p
	   pc(j+1) = -a(j, p)
60	continue
	return
	end
