c==========================================================================
c
c NAME
c	rctoac 
c
c FUNCTION
c
c	convert reflection coefficients to autocorrelation coefficients
c
c SYNOPSIS
c
c	subroutine rctoac(rc, r, m)
c
c   formal 
c                       data	I/O
c	name		type	type	function
c	-------------------------------------------------------------------
c	rc(m)		real	i	reflection coefficients
c	r(m+1)		real	o	normalized autocorrelation coeff.
c	m		int	i	filter order
c
c==========================================================================
c	
c DESCRIPTION
c
c	Convert reflection coefficients to autocorrelation coefficients.
c	Where the sign convention is:
c	first reflection coefficient = +(normalized autocorrelation coef)
c	
c==========================================================================
c	
c REFERENCES
c
c	Atal & Hanauer, "Speech Analysis and Synthesis by Linear
c	Prediction of the Speech Wave," JASA, Vol 50 (2), 1971.
c
c**************************************************************************
c-
	subroutine rctoac(rc, r, m)
	implicit undefined(a-z)
	integer m
	real rc(m), r(m+1)
	real t(26), tj, tkj
	integer k, kk, lm, kl, jl, j, kj, kll
c
c	array r contains the autocorrelation coefficients
c
	r(1) = 1.0
	do 10 k = 1, m
	   kk    = k + 1
	   r(kk) = rc(k)
10	continue
	
c
c	compute predictor poly of diff deg and store in t
c	compute autocorrelation function and store into r
c
	t(1) = 1.0
	t(2) = -r(2)
	lm = m + 1
	if (lm .lt. 3) goto 110
	do 15 k = 3, lm
	   kl = k - 1
	   jl = kl/2
	   do 22 j = 1, jl
	      kj  = k - j
	      tj  = t(j+1) - r(k)*t(kj)
	      tkj = t(kj) - r(k)*t(j+1)
	      t(j+1) = tj
	      t(kj)  = tkj
22	   continue
	   t(k) = -r(k)
	   kll  = kl - 1
	   do 30 j = 1, kll
	      kj   = k - j
	      r(k) = r(k) - r(kj)*t(j+1)
30	   continue
15	continue
110	continue
	return
	end
