c==========================================================================
c
c ROUTINE
c		quantize
c
c FUNCTION
c		Nearest output level scalar quantizer
c
c SYNOPSIS
c		real function quantize(input, level, nlevel, index)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	input		real	i	Scalar to be quantized
c	level(nlevel)	real	i	Output level table
c	nlevel		int	i	Number of quantizer levels
c	index		int	o	Index to quantized output (zero based!)
c	quantize	real	f	Quantized input
c
c**************************************************************************
c
	real function quantize(input, level, nlevel, index)
	implicit undefined(a-z)
	integer nlevel, index
	real input, level(nlevel)
	integer i
	real dist, low
c
c	*** Quantize to nearest output level:
c
	do 69 i = 1, nlevel
	   dist = abs(input - level(i))
	   if (dist .lt. low .or. i .eq. 1) then
	      low = dist
	      index = i
	   end if
69	continue
	quantize = level(index)
	index    = index - 1
	return
	end
