c==========================================================================
c
c ROUTINE
c               postfilt2
c
c FUNCTION
c                
c               reduce coder noise (block wise AGC version)
c
c SYNOPSIS
c               subroutine postfilt2(s, l, alpha, beta, powerin
c				powerout, dp1, dp2, dp3, dp4)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       s		real	i/o	speech input/postfiltered output
c	l		int	i	subframe size
c	alpha		real	i	filter parameter
c	beta		real	i	filter parameter
c	powerin		real	i/o	input power estimate
c	powerout	real	i/o	output power estimate
c	dp1		real	i/o	filter memory
c	dp2		real	i/o	filter memory
c	dp3		real	i/o	filter memory
c	dp4		real	i/o	filter memory
c
c==========================================================================
c
c DESCRIPTION
c
c	Adaptive postfilter routine to reduce perceptual coder noise.
c	The postfilter emphasizes the spectral regions predicted by the
c	short-term LPC analysis.  This tends to mask coder noise by
c	concentrating it under the formant peaks.  Unfortunately, acoustic
c	background noise may also be enhanced because LPC analysis often
c	models acoustic noise instead of speech formants.  In addition,
c	postfiltering can be detrimental to tandem coding if not taken
c	into consideration.  (To overcome these problems, we hope to
c	eventually incorporate the postfilter's enhancement properties
c	into the analysis process.)
c
c	Adaptive spectral tilt compensation is applied to flatten the
c	overall tilt of the postfilter.  [[Slight high frequency boost is
c	applied for output shaping.  A pitch postfilter is used to reduce
c	pitch buzz.]]  Finally, AGC compensates for the filter gains using
c	a time constant set by parameter tc that should be dependent on
c	frame length.
c
c==========================================================================
c
c REFERENCES
c
c	Chen & Gersho, "Real-Time Vector APC Speech Coding at 4800 bps
c	with Adaptive Postfiltering," ICASSP '87, pp. 2185-2188.
c
c	Juin-Hwey (Raymond) Chen, "Low-Bit-Rate Predictive Coding of
c	Speech Waveforms Based on Vector Quantization," PhD Dissertation,
c	UCSB ECE Dept., March 1987.
c
c	Ramamoorthy, Jayant, Cox, & Sondhi, "Enhancement of ADPCM Speech
c	Coding with Backward-Adaptive Algorithms for Postfiltering and
c	Noise Feedback," IEEE JOSAIC, Feb. 1988, pp. 364-382.
c
c**************************************************************************
c
	subroutine postfilt2(s, l, alpha, beta, powerin,
     &	                      powerout, dp1, dp2, dp3, dp4)
	implicit undefined(a-z)
	integer l
	real s(l), alpha, beta, powerin, powerout
	include 'ccsub.com'
convex	#include "ccsub.com"
	real dp1(maxno), dp2(maxno), dp3(2), dp4(2) 
	integer n
	real pcexp1(maxno+1), pcexp2(maxno+1), rcexp2(maxno)
	real ast(2), scale, shape, tc
	parameter (shape = 0.3)
	parameter (tc = 0.01)
c
c			*estimate input power
	do 10 n = 1, l
	   powerin = (1.-tc)*powerin + tc*s(n)**2
10	continue
c
c			*BW expansion
	call bwexp(beta, fci, pcexp1, no)
	call bwexp(alpha, fci, pcexp2, no)
c
c			*pole-zero postfilter
	call zerofilt(pcexp1, no, dp1, s, l)
	call polefilt(pcexp2, no, dp2, s, l)
c
c			*find spectral tilt (1st order fit) of postfilter
c			*(denominator dominates the tilt)
	call pctorc(pcexp2, rcexp2, no)
c
c			*tilt compensation by a scaled zero
c			*(don't allow HF roll-off)
	ast(1) = 1.0
	ast(2) = min(-0.5*rcexp2(1), 0.)
	call zerofilt(ast, 1, dp3, s, l)
c
c			*estimate output power
	do 20 n = 1, l
	   powerout = (1.-tc)*powerout + tc*s(n)**2
20	continue
c
c			*block wise automatic gain control
	if (powerout .gt. 0.0) then
	   scale = sqrt(powerin/powerout)
	   do 30 n = 1, l
	      s(n) = scale*s(n)
30	   continue
	end if
	return
	end

