C==========================================================================
C
C ROUTINE
C               noise2
C
C FUNCTION
C
C               generates gaussian noise using the polar method
C SYNOPSIS
C               noise2(x1,x2)
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       x1              r*4     o       a sample of noise source
C       x2              r*4     o       another sample of noise source
C
C==========================================================================
C       
C USAGE
C
C	noise2 generates two samples of a Gaussian noise
C	source for each call using the polar method.
C
C==========================================================================
C
C REFERENCES
C
C       Knuth, The Art of Programming, Volume 2
C
C**************************************************************************
C*-
        subroutine noise2(x1,x2)
c
	implicit undefined(a-z)
	real x1, x2
        integer random, i, j
        real*4 f(2)
	real f1, f2, s
c
c	f(i) are samples from a uniform distribution
c	in the range of 0.0 inclusive to 1.0 inclusive. 
c
5       do 10 i=1,2
          do 20 j=1,4
            f(i)=(float(random()+32768))/65535.
20        continue
10      continue
        f1=2.*f(1)-1.
        f2=2.*f(2)-1.
        s=f1*f1 + f2*f2
        if(s.ge.1.)goto 5
        s=sqrt(-2.*alog(s)/s)
        x1=f1*s
        x2=f2*s
        return
        end
