c==========================================================================
c
c NAME
c	lsptopc 
c
c FUNCTION
c
c	convert lsp frequencies to predictor coefficients
c
c SYNOPSIS
c
c	subroutine lsptopc(f, pc)
c 
c   formal
c			data	I/O
c	name		type	type	function
c	-------------------------------------------------------------------
c	f		real	i	lsp frequencies
c	pc		real	o	LPC predictor coefficients
c
c   global 
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c 	/ccsub/       see description include file
c
c==========================================================================
c
c DESCRIPTION
c
c	LSPTOPC converts line spectral frequencies to LPC predictor 
c	coefficients.  
c
c	The analysis filter may be reconstructed:
c
c		A(z) = 1/2 [ P(z) + Q(z) ]
c
c	CELP's LPC predictor coefficient convention is:
c              p+1         -(i-1)
c       A(z) = SUM   a   z          where a  = +1.0
c              i=1    i                    1
c
c**************************************************************************
c-
	subroutine lsptopc(f, pc)
	implicit undefined(a-z)
	include 'ccsub.com'
convex	#include "ccsub.com"
c
	real f(maxno),pc(maxno+1)
	real freq(maxno),p(maxno/2),q(maxno/2)
	real a(maxno/2+1),a1(maxno/2+1),a2(maxno/2+1)
	real b(maxno/2+1),b1(maxno/2+1),b2(maxno/2+1)
	real pi,xx,xf
	integer i,j,k,noh
	logical lspflag
c
c	*** check input for ill-conditioned cases
c
	if (f(1).le.0.0 .or. f(1).ge.0.5) print *,' lsptopc:  ',
     &	'LSPs out of bounds; f(1)=',f(1),' at frame', frame
	lspflag = .false.
	do 69 i = 2, no
	   if (f(i) .le. f(i-1)) lspflag = .true.
	   if (f(i).le.0.0 .or. f(i).ge.0.5) print *,' lsptopc:  ',
     &	   'LSPs out of bounds; f(',i,')=',f(i),' at frame', frame
69	continue
	if (lspflag) print *,' lsptopc:  nonmonotonic LSPs at frame', frame
c
c	*** initialization
c
	pi=4.*atan(1.)
	noh=no/2
	do 10 j=1,no
	   freq(j)=f(j)
10	continue
	do 100 i=1,noh+1
	   a(i) =0.
	   a1(i)=0.
	   a2(i)=0.
	   b(i) =0.
	   b1(i)=0.
	   b2(i)=0.
100	continue
c
c	*** lsp filter parameters
c
	do 110 i=1,noh
	   p(i)=-2.*cos(2.*pi*freq(2*i-1))
	   q(i)=-2.*cos(2.*pi*freq(2*i))
110	continue
c
c	*** impulse response of analysis filter
c
	xf = 0.
	do 120 k=1,no+1
	   xx=0.
	   if (k.eq.1) xx=1.
	   a(1)=xx+xf
	   b(1)=xx-xf
	   xf=xx
	   do 130 i=1,noh
	      a(i+1)=a(i)+p(i)*a1(i)+a2(i)
	      b(i+1)=b(i)+q(i)*b1(i)+b2(i)
	      a2(i)=a1(i)
	      a1(i)=a(i)
	      b2(i)=b1(i)
	      b1(i)=b(i)
130	   continue
	   if (k.eq.1) go to 120
	   pc(k-1)=-.5*(a(noh+1)+b(noh+1))
120	continue
c
c	*** convert to CELP's predictor coefficient array configuration
c
	do 140 i = no, 1, -1
	   pc(i+1) = -pc(i)
140	continue
	pc(1)=1.
	return
	end

