c==========================================================================
c
c ROUTINE
c               lsp34
c
c FUNCTION
c                
c               independent nonuniform scalar line spectral pair quantizer
c
c SYNOPSIS
c               subroutine lsp34(freq, no, bits, findex)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       freq		real	i/o	input frequency array/
c					output quantized frequency array
c	no		int	i	order
c	bits		int	i	bit allocation
c	findex		int	o	frequency index array
c	
c
c==========================================================================
c
c DESCRIPTION
c
c	Independent (nondifferential) scalar LSP quantization.  Determine
c	LSP quantization by refined sequential quantization.  Because the
c	quantization tables overlap, sequential quantization can produce a
c	nonmonotonic LSP vector.  For nonmonotinic LSPs, the quantization
c	is refined by adjusting the quantization for minimum error by
c	selecting 1 of the following 2 cases:
c	1.  Quantize current LSP to next higher level
c	2.  Quantize previous LSP to the next lower level
c
C==========================================================================
C 
C INPUT FILES
C	lsp34.tbl		spectrum (34 bit LSP) coding
C
c**************************************************************************
c
	subroutine lsp34(freq, no, bits, findex)
c
	implicit undefined (a-z)
	include 'ccsub.h'
convex	#include "ccsub.h"
c
	integer no
	integer findex(no), bits(no)
	real freq(maxno+1)
	real outputs(0:15), errorup, errordn
	integer fs, lsp(10, 0:15), levels, i, j
	parameter (fs = 8000)
c
	include './lsp34.tbl'
convex	#include "./lsp34.table"
c
c			*sequentially find closest quantized LSP indicies
	do 100 i = 1, no
	   freq(i) = float(fs)*freq(i)
	   levels  = 2**bits(i) - 1
	   do 20 j = 0, levels
	      outputs(j) = lsp(i, j)
20	   continue
	   call quantize(freq(i), outputs, 2**bits(i), findex(i))
c
c			*adjust quantization if nonmonotonically quantized
c			*find minimum quantization error adjustment
	   if (i .ge. 2) then
	      if (lsp(i,findex(i)) .le. lsp(i-1,findex(i-1))) then
		 errorup = abs(freq(i)   - lsp(i,  min(findex(i)+1,levels)))+
     &		           abs(freq(i-1) - lsp(i-1,findex(i-1)))
		 errordn = abs(freq(i)   - lsp(i,  findex(i)))              +
     &			   abs(freq(i-1) - lsp(i-1,max(findex(i-1)-1,0)))
c
c			*adjust index for minimum error
c			*(and preserve monotonicity!) 
		 if (errorup .lt. errordn) then
		    findex(i) = min(findex(i)+1, levels)
C new stuff
    		    do 40 while 
     &		       (lsp(i,findex(i)).lt.lsp(i-1,findex(i-1)))
		          findex(i) = min(findex(i)+1, levels)
40		    continue
C end of new stuff
		 else
		    if (i .eq. 2) then
	               findex(i-1) = max(findex(i-1)-1, 0)
	            else
	               if (lsp(i-1, max(findex(i-1)-1,0)) .gt.
     &	                   lsp(i-2, findex(i-2))) then
	                  findex(i-1) = max(findex(i-1)-1, 0)
	               else
		          findex(i) = min(findex(i)+1, levels)
C new stuff
			  do 30 while 
     &			    (lsp(i,findex(i)).lt.lsp(i-1,findex(i-1)))
			       findex(i) = min(findex(i)+1, levels)
30			  continue
C end of new stuff
	               end if
		    
	            end if
		 end if
	      end if
	   end if
100	continue
c
c			*quantize lsp frequencies using indicies found above
	do 200 i = 1, no
	   freq(i) = lsp(i, findex(i))/float(fs)
200	continue
	return
	end
