c==========================================================================
c
c ROUTINE
c		intanaly
c
c FUNCTION
c		Linearly interpolate between transmitted LSPs
c		to generate nn (=4) intermediate sets of LSP
c		frequencies for subframe analysis. 
c		
c
c SYNOPSIS
c		subroutine intanaly(lspnew, nn, lsp)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	lspnew		real	i	new frequency array
c	nn		int	i	number of segments/frame
c	lsp		real	o	interpolated frequency matrix
c
c   global 
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c 	/ccsub/       see description include file
c
c==========================================================================
c
c DESCRIPTION
c		This routine linearly interpolates lsp's for analysis in
c	nn (=4) subframes.  This is a combination of inter- and 
c	intra-frame interpolation.  There are two routines, one for the 
c	analyzer and one for the synthesizer.
c
c		The lsps are interpolated from two transmitted frames,
c	 old and new.  The lsp interpolation is calculated as follows:
c
c	superframe:        old	                 new
c  
c		 |	               |	             |
c		 |---------------------|---------------------|
c		 |	               |	             |
c
c		  \					    /
c		   \					   /
c
c	subframe:         1       2        3        4
c		     |			       	         |
c	       ...---|--------|--------|--------|--------|
c		     |			                 |
c			  v       v        v        v
c
c	weighting:
c		old:     7/8     5/8      3/8      1/8
c		new:     1/8     3/8      5/8      7/8
c
c	Note: This is dependent on nn = ll/l = 4!
c	
c**************************************************************************
c
	subroutine intanaly(lspnew, nn, lsp)
c
	implicit undefined(a-z)
	integer nn
	include 'ccsub.com'
convex	#include "ccsub.com"
	real lspnew(no), lsp(maxno, nn)
	integer i, j
	logical nonmono
	real lspold(maxno), oldlsp(maxno)
	real tempfreq, w(2, 4)
c
	data w/0.875, 0.125,
     &         0.625, 0.375, 
     &         0.375, 0.625, 
     &         0.125, 0.875/
c
	save lspold, oldlsp
c
	data lspold  /.03,.05,.09,.13,.19,.23,.29,.33,.39,.44/
c
	do 100 i=1,nn
c
c			*interpolate lsp's
	   do 20 j=1,no
	      lsp(j,i)=w(1,i)*lspold(j)+w(2,i)*lspnew(j)
20	   continue
c.......................*OPTIONAL bug checker
c			*check for monotonically increasing lsp's
c			*swap crossed LSPs
	   do 30 j=2,no
	      if (lsp(j,i) .le. lsp(j-1,i)) then
	         print *,' intanaly:  Swapping nonmono lsps @ frame', frame
	         tempfreq=lsp(j,i)
	         lsp(j,i)=lsp(j-1,i)
	         lsp(j-1,i)=tempfreq
	      end if
30	   continue
c
c			*recheck for monotonically increasing lsp's
c			*substitute old LSPs (they must be really messed up!)
	   nonmono = .false.
	   do 32 j=2,no
	      if (lsp(j,i) .le. lsp(j-1,i)) nonmono = .true.
32	   continue
	   if (nonmono) then
	      print *,' intanaly:  Resetting interp LSP at frame', frame
	      do 34 j = 1, no
	         if (i .eq. 1) then
	            lsp(j,i)=oldlsp(j)
	         else
	            lsp(j,i)=lsp(j,i-1)
	         end if
34	      continue
	   end if
100	continue
c.......................
c
c			*save lsp's for next pass
	do 40 i=1,no
	   lspold(i)=lspnew(i)
	   oldlsp(i)=lsp(i,nn)
40	continue
	return 
	end
