c==========================================================================
c
c ROUTINE
c               distortion
c
c FUNCTION
c                
c               computes distortion/distance measures and likelihood ratio
c
c SYNOPSIS
c
c	subroutine distortion(s, ts, ws, l, no, dm, sumdm, framedm)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	s		real	i	"reference" speech input
c	ts		i*2	i	"test" speech input
c	ws		real	i	Hamming window, length l
c	l		int	i	length of comparison
c	no		int	i	filter order
c	dm		real	o	distances array (subframe)
c	sumdm		real	o	distances array (current sum)
c	framedm		int	o	number of subframes  
c
c==========================================================================
c
c DESCRIPTION
c
c	Calculate distortions/distances (log spectral error, etc.).
c	See the first reference below for a complete description.  A
c	"reference" system is compared against a "test" system.  Because
c	of the nonsymetric nature of the Itakura-Saito measure which some
c	of these distortion measures are based, poorer measures will be
c	obtained if the "reference" and "test" systems are reversed.
c	Because of gain uncertainties, a few measures are reported.
c	(Peter Kroon generally uses the measure DM(4).)
c
c==========================================================================
c 
c REFERENCES
c
c	"Distance Measures for Speech Processing", A.H. Gray and J.D. Markel,
c	IEEE Trans. on ASSP, Vol. ASSP-24, no. 5, Oct. 1976
c
c	"Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-24
c	no. 6, Dec. 1976
c
c	"A Note on Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-25
c	no. 3, June 1977
c		
c**************************************************************************
c
	subroutine distortion(s, ts, ws, l, no, dm, sumdm, framedm)
	implicit undefined(a-z)
c
	integer l, no, framedm
	integer*2 ts(l)
	real s(l), ws(l), dm(9), sumdm(10)
	include 'ccsub.h'
convex	#include "ccsub.h"
	real tsw(maxl), ssw(maxl)
	real c0hp, chp(maxno+1), c0tsw, ctsw(maxno+1)
	integer j
c
c			*apply Hamming window
	do 140 j = 1, l
	   ssw(j) = ws(j)*s(j)
	   tsw(j) = ws(j)*float(ts(j))
140	continue
c
c			*calculate autocorrelation sequences
	call cor(ssw, l, no, c0hp, chp)
	call cor(tsw, l, no, c0tsw, ctsw)
c
c			*rearrange arrays for dist
	do 145 j = no+1, 2, -1
	   chp(j)  = chp(j-1)
	   ctsw(j) = ctsw(j-1)
145	continue
	chp(1)  = c0hp
	ctsw(1) = c0tsw
c
c			*find distances
	if (chp(1) .ne. 0.0 .and. ctsw(1) .ne. 0.0) then
	   call dist(no, no*4, chp, ctsw, dm, sumdm, framedm)
	end if
	return
	end
