c==========================================================================
c
c ROUTINE
c               dist
c
c FUNCTION
c                
c               computes distance measures and the likelihood ratio
c
c SYNOPSIS
c               subroutine dist(m,l,r,rp,dm,sumdm,iframedm)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       m		int	i	filter order
c	l		int	i	number of terms used in cepstral
c					distance measure
c	r		int	i	ifile autocorrelation sequence
c	rp		int	i	ofile autocorrelation sequence
c	dm		real	o	distances array (subframe)
c	sumdm		real	o	distances array (current sum)
c	iframedm	int	o	number of subframes  
c
c==========================================================================
c
c DESCRIPTION
c
c	See references.
c
c==========================================================================
c 
c REFERENCES
c
c	"Distance Measures for Speech Processing", A.H. Gray and J.D. Markel,
c	IEEE Trans. on ASSP, Vol. ASSP-24, no. 5, Oct. 1976
c
c	"Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-24
c	no. 6, Dec. 1976
c
c	"A Note on Quantization and Bit Allocation in Speech Processing",
c	A.H. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-25
c	no. 3, June 1977
c		
c**************************************************************************
c
	subroutine dist(m,l,r,rp,dm,sumdm,iframedm)
	implicit undefined(a-z)
	include 'ccsub.h'
convex	#include "ccsub.h"
	integer l, k, j, iframedm, m, mp
	real dbfac, z, alp, alpp, del, delp
	real q, q1, q2, sum, fin
	real r(maxno+1),rp(maxno+1),dm(9),sumdm(10)
	real c(maxl*6),cp(maxl*6),ra(2*maxno+1),rap(2*maxno+1)
	real a(2*maxno+1),ap(2*maxno+1),rc(2*maxno+1),rcp(2*maxno+1)
	logical qflag
	data dbfac/4.342944819/
	data qflag/.true./
	fin(z)=dbfac*alog(1.+z+sqrt(z*(2.+z)))
	call find(m,l,r,c,ra,alp,a,rc)
	call find(m,l,rp,cp,rap,alpp,ap,rcp)
	mp=m+1
	del=r(1)*rap(1)
	delp=rp(1)*ra(1)
	do 90 j=2,mp
	   del=del+2.*r(j)*rap(j)
	   delp=delp+2.*rp(j)*ra(j)
90	continue
	dm(1)=del/alp
	dm(2)=delp/alpp
	q=(dm(1)+dm(2))/2.-1.
	if (q .lt. 0.) qflag = .false.
	if (qflag) dm(3)=fin(q)
	q1=alpp*r(1)/(alp*rp(1))
	q=(dm(1)/q1+dm(2)*q1)*.5-1.
	if (q .lt. 0.) qflag = .false.
	if (qflag) dm(4)=fin(q)
	q2=alpp/alp
	q=(dm(1)/q2+dm(2)*q2)*.5-1.
	if (q .lt. 0.) qflag = .false.
	if (qflag) dm(5)=fin(q)
	q=sqrt(dm(1)*dm(2))-1.
	if (q .lt. 0.) qflag = .false.
	if (qflag) dm(6)=fin(q)
	sum=0.
	do 110 k=1,l
	   q=c(k)-cp(k)
	   sum=sum+q*q
110	continue
	sum=sum+sum
	if (sum .ge. 0.) then
	   dm(7)=dbfac*sqrt(sum)
	   q=alog(q1)
	   dm(8)=dbfac*sqrt(sum+q*q)
	   q=alog(q2)
	   dm(9)=dbfac*sqrt(sum+q*q)
	else
	   qflag = .false.
	end if
	if(qflag) then
	   do 120 j=1,9
	      sumdm(j)=sumdm(j)+dm(j)
120	   continue
	   do 130 j=3,9
	      sumdm(10)=sumdm(10)+dm(j)/7.
130	   continue
	   iframedm=iframedm+1
	end if
	qflag = .true.
	return
	end
