c==========================================================================
c
c ROUTINE
c		dectobin
c
c FUNCTION
c		This subroutine converts decimal numbers into a
c	binary output vector.
c
c SYNOPSIS
c		dectobin(vectorsize, decinteger, binaryvector)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	vectorsize	int	i	output vector length
c	decinteger	int	i	decimal number  (< 2^32-1)
c	binaryvector	int	o	vector containing binary number
c
c==========================================================================
c
c DESCRIPTION
c
c		This subroutine is part of a set of subroutines which perform
c	a Generalized Hamming Code.  As you know, Hamming codes are perfect
c	codes and can only detect and correct one error.  We added an overall
c 	parity checkbit, which allows us to detect 2 errors.  When 2 errors 
c	are detected, (in subroutine dcodham.f) no correction attempt is
c	made.  This would most likely result in more errors.  Instead, a flag
c	is sent to the calling program notifying it of multiple errors so
c	that smoothing may be attempted.  The Hamming codes presently supported
c	by the routines are (63,57), (31,26), (15,11), and shortened variations
c	thereof.  It could be made even more general by making minor modifications
c	to the dectobin.f subroutine.  This routine at present will calculate 
c	a maximum of 6 bits.
c
c	Hamming routines consist of the following files:
c
c		matrixgen - generates the hmatrix and sydrometable.
c		dectobin - does a simple decimal to binary conversion.
c		encodeham - generates the code word and overall paritybit.
c		decodeham - recovers infobits, checks for errors, corrects 1
c					error, and sends out flag for smoothing.
c
c
c	This routine is used by encodeham to convert the packed decinteger
c	into the Hamming paritybits.
c
c**************************************************************************
c
c REFERENCES
c
c	Lin and Costello : Error Control Coding
c	Berlekamp : Algebraic Coding Theory
c
c**************************************************************************
c
	subroutine dectobin(vectorsize, decinteger, binaryvector)
	implicit undefined(a-z)
c
	integer vectorsize, decinteger, binaryvector(vectorsize)
	integer i, temp1, twostable(6)
c
	data twostable/1,2,4,8,16,32/
c
c	Check to see if the decimal integer is larger than the routine can
c	convert.  This can be easily extended by adding to the twostable.
c
	if (decinteger .gt. 63)
     &	    print *,' dectobin:  decinteger too large', decinteger
	temp1=vectorsize
	do 10 i=1,vectorsize
	   if(decinteger.ge.twostable(temp1))then
	      binaryvector(temp1)=1
	      decinteger=decinteger-twostable(temp1)
	   else
	      binaryvector(temp1)=0
	   end if
	   temp1=temp1-1
10	continue
	return
	end
