c==========================================================================
c
c ROUTINE
c		dcodtau.f
c
c FUNCTION
c		 Decodes all pitch tau values values for a frame
c		
c
c SYNOPSIS
c	subroutine dcodtau(taubits,taudelta,bitsum1,bitsum2,bitpointer,nn,
c                           stream,streambits,pddecode,pdtabi,taus)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	taubits		int	i	number of bits for quantization
c	taudelta	int	i	number of bits for even frame delta
c	bitsum1		int	i	number of bits for odd subframes
c	bitsum2		int	i	number of bits for even subframes
c	bitpointer	int	i/o	number of bits used
c	nn		int	i	number of subframes/frame
c	stream		int*2	i	bit stream
c	streambits	int	i	number of bits in stream
c	pddecode	real	i	pitch delay permutation table
c	taus		real	o	vector of pitch delays "taus"
c
c==========================================================================
c
c DESCRIPTION
c		This routine converts the pitch delay bits of the 
c	bitstream to actual delay values.  These delays are output
c	to the main routine in taus(i), one delay for each of four
c	subframes.
c
c==========================================================================
c
c REFERENCES
c
c
c**************************************************************************
c
	subroutine dcodtau(taubits,taudelta,bitsum1,bitsum2,bitpointer,nn,
     &                      stream,streambits,pddecode,pdtabi,taus)
	implicit undefined(a-z)
c
c
	include 'ccsub.com'
convex	#include "ccsub.com"
	integer taubits,taudelta,bitsum1,bitsum2,bitpointer,nn,streambits
	integer*2 stream(streambits)
	integer i,pointer,tptr,lptr,mxptr,mnptr,pdtabi(0:maxpd-1)
	real taus(nn),pddecode(0:maxpd-1)
c
	data lptr/1/
	save lptr
c
	pointer=bitpointer
	do 10 i = 1, nn
	   if (mod(i,2) .ne. 0) then
	      call unpack(stream,taubits,streambits,tptr,pointer)
	      taus(i) = pddecode(tptr)
	      pointer = pointer+bitsum1-taubits
	   else
	      call unpack(stream,taudelta,streambits,tptr,pointer)
	      pointer = pointer+bitsum2-taudelta
	      mnptr = lptr - (plevel2/2-1)
	      mxptr = lptr + (plevel2/2)
	      if (mnptr .lt. 0) then
	         mnptr = 0
	      end if
	      if (mxptr .gt. plevel1-1) then
	         mnptr = plevel1 - plevel2
	      end if
	      taus(i) = pdelay(tptr+mnptr)
	   end if
	lptr = pdtabi(tptr)
10	continue
	bitpointer = bitpointer+taubits
	return
	end
