c==========================================================================
c
c ROUTINE
c		dcodcbg.f
c
c FUNCTION
c		 Decodes all code book gains for a frame
c		
c
c SYNOPSIS
c		subroutine dcodcbg(cbgbits,bitsum1,bitsum2,nn,cbg)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	cbgbits		int	i	number of bits for quantization
c	cbgtype		char	i	quantizer type
c	bitsum1		int	i	number of bits for odd subframes
c	bitsum2		int	i	number of bits for even subframes
c	bitpointer	int	i/o	number of bits used
c	nn		int	i	number of subframes/frame
c	stream		int*2	i	bit stream
c	streambits	int	i	number of bits in stream
c	cbg		real	o	vector of code book indicies
c
c==========================================================================
c
c DESCRIPTION
c
c
c==========================================================================
c
c REFERENCES
c
c
c**************************************************************************
c
	subroutine dcodcbg(cbgbits,cbgtype,bitsum1,bitsum2,bitpointer,nn,
     &                      stream,streambits,cbg)
	implicit undefined(a-z)
c
	integer cbgbits,bitsum1,bitsum2,bitpointer,nn,streambits
	integer*2 stream(streambits)
	real cbg(nn)
	character*10 cbgtype
	integer i,pointer,index
c
	pointer=bitpointer
	do 10 i=1,nn
	   call unpack(stream,cbgbits,streambits,index,pointer)
	   call gaindecode(index,cbgbits,cbgtype,cbg(i))
	   if (i.eq.1 .or. i.eq.3 .or. i.eq.5) then
	      pointer=pointer+bitsum2-cbgbits
	   else if (i.eq.2 .or. i.eq.4 .or. i.eq.6) then
	      pointer=pointer+bitsum1-cbgbits
	   else
	      print *,' dcodcbg:  Error in decoding code book gain'
	   end if
10	continue
	bitpointer=bitpointer+cbgbits
	return
	end
