C==========================================================================
C
C ROUTINE
C               confg
C
C FUNCTION
C               computes initial states (direct form filters)
C
C SYNOPSIS
C
C       subroutine confg(s,l,d1,d2,d3,d4,isw1,isw2,isw3,isw4)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       s(l)            real    i       speech or residual segment
C       l               int     i       segment size
C       d1              real    i/o     memory 1/P(z)
C       d2              real    i/o     memory 1/A(z)
C       d3              real    i/o     memory A(z)
C       d4              real    i/o     memory 1/A(z/gamma)
C       isw1            int     i       = 1 enable 1/P(z)
C       isw2            int     i       = 1 enable 1/A(z)
C       isw3            int     i       = 1 enable A(z)
C       isw4            int     i       = 1 enable 1/A(z/gamma)
C
C   global 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C /ccsub/       see description include file
C
C==========================================================================
C*-
        subroutine confg(s,l,d1,d2,d3,d4,isw1,isw2,isw3,isw4)
	implicit undefined(a-z)
	integer l, isw1, isw2, isw3, isw4
        real s(l)
	include 'ccsub.com'
convex	#include "ccsub.com"
	real d1(maxpa),d2(maxno+1),d3(maxno+1),d4(maxno+1)
	real fctemp(maxno+1)
	integer i
c att
        if (isw1 .ne. 0) call pitchvq(e0, l, d1, idb, bb,'long')
        if (isw2 .ne. 0) call polefilt(fc, no, d2, e0, l)
c
        do 10 i = 1, l
            e0(i) = s(i) - e0(i)
10      continue
c
        if (isw3 .ne. 0) call zerofilt(fc,no,d3,e0,l)
        if (isw4 .ne. 0) then
	   call bwexp(gamma, fc, fctemp, no)
	   call polefilt(fctemp, no, d4, e0, l)
	end if
        return
        end
