***************************************************************************
*                                                                         *
*	CELP Voice Coder                                                  *
*	Version 3.2	                                                  *
*                                                                         *
*	The U.S. Government shall not be held liable for any damages      *
*	resulting from this code.  Further reproduction or distribution   *
*	of this code without prior written permission of the U.S.         *
*	Government is prohibited.  See NCS Technical Information Bulletin *
*	on FS 1016 CELP Speech Coding.					  *                                                                         *									  *
***************************************************************************
C
C ROUTINE
C		celp (main)
C
C FUNCTION
C		Code excited linear predictor (main routine)
C	
C==========================================================================
C
C REFERENCES
C
C	National Communication System Technical Information Bulletin
C	Federal Standard 1016 (to be published 1992).
C
C	Campbell, Joseph P. Jr., Thomas E. Tremain and Vanoy C. Welch,
C	"The Federal Standard 1016 4800 bps CELP Voice Coder," Digital
C	Signal Processing, Academic Press, Vol1, No. 3, p. 145-155.
C
C	Kemp, David, P., Retha A. Sueda and Thomas E. Tremain, "An
C	Evaluation of 4800 bps Voice Coders," Proceedings of the IEEE
C	International Conference on Acoustics, Speech and Signal Processing
C	(ICASSP), 1989, p. 200-203.
C
C	Fenichel, R., "Federal Standard 1016," National Communications
C	System, Office of Technology and Standards, Washington, DC 20305-2010,
C	14 February 1991.
C
C	Campbell, Joseph P. Jr., Thomas E. Tremain and Vanoy C. Welch,
C	"The DoD 4.8 kbps Standard (Proposed Federal Standard 1016),"
C	"Advances in Speech Coding", Kluwer Academic Publishers, 1991,
C	Chapter 12, p. 121-133.
C
C   Tutorials:
C	Fallside, Frank and William Woods, Computer Speech Processing,
C	Prentice Hall International, 1985, Chapter 4 (by Bishnu Atal).
C
C==========================================================================
C
C			4800 bps CELP Characteristics
C
C                  Spectrum       Pitch            Code Book
C                  -------------  ---------------  ----------------
C       Update     30 ms          30/4 = 7.5 ms    30/4 = 7.5 ms
C                  ll=240         lp=60            l=60
C
C       Order      10             256 (max) x 60   512 (max) x 60
C                                 1 gain           1 gain
C
C       Analysis   Open loop      Closed loop      Closed loop
C                  Correlation    Modified MSPE    MSPE VQ
C                  30 ms Hamming  VQ, weight=0.8   weight=0.8
C                  no preemphasis range 20 to 147  shift by 2
C                  15 Hz BW exp   (w/ fractions)   77% sparsity
C
C       Bits per   34 indep LSP   index:  8+6+8+6  index:     9*4
C        Frame     [3444433333]   gain(-1,2): 5*4  gain(+/-): 5*4
C
C       Bit Rate   1133.3 bps     1600 bps         1866.67 bps
C
C	NOTE:  The remaining 200 bps are used as follows:  1 bit per frame
C	for synchronization, 4 bits per frame for forward error correction
C	and 1 bit per frame to provide future expansion(s) of the coder.
C
C==========================================================================
C
C		UNPERMUTED BIT ASSIGNMENT
C
C	lsp  1	1-3		lsp  6	20-22
C	lsp  2	4-7		lsp  7	23-25
C	lsp  3	8-11		lsp  8	26-28
C	lsp  4	12-15		lsp  9	29-31
C	lsp  5	16-19		lsp 10	32-34
C
C	Subframe:	  1	  2	  3	   4
C	----------	-----	-----	-----	 -------
C       pitch delay	35-42	.....	87-94	 .......
C       delta delay	.....	62-67	.......	 114-119
C       pitch gain 	43-47	68-72	95-99	 120-124
C       cbindex		48-56	73-81	100-108	 125-133
C       cbgain		57-61	82-86	109-113	 134-138
C
C       future bit	139
C       error control	140-143
C       sync		144
C
C		FORWARD ERROR CONTROL, HAMMING (15,11):
C	bits protected		allocation	rate	parameter
C				0		1	LSP
C	40,41,42,92,93,94	1st-3rd MSBs	2	Pitch delay
C				0		2	Delta pitch delay
C	47,72,99,124    	1st MSB		4	Pitch gain
C				0		4	CB index
C				0		4	CB gain
C	139			1		1	Future bit
C
C		SYNCHRONIZATION BIT
C	The sync bit (144) begins with 0 in the first frame, then alternates 
C	between 1 and 0 on successive frames.
C
C==========================================================================
C 
C INPUT FILES
C	ifile.spd 		speech
C	ifile.chan		channel (use for synthesis only)
C	lsp34.table		spectrum (34 bit LSP) coding
C	pgain.table		pitch gain gain coding
C	cbgain.table		code book gain coding
C	codebook.h		stochastic code book
C	pdelay.h		adaptive code book (pitch) delay
C	pdencode.h		pitch delay bit assignment encoding table
C	pddecode.h		pitch delay bit assignment decoding table
C	submult.h		submultiple pitch delay pointer table
C	bitprot.h		bit protection (specifies FEC bits)
C	bitperm.h		bit permutation (for burst errors)
C
C OUTPUT FILES
C	ofile.spd 		speech (without high pass)
C	ofilehpf.spd		speech (high passed)
C	ofilenpf.spd		speech (no post filtering)
C	ofile.chan		bit stream channel file
C
#ifdef SUNGRAPH
C Sungraph (tm) Files:
C	ifile_ofile.sg_data	 
C	channel.sg_data		 
C	stream_error.sg_data
C	lsp1.sg_data		 see sungraph_open.com
C	lsp2.sg_data
C	codebook.sg_data
C	constrain.sg_data
C	pitch.sg_data
C	error.sg_data
C	rc.sg_data
#endif
C**************************************************************************
C*-
        program celp
	implicit undefined (a-z)
	include 'ccsub.com'
convex	#include "ccsub.com"
        real sold(maxll), snew(maxll), ssub(maxll)
	real v(maxll), vdecoded(maxll), hamw(maxll), hamws(maxll)
	real dpa(maxpa), dps(maxpa), ahpf(3), bhpf(3)
	real dppa(maxpa), dpps(maxpa)
	real ahpfo(3), bhpfo(3)
	real newfreq(maxno), unqfreq(maxno), rcn(maxno)
	real lsp(maxno,maxll/maxl), scale, descale, decodedgain, taus(4)
	real lambda, omega, alpha, beta, pddecode(0:maxpd-1)
	real predgain, preddiff, predavg, mindiff, dm(9), dm2(9)
	real cbg(maxll/maxl), pgs(maxll/maxl)
	integer cbi(maxll/maxl), pdencode(0:maxpd-1), pdtabi(0:maxpd-1)
	integer framesnr, framedm, framedm2, lnblnk
	integer i, j, k, l, ll, lp, nn, np
	integer nrec1, nrec2, nrec3, nrec9,  ierr, iodisk, oflen
	integer findex(maxno), error, total, ranseed, iflen
	integer*2 iarf(maxll), npf(maxll), pf(maxll)
	logical flag, snrflag, lspflag, analy, clip
	character*80 ifile, ofile, chfile, mfile
	character stype*10, anal*10
	data ranseed /1234567/, frame /1/, framesnr/0/
	data nrec1 /1/, nrec2 /1/, nrec3 /1/, nrec9 /1/
c
c			*bit stream
	integer cbbits, pointer, streambits, ssum, mask(172)
	integer bitsum1, bitsum2, bitpointer, sbits(maxno), sync
	data sync /1/
	parameter (streambits=144)
	integer*2 stream(streambits), oldstream(streambits)
	integer pstream(streambits)
	integer*2 savestream(streambits), iint
	character*36 line
c
c			*filter memories
	integer maxnop1
	parameter (maxnop1=maxno+1)
	real dhpf1(3), dhpf2(3), dsa(maxno+1), dss(maxno+1)
	real dhpf1o(3), dhpf2o(3)
	real dp1(maxno+1), dp2(maxno+1), dp3(2), dp4(2)
	real ip, op, sumsnr, sumdm(10), sumdm2(10)
c
c			*initialize filter memories
	data d2a/maxnop1*0./, d2b/maxnop1*0./ 
	data d3a/maxnop1*0./, d3b/maxnop1*0./
	data d4a/maxnop1*0./, d4b/maxnop1*0./, d5/maxnop1*0./
	data d1a/maxpa*0./, d1b/maxpa*0./, d6/maxpa*0./
	data dhpf1/3*0./, dhpf2/3*0./, dsa/maxnop1*0./, dss/maxnop1*0./
	data dhpf1o/3*0./, dhpf2o/3*0./, syndavg/0./
	data dp1/maxnop1*0./, dp2/maxnop1*0./, dp3/2*0./, dp4/2*0./
	data ip/0./, op/0./, sumsnr/0./, sumdm/10*0/, sumdm2/10*0/
	data dpa/maxpa*0./, dps/maxpa*0./,dppa/maxpa*0./, dpps/maxpa*0./
c
c			*error control coding parameters:
	real syndrun, ber, realerror, syndavg
	parameter (syndrun = 100.)
	integer codelength1, codelength2, paritylength
	parameter (codelength1 = 15)
	parameter (codelength2 = 11)
	parameter (paritylength = codelength1 - codelength2)
        integer bitprotect(codelength2), codeword(codelength1)
        integer hmatrix(codelength1), syndrometable(codelength1)
	integer paritybit, errorflag, bitpermute(streambits)
	integer perrorcount, syndrome, eccbits, errorcount
	logical twoerror, protect
c
#ifdef SUNGRAPH
c
c	*** sungraph
c			*define sungraph functions
        integer end_block, close_file, status
        integer open_file, def_variable
	integer close_channel, open_var_channel, read_variable
	integer input_fid, num_read
c			*define sungraph files
	integer ifile_ofile_fid, channel_fid, lsp1_fid, lsp2_fid, constrain_fid
	integer cb_fid, pitch_fid, error_fid, stream_error_fid, rc_fid
	character temp_fname*80, str*17
c			*symbolic disk_io data types
	integer i2, i4, r4
	parameter (i2 = 1)
	parameter (i4 = 2)
	parameter (r4 = 3)
c			*nonhigh-passed old input speech for alignment
	real ssubnhp(maxll), soldnhp(maxll)
c			*sungraph variable id's
	include 'sgvar.com'
convex	#include "sgvar.com"
#endif
c
c	*** defaults
c
c	Default command line i/o file names:
	data ifile /'../speech/3m3f.spd'/
	data ofile /'ofile'/, chfile /'chfile'/
c	Default code book parameters:
	data ncsize /512/, cbbits /9/, l /60/, mxsw /.true./
c	Default LPC analysis parameters:
	data ll /240/, no /10/
c	Default pitch analysis parameters:
	data lp /60/, np /1/, pstype /'hier'/, prewt /0.0/
c	Default noise weighting factor:
	data gamma /0.8/
c	Default input speech scale factor:
	data scale /1.0/, descale /1.0/
c	Default code book gain quantization:
	data cbgtype /'log'/, cbgbits /5/
c	Default pitch bit allocation (tau, np a's) (maxnp+1-2=2):
	data ptype /'max2'/, pbits /8, 6, 5, 2*0/
c	Default spectrum bit allocation (maxno-10=14):
	data stype /'kang'/, sbits /3,4,4,4,4,3,3,3,3,3/
c	Default error rate (eccbits=fecbits+future bit)
	data ber /0.0/, error /0/, total /0/, eccbits /5/
c	Default mask file
	data mfile /'none'/
c
c	Spectrum analysis parameters (should be in cli!)
	data anal /'autohf'/
copt	Filter Coefficients for 2nd order 100 Hz HPF with 60 Hz notch:
copt	filter	data ahpf/1., -1.99778, 1./, bhpf/1., -1.88, .89/
c	Filter Coefficients for 2nd order Butterworth 100 Hz HPF:
	data ahpf/0.946, -1.892, 0.946/, bhpf/1., -1.889033, 0.8948743/
c	Filter Coefficients for 2nd order Butterworth 275 Hz HPF:
c275	data ahpfo/0.858, -1.716, 0.858/, bhpfo/1., -1.696452, 0.7368054/
c	Filter Coefficients for 2nd order Butterworth 100 Hz HPF:
	data ahpfo/0.946, -1.892, 0.946/, bhpfo/1., -1.889033, 0.8948743/
c	High frequency (stabilization) factor
	parameter (lambda = 0.0)
c	Bandwidth expansion for LPC analysis (15 Hz)
	parameter (omega = 0.994127)
c	Bandwidth expansions for postfilter
	parameter (alpha = 0.8)
	parameter (beta  = 0.5)
c
c	*** handle underflows on Sun (Sun3 or Sun4)
c	This issue can be reviewed by reading the UNIX man pages
c	on ieee floating point (man -k ieee).
c
	call abrupt_underflow()
#include <f77/f77_floatingpoint.h>
cSUN?	call ieee_handler("set", "underflow", SIGFPE_DEFAULT)
c
c	*** parse the command line
c
c	celp [-i ifile] [-o ofile] [-c chan]
c	     [-p pfile] [-q qfile] [-m mfile] [-l lfile]
c
c	note:  ncsize, no, and gamma are passed through common
c	note:  The calls to cli & cliend may be commented out and celp will
c	       operate properly with default values (without bells & whistles)
c
c	... If synthesizer only, 
c
c	... If synthesizer only, the command line interface (cli) is not
c	    used.  (Separate analysis is not provided since the combined
c	    analyzer and synthesizer generates a bit stream channel file.)
c	    The celp command syntax for synthesis only (analy=.false.) is:
c
c	celp [input.chan] [ofile]
c
c	where: input is input.chan ascii hex bit stream channel file
c	       output is ofile.spd speech file (postfiltered)
c
c			*read command line,
	analy = .true.
	call cli(ifile, ofile, l, ll, lp, np, scale, descale, 
     &           ber, mask, stype, sbits, eccbits, ssum, analy)
c
c	*** initialize
c			*number of code words/LPC frame
	nn = ll/l
c			*dimension of d1a, d1b and d6???
	idb = mmax+maxnp-1+l
c
	plevel1 = 2**pbits(1)
c			*levels of delta tau
	plevel2 = 2**pbits(2)
c
c			*number of bits per subframe
	bitsum1 = cbbits+cbgbits+pbits(1)+pbits(3)
	bitsum2 = cbbits+cbgbits+pbits(2)+pbits(3)
c
c			*enable/disable error control coding
	protect  = .true.
	errorflag= 0
c			*for double error detecting FEC codes (NOT USED)
	twoerror = .false.
c
	snrflag  = .false.
	lspflag  = .true.
c
c			*start nseg at 0 to do pitch on odd segments
c			(nseg is incremented before csub) 
        nseg  = 0
c
c			*generate matrix for error control coding
	call matrixgen(codelength1, codelength2, hmatrix, syndrometable)
c
c			*generate Hamming windows
        call ham(hamw,ll)
c			*UNNECESSARY, used for distortion diagnostics
        call ham(hamws,l)
c
c
c	*** open and define files
c
	if (analy) then
#ifdef SUNGRAPH
c
c			*sungraph (tm) files
	include 'sgopen.com'
convex	#include "sgopen.com"
#else
c			*input file
	if (iodisk(3, 9, ifile, nrec9, iarf, ll) .ne. 0)
     &	   stop '*** Error opening ifile.spd'
#endif
	end if
c			*postfiltered & nonpostfiltered output
	oflen = lnblnk(ofile)
	iflen = lnblnk(ifile)
	if(iodisk(4,1,ofile(1:oflen)//'.spd',nrec1,pf,l).ne.0)
     &	   stop '*** Error opening ofile.spd'
cnpf	if(iodisk(4,2,ofile(1:oflen)//'npf.spd',nrec2,npf,l).ne.0)
cnpf     +	   stop '*** Error opening ofilenpf.spd'
	if(iodisk(4,3,ofile(1:oflen)//'hpf.spd',nrec3,pf,l).ne.0)
     &	   stop '*** Error opening ofilehpf.spd'
c
c			*bit stream channel file
	if (analy) then
	   open(unit=25, file=ofile(1:oflen)//'.chan')
	else
	   open(unit=25, file=ifile(1:iflen)//'.chan', status='old')
	end if
c
c			*quantizer design (data collection) files
copt	open(unit=20, file='cbgain.data')
copt	open(unit=21, file='pgain.data')
c
c			*read stochastic code book vector file (by 20)
	open(unit=11, file='./codebook.h', status='old', err=112)
	i = 1
	do 110 j = 1, (2*(maxncsize-1)+l)/20
	   read(11, *, err=112) (x(k), k=i,i-1+20)
	   i = i + 20
110	continue
	read(11, *, err=112) (x(k), k=i,i-1+mod((2*(maxncsize-1)+l),20))
	close(11)
	go to 115
112	   stop ' celp:  Problem with file "codebook.h"'
115	continue
c
c			*read adaptive code book index (pitch delay) file
	open(unit=12, file='./pdelay.h', status='old', err=122)
	do 120 i = 0, maxpd-1
	   read(12, *, err=122) pdelay(i)
120	continue
	close(12)
	go to 125
122	   stop ' celp:  Problem with file "pdelay.h"'
125	continue
c
c			*read pitch delay coding tables for bit assignment
c			*pdencode.h for encoding, pddecode.h for decoding
c			*generate pdtabi for delta delay coding
	open(unit=13, file='./pdencode.h', status='old', err=132)
	open(unit=14, file='./pddecode.h', status='old', err=142)
	do 130 i = 0, maxpd-1
	   read(13, '(z)', err=132) pdencode(i)
	   read(14, *, err=142) pddecode(i)
	   pdtabi(pdencode(i)) = i
130	continue
	close(13)
	close(14)
	go to 145
132	   stop ' celp:  Problem with file "pdencode.h"'
142	   stop ' celp:  Problem with file "pddecode.h"'
145	continue
c
c			*read bit protection file
	open(unit=15, file='./bitprot.h', status='old', err=152)
	   read(15, *, err=152) bitprotect(1:codelength2)
	close(15)
	go to 155
152	   stop ' celp:  Problem with file "bitprot.h"'
155	continue
c
c			*read bit permutation file (by 12)
	open(unit=16, file='./bitperm.h', status='old', err=162)
	i = 1
	do 160 j = 1, streambits/12
	   read(16, *, err=162) (bitpermute(k), k=i,i+11)
	   i = i + 12
160	continue
	close(16)
	go to 165
162	   stop ' celp:  Problem with file "bitperm.h"'
165	continue
c
c..................... m a i n  l o o p ........(fortran 77 do while)......
c
c
c	*** ANALYSIS ..................................................
c
c	*** if synthesizer only, skip analyzer >>>>>>>>>>>>>>>>>>>>>>>>
c
69	if (analy) then
	   pointer = 1
c
c			*read speech segment s of size ll, until end of file
c
#ifdef SUNGRAPH
	   status=read_variable(input_fid, iarf, ll, num_read)
	   if (status .lt. 0) then
	      if (status .eq. -5) go to 999
	      call print_disk_read_error(status,'read_input_fid')
	   end if
#else
	   if (iodisk(1, 9, ifile, nrec9, iarf, ll) .ne. ll) go to 999
#endif
c
c			*scale and convert to real speech 
c		*The ssub buffer used for subframe CELP analysis is 1/2 a
c		*frame behind the snew buffer and 1/2 a frame ahead of the 
c		*sold buffer.
	   do 200 i=1,ll
              snew(i)=max(min(scale * iarf(i), 32767.), -32768.)
200	   continue
#ifdef SUNGRAPH
c
c			*create ssubnhp vector for sungraph
	   do 203 i=1,ll/2
	      ssubnhp(i)=soldnhp(i+ll/2)
	      ssubnhp(i+ll/2)=snew(i)
203	   continue
c
c			*save input speech in file 'ifile_ofile'
	   call save_sg(ifile_vid, ssubnhp, ll, 'save speech_in_vid')
c
c			*save snew in soldnhp for sungraph in next frame
	   do 207 i=1,ll
	      soldnhp(i)=snew(i)
207	   continue
#endif
c
c			*high pass filter snew
	   call zerofilt(ahpf,2,dhpf1,snew,ll)
	   call polefilt(bhpf,2,dhpf2,snew,ll)
c
c
c			*make ssub vector from snew and sold
	   do 210 i=1,ll/2
	      ssub(i)=sold(i+ll/2)
	      ssub(i+ll/2)=snew(i)
210	   continue
c
#ifdef SUNGRAPH
c
c			*save high-passed future input in file 'ifile_ofile'
	   call save_sg(ifile_hp_vid, ssub, ll,'save ifile_hp_vid')
#endif
c
c
c	   *** LPC spectral analysis (open loop)
c	   NOTE:  Autocorrelation was found superior to covariance analysis!
c
	   if (anal .eq. 'autohf') then
	      call autohf(snew, hamw, ll, no, lambda, omega, fcn, rcn)
	   end if
c
#ifdef SUNGRAPH
c			*save rc's in file 'rc'
	  do 220 i=1,no
	     call save_sg(rc_vid(i), rcn(i), 1, 'save rc_vid')
220	  continue
#endif
c
c			*pc -> lsp (new)
	   call pctolsp2(fcn, no, newfreq, lspflag)
	   if(lspflag) then
	      print *,' celp:  Bad "new" lsp at frame: ',frame
	      print 1030, 'lsp: ', (newfreq(i), i = 1, no)
	      print 1035, 'pc:  ', (fcn(i), i = 1, no+1)
	      print 1030, 'rc:  ', (rcn(i), i = 1, no)
1030	      format(1x, a, 10f9.5)
1035	      format(1x, a, 11f9.5)
	   end if
c
c			*save unquantized lsp
	   do 230 i=1,no
	      unqfreq(i)=newfreq(i)
230	   continue
cc			*quantize lsp's
	   if (stype .ne. 'none') then
	      if (stype .eq. 'kang') then
		 call lsp34(newfreq,no,sbits,findex)
	      end if
	   else
	      print *,'*** No lsp quantization'
	   end if
c
#ifdef SUNGRAPH
c			*save future lsp variables in file 'lsp1'
	   do 233 i=1,no
	      call save_sg(lsp_vid(i), unqfreq(i), 1,'save lsp_vid')
233	   continue
c
c			*save future qlsp variables in file 'lsp1'
	   do 237 i=1,no
	      call save_sg(qlsp_vid(i), newfreq(i), 1,'save qlsp_vid')
237	   continue
c
#endif
c			*measure spectral distortion
c			*UNNECESSARY, used for diagnostics
	   call specdist(unqfreq, newfreq, dm2, sumdm2, framedm2)
c
c			*pack lsp indices in bit stream array
	   do 240 i=1,no
	      call pack(findex(i),sbits(i),streambits,stream,pointer)
240	   continue
c
c			*linearly interpolate LSPs for each subframe
	   call intanaly(newfreq, nn, lsp)
c
c	   *** for each subframe, search stochastic & adaptive code books
c
	   k = 1
	   do 300 i = 1, nn
#ifdef SUNGRAPH
c			*save interpolated lsp's in file 'lsp2'
	      do 310 j=1,no
	         call save_sg(lsp_analy_vid(j), lsp(j,i), 1,'save lsp_analy_vid')
310	      continue
#endif
	      call lsptopc(lsp(1,i),fci)
	      do 320 j=1,no+1
	         fc(j)=fci(j)
320	      continue
              nseg = nseg + 1
c
c	      *** code book & pitch searches
c
              call csub(ssub(k),v(k),l,lp)

#ifdef SUNGRAPH
c			*save code book index in file 'cbindex'
	      call save_sg(cb_index_vid, cbindex, 1,'save cb_index_vid')
c
c			*save tau in file 'pitch'
	      call save_sg(pitch_tau_vid,bb(1),1,'save pitch_tau_vid')
#endif
c
c			*pitch quantization tau
c
c			*pack parameter indices in bit stream array
	      if (mod(i,2) .ne. 0) then
                 call packtau(tauptr-minptr,pbits(1),streambits,
     &		              pdencode,stream,pointer)
	      else
                 call pack(tauptr-minptr,pbits(2),streambits,
     &		           stream,pointer)
	      end if
              call pack(pindex,pbits(3),streambits,stream,pointer)
	      cbindex=cbindex-1
	      call pack(cbindex,cbbits,streambits,stream,pointer)
	      call pack(gindex,cbgbits,streambits,stream,pointer)
c
c			*decode parameters for analysis by synthesis
	      cbindex=cbindex+1
c
c 			*pitch synthesis (UNNECESSARY, used for diagnostics)
	      call pitchvq(v(k),l,dpa,idb,bb,'long')
c
c			*pitch pre filter (UNNECESSARY, used for diagnostics)
	      if (prewt.ne.0.0) call prefilt(v(k),l,dppa)
c
c			*lpc synthesis (UNNECESSARY, used for diagnostics)
	      call polefilt(fci,no,dsa,v(k),l)
c
              k = k + l
300	   continue
c
c	   *** bit error protection
c                       *extract bits to protect from stream array
           if (protect) then
              do 410 i=1,codelength2
                 codeword(i)=stream(bitprotect(i))
410           continue
c
c                       *Hamming encode
             call encodeham(codelength1,codelength2,hmatrix,
     &                    paritybit,codeword)
c
c			*pack future bit
	      call pack(0,1,streambits,stream,pointer)
c
c                       *pack parity bits
              do 420 i=1,paritylength
                 call pack(codeword(codelength2+i),1,streambits,
     &		                    stream,pointer)
420           continue
cnotused	 call pack(paritybit,1,streambits,stream,pointer)
c
c			*toggle and pack sync bit
	      sync = sync .xor. 1
	      call pack(sync,1,streambits,stream,pointer)
           end if
#ifdef SUNGRAPH
c			*save stream array in channel file
	   call save_sg(channel_vid, stream, streambits,'save channel_vid')
c
c			*save stream array in stream_error file
	   call save_sg(stream_vid, stream, streambits,'save stream_vid')
#endif
c
c			*save stream
	   do 430 i=1,streambits
	      savestream(i)=stream(i)
430	   continue
c
c			*permute bitstream
	   do 440 i=1,streambits
	      pstream(i)=stream(bitpermute(i))
440	   continue	      
c
c			*save stream in Dave's format
	   call puthex(streambits,pstream,line)
	   write (25,1040) line
1040	   format (a36)
c
c
c	*** synthesizer only <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
c
	else
c
c	   *** CHANNEL ..................................................
c
c	   		*read in channel file (if synthesis only)
	   read (25,1050,end=444) line
1050	   format(a)
	   call gethex (streambits,pstream,line)
c
c	*** end analyzer/synthesiser only differences >>>>>>>>>>>>>>>>>>>
c
	end if
c
c			*unpermute bitstream
	do 450 i=1,streambits
	   stream(bitpermute(i))=pstream(i)
450	continue
c
c	  		*corrupt the channel with bit errors 
c
	call biterror(ber,mask,frame,stream,streambits,error,total)
#ifdef SUNGRAPH
c			*save stream array in stream_error file
	if (analy) call save_sg(stream_error_vid, stream, streambits,
     &                       'save stream_error_vid')
#endif
c
c	   *** SYNTHESIS ..................................................
c
c                       *unpack parity bits
	if (protect) then
	   pointer=pointer-paritylength-2
	   if (.not. analy) pointer=139
	   do 510 i=1,paritylength
	      call unpack(stream,1,streambits,codeword(codelength2+i),pointer)
510        continue
c          call unpack(stream,1,streambits,paritybit,pointer)
c
c			*extract code word from stream array
           do 520 i=1,codelength2
              codeword(i)=stream(bitprotect(i))
520        continue
c
c			*repack future bit (remains constant for now)
	   codeword(11)=0
c
c                       *Hamming decode
           call decodeham(codelength1,codelength2,hmatrix,
     &        syndrometable,paritybit,codeword,twoerror,syndrome)
c
c			*disable parity check (if parity not used)
	   twoerror = .false.
c
c			*bit error rate estimator (running avg of bad syndromes)
	   if (syndrome .ne. 0) syndrome = 1
	   syndavg = (1.-(1./syndrun))*syndavg+(1./syndrun)*float(syndrome)
c
c                       *repack protected bits
           do 530 i=1,codelength2
              stream(bitprotect(i))=codeword(i)
530        continue
#ifdef SUNGRAPH
c			*save stream array in stream_error file
	   if (analy) call save_sg(stream_error_s_vid, stream, streambits,
     &	                        'save stream_error_s_vid')
#endif
c
c			*compare saved stream with channel stream
	   errorcount=0
	   do 540 i=1,streambits
	      if (savestream(i) .ne. stream(i)) then
		 iint=1
		 errorcount=errorcount+1
#ifdef SUNGRAPH
		 if (analy) call save_sg(bit_error_vid,iint,1,
     &                  'save bit_error_vid')
#endif
	      else
		 iint=0
#ifdef SUNGRAPH
		    if (analy) call save_sg(bit_error_vid,iint,1,
     &                       'save bit_error_vid')
#endif
	      end if
540	   continue
	   perrorcount=0
	   do 550 i=1,codelength2
	      if (savestream(bitprotect(i)) .ne. stream(bitprotect(i)))
     &               perrorcount=perrorcount+1
550	   continue
c
c			*frame repeat if two errors detected in code word
copt           if (twoerror) then
copt	      print *,' celp:  two errors have occured in frame',frame
copt             do 560 i=1,streambits
copt                stream(i)=oldstream(i)
copt560          continue
copt             twoerror = .false.
copt           end if
           do 570 i=1,streambits
              oldstream(i)=stream(i)
570        continue
	end if
c
	pointer=0
c
c			*unpack data stream
	do 580 i=1,no
	   call unpack(stream,sbits(i),streambits,findex(i),pointer)
580	continue
c			*decode lsp's
	if (stype .ne. 'none') then
	   if (stype .eq. 'kang') then
	      call lspdecode34(findex,no,newfreq)
	   else
	      stop 'Problem with lspdecoding'
	   end if
	end if
c			*interpolate spectrum lsp's for nn subframes
	call intsynth(newfreq, nn, lsp, twoerror, syndavg, predgain,
     &			   preddiff, predavg, mindiff)
#ifdef SUNGRAPH
c			*save spectrum smoothing parameters in file 'rc'
	if (analy) then
	   call save_sg(predgain_vid, predgain, 1, 'save predgain_vid')
	   call save_sg(preddiff_vid, preddiff, 1, 'save preddiff_vid')
	   call save_sg(predavg_vid, predavg, 1, 'save predavg_vid')
	   call save_sg(mindiff_vid, mindiff, 1, 'save mindiff_vid')
	end if
#endif
c
c			*decode all code book and pitch parameters
	bitpointer=pointer
	call dcodtau(pbits(1),pbits(2),bitsum1,bitsum2,bitpointer,nn,
     &	   stream,streambits,pddecode,pdtabi,taus)
	call dcodpg(pbits(3),ptype,bitsum1,bitsum2,bitpointer,nn,stream,
     &	   streambits,pgs)
	call dcodcbi(cbbits,bitsum1,bitsum2,bitpointer,nn,stream,
     &	   streambits,cbi)
	call dcodcbg(cbgbits,cbgtype,bitsum1,bitsum2,bitpointer,nn,stream,
     &	   streambits,cbg)
c
c	   *** synthesize each subframe
c
	if (analy) nseg = nseg - nn
	k = 1
	do 600 i = 1, nn
	   nseg = nseg + 1
c
#ifdef SUNGRAPH
c			*save interpolated lsp's in file 'lsp2'
	   if (analy) then
	   do 610 j=1,no
	      call save_sg(lsp_synth_vid(j), lsp(j,i), 1,'save lsp_synth_vid')
610	   continue
	   end if
#endif
c
c			*decode values for subframe 
	   cbindex = cbi(i)
	   decodedgain = cbg(i)
	   if (protect) call smoothcbgain(decodedgain,twoerror,syndavg,
     &		cbg,i)
c
c			*code book synthesis
	   call vdecode(decodedgain,l,vdecoded(k))
c
           if (protect) call smoothtau(taus(i),twoerror,
     &                                 syndavg,taus(3),i)
	   bb(1)=taus(i)
	   bb(3)=pgs(i)
	   if (protect) call smoothpgain(bb(3),twoerror,syndavg,pgs,i)
c
#ifdef SUNGRAPH
c			*save synthesis parameters in sungraph files
	   if (analy) call save_sg(cb_index_synth_vid, cbindex, 1,
     &	      'save cb_index_synth_vid')
	   if (analy) call save_sg(pitch_tau_synth_vid, bb(1), 1,
     &	      'save pitch_tau_synth_vid')
	   if (analy) call save_sg(cb_qgain_synth_vid, decodedgain, 1,
     &	      'save cb_qgain_synth_vid')
	   if (analy) call save_sg(pitch_qgain_synth_vid, bb(3), 1, 
     &	      'save pitch_qgain_synth_vid')
#endif
c
c			*pitch synthesis
	   call pitchvq(vdecoded(k),l,dps,idb,bb,'long')
c
c			*pitch pre filter (synthesis)
	   if (prewt.ne.0.0) call prefilt(vdecoded(k),l,dpps)
c
c			*convert lsp's to pc's
	   call lsptopc(lsp(1,i),fci)
c
c			*lpc synthesis
	   call polefilt(fci,no,dss,vdecoded(k),l)
c
c	      *** check analysis versus synthesis speech
c
	   flag = .false.
	   do 620 j = 0, l-1
	      if (abs(v(k+j)-vdecoded(k+j)) .gt. 1.e-6) flag=.true.
620	   continue
	   if (flag .and. analy) print *,
     &               ' celp:  Speech mismatch at frame',frame
c
c	      *** write nonpostfiltered output speech disk files
c
	   do 630 j = 0, l-1 
	      vdecoded(k+j) = descale * vdecoded(k+j)
	      npf(k+j)=nint(max(-32768.,min (32767., vdecoded(k+j))))
canaly	      npf(k+j)=nint(max(-32768.,min (32767., v(k+j))))
630	   continue
c			*write npf output speech file "ofilenpf"
cnpf	   if (iodisk(2,2,ofile(1:oflen)//'npf.spd',nrec2,npf(k),l).ne.l)
cnpf     &	         go to 888
#ifdef SUNGRAPH
c			*sungraph's npf output speech file 'ifile_ofile'
	   if (analy) call save_sg(ofile_npf_vid,npf(k),l,
     &			'save ofile_npf_vid')
#endif
c
c	      *** calculate the average segmental SNR
c			*UNNECESSARY, used for diagnostics
c
	   if (analy) call segsnr(ssub(k),npf(k),l,sumsnr,framesnr,snrflag)
c
c	      *** calculate distortions/distances (log spectral error, etc.)
c			*UNNECESSARY, used for diagnostics
c
	   if (snrflag .and. analy) call distortion(ssub(k),npf(k),hamws,
     &                    l,no,dm,sumdm,framedm)
c
c	      *** post filtering
c
	  call postfilt(vdecoded(k),l,alpha,beta,ip,op,dp1,dp2,dp3,dp4)
canaly	  call postfilt(v(k),l,alpha,beta,ip,op,dp1,dp2,dp3,dp4)
clocomp	  call postfilt2(vdecoded(k),l,alpha,beta,ip,op,dp1,dp2,dp3,dp4)
c
c	      *** test for output speech clipping
c
636	   if (clip(vdecoded(k), l)) then
c			*frame repeat & recall synthesizer?
c			*or scale vdecoded?
	      print *,' celp:  Clipping detected at frame', frame
	      do 635 j = 0, l-1
		 vdecoded(k+j) = 0.05*vdecoded(k+j)
635	      continue
	      go to 636
	   end if
c
c	      *** write postfiltered output speech disk files
c
	  do 640 j = 0, l-1
	      pf(k+j)=nint(max(-32768.,min (32767., vdecoded(k+j))))
canaly	      pf(k+j)=nint(max(-32768.,min (32767., v(k+j))))
640	   continue
c
c			*write output speech file "ofile"
	   if (iodisk(2,1,ofile(1:oflen)//'.spd',nrec1,pf(k),l).ne.l)
     &	         go to 888
#ifdef SUNGRAPH
c			*sungraph's output speech file 'ifile_ofile'
	   if (analy) call save_sg(ofile_pf_vid,pf(k),l,'save ofile_pf_vid')
#endif
c
c	      *** high pass filter output speech
c
	   call zerofilt(ahpfo,2,dhpf1o,vdecoded(k),l)
	   call polefilt(bhpfo,2,dhpf2o,vdecoded(k),l)
c
	   do 641 j = 0, l-1
	      pf(k+j)=nint(max(-32768.,min (32767., vdecoded(k+j))))
641	   continue
c
c			*write output speech file "ofilehpf"
	   if (iodisk(2,3,ofile(1:oflen)//'hpf.spd',nrec3,pf(k),l).ne.l)
     &	         go to 888
c
#ifdef SUNGRAPH
c			*sungraph's output speech file 'ifile_ofile'
	   if (analy) call save_sg(ofile_hpf_vid,pf(k),l,'save ofile_hpf_vid')
#endif
c
	   k = k + l
600	continue
c	   . . . . . . . . . . . . . . . . . . . . . . .
c
c	*** end block
c
	frame = frame + 1
c
c			*display a propeller (rotating bar) once per frame
	call mark(0)
cframe	print *,'frame= ',frame
	if (.not. analy) go to 69
c
#ifdef SUNGRAPH
	include 'sgeblk.com'
convex	#include "sgeblk.com"
#endif
c
c	   *** shift new speech buffer into old speech buffer
c
c			sold		   snew
c		|-------------------|-------------------| snew
c			  |-------------------| 
c				   ssub
c
	do 730 i = 1, ll
	   sold(i) = snew(i)
730	continue
c
c	   *** frame finished, end loop
	go to 69
c
c................ e n d  m a i n  l o o p ......(fortran 77 do while)......
c
c	*** WRAP-UP ..................................................
c
c
c	*** exit through here if a file write error occurs
c
888	print *,' celp:  Error writing output file'
c
c	*** finished reading & processing "ifile"
c
999     continue
c
c	*** closing cue and close files
c
	do 810 i = 1, streambits
	   stream(i) = 23456
810	continue
        ierr=iodisk(-1,1,ofile(1:oflen)//'.spd',nrec1,pf,l)
cnpf	ierr=iodisk(-1,2,ofile(1:oflen)//'npf.spd',nrec2,npf,l)
	ierr=iodisk(-1,3,ofile(1:oflen)//'hpf.spd',nrec3,pf,l)
cc	close (20)
cc	close (21)
	close (25)
c
#ifdef SUNGRAPH
	include 'sgclose.com'
convex	#include "sgclose.com"
#else
	ierr=iodisk(-1,9,ifile,nrec9,iarf,ll)
#endif
	if (total .ne. 0) then
	   realerror=100.*(float(error)/float(total))
	else
	   realerror=0.0
	end if
444	call cliend(sumsnr,framesnr,realerror,
     &     sumdm,framedm,sumdm2,framedm2, analy)
	if (.not. analy) print *,'Synthesis run successful'
	stop
	end
