C==========================================================================
C
C ROUTINE
C		bwexp
C
C FUNCTION
c		Bandwidth expansion of LPC predictor coefficients
C
C SYNOPSIS
C		subroutine bwexp(alpha, pc, pcexp, n)
C
C   formal 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
c	alpha	r	i	Bandwidth expansion factor
c	pc	r	i	predictor coefficients
c	pcexp	r	o	expanded predictor coefficients
c	n	i	i	predictor order
c==========================================================================
c	
c DESCRIPTION
c
c  	Subroutine to perform bandwidth modification by moving the poles
c	(or zeros) radially in the z plane.  If the bandwidth expansion
c	factor (alpha) is less than unity, the bandwidths are expanded by
c	shifting the poles (or zeros) toward the origin of the z plane.
c	The predictor coefficients are scaled directly according to:
c
c		              i-1
c		a' = a  alpha		where i = 1, . . . , order+1
c		 i    i
c
c	Resulting in a bandwidth expansion of:
c
c		-(fs/pi)ln(alpha) Hz
c
c	(e.g., fs = 8 kHz, alpha = 0.994127 -> 15 Hz bandwidth expansion)
c
c	CELP's LPC predictor coefficient convention is:
c              p+1         -(i-1)
c       A(z) = SUM   a   z          where a  = +1.0
c              i=1    i                    1
c
C**************************************************************************
c
c
c
	subroutine bwexp(alpha, pc, pcexp, n)
	implicit undefined(a-z)
	integer n
	real alpha, pc(n+1), pcexp(n+1)
	integer i
c
	do 69 i = 1, n+1
	  pcexp(i)=pc(i)*alpha**(i-1)
69	continue
c
	return
	end
