C==========================================================================
C
C ROUTINE
C	     autohf
C
C FUNCTION
C	     LPC autocorrelation analysis with high frequency compensation.
C
C	     NOTE:  If high frequency correction is not used (i.e., lambda=0),
C	            faster procedures may be used (e.g., Durbin's recursion
C                   or LeRoux & Guegen fixed point method.
C
C SYNOPSIS
C	     subroutine autohf(s, n, w, l, p, lambda, omega, a, rc)
C
C   formal 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
c	si(n)		real	i	signal input
c	w(n)		real	i	window (i.e., Hamming)
c	n		int	i	length of input sequence
c	p		int	i	order of LPC polynomial
c	lambda		real	i	HF correction scale factor
c	omega		real	i	bandwidth expansion factor
c	a		real	o	LPC coefficients (1 to m+1)
c	rc		real	o	reflection coefficients (1 to m)
c					(voiced-> +rc1)
c==========================================================================
c	
c DESCRIPTION
c
c  	Subroutine to perform HF corrected autocorrelation LPC analysis.
c	First, autocorrelation coefficients are calculated and high
c	frequency corrected to partially compensate for the analog
c	antialiasing filter*.  (Traditionally, this technique has only been
c	applied to covariance analysis, but it applies to autocorrelation
c	analysis as well).  Next, the autocorrelation function is converted
c	to reflection coefficients by the Schur recursion (aka LeRoux &
c	Guegen).  Then, the reflection coefficients are converted to LPC
c	predictor coefficients.  Finally, the predictors are bandwidth
c	expanded by omega.
c
c	CELP's LPC predictor coefficient convention is:
c              p+1         -(i-1)
c       A(z) = SUM   a   z          where a  = +1.0
c              i=1    i                    1
c
c	The sign convention used defines the first reflection coefficient
c	as the normalized first autocorrelation coefficient, which results
c	in positive values of rc(1) for voiced speech.
c
c==========================================================================
c	
c REFERENCES
c
c	*Atal & Schroeder, Predictive Coding of Speech Signals
c	 and Subjective Error Criteria, IEEE TASSP, June 1979.
c
C**************************************************************************
c
	subroutine autohf(si, w, n, p, lambda, omega, a, rc)
	implicit undefined(a-z)
	integer n, p, i
	real si(n), w(n), lambda, omega, a(p+1), rc(p)
	include 'ccsub.com'
convex	#include "ccsub.com"
	real c0, c(maxno), alpha, lemin, atemp(maxno+1), s(maxll)
	logical unstable
c
c			*apply window
	do 5 i = 1, n
	   s(i) = si(i)*w(i)
5	continue
c			*calculate autocorrelations
	unstable = .false.
	call cor(s, n, p, c0, c)
	if (c0 .lt. 0.0) unstable = .true.
c			*convert autocorrelations to rc's
	call actorc(c0, c, rc, p, alpha)
c			*unnormalized prediction error scaled by lambda
	lemin = lambda * c0 * alpha
c			*high frequency correction (eq. 16 Atal & Schroeder)
	c0   = c0   + 0.375 *lemin
	c(1) = c(1) - 0.25  *lemin
	c(2) = c(2) + 0.0625*lemin  
c			*convert corrected autocorrelations to rc's
	call actorc(c0, c, rc, p, alpha)
c			*convert corrected rc's to pc's
	call rctopc(rc, atemp, p)
c			*expand corrected pc's
	call bwexp(omega, atemp, a, p)
c			*match rc's to expanded pc's and test for stability
	call pctorc(a, rc, p)
	do 10 i = 1, p
	   if(abs(rc(i)) .gt. 1.0) unstable = .true.
10	continue
	if (unstable) then
	   print *,' autohf:  unstable lpc analysis at frame', frame
	   do 20 i = 1, p
	      a(i+1) = 0.0
	      rc(i)  = 0.0
20	   continue
	end if
	return
	end
