/* [18jan93] (air)
   search a vocabulary file for a particular token.
   This code take from the 'pronounce' program.

*/
#include <stdlib.h>
#include <stdio.h>


static	int	isPossessive (char *word)
{
    int		len = strlen (word);

    if (len > 2 && strcmp (&word[len-2], "'S") == 0) {
	word[len-2] = '\0';
	return -1;
    }
    return 0;
}


/* search for a normalized entry in the dictionary return number of hits. */
search_in_dict(FILE *fp, char *capName, int poss) {

    register	int	i,cmp,count;
    register	int	beg, end, mid;	
    char        line[256], name[128];

    fseek (fp, 0, SEEK_END);
    beg = 0;
    end = ftell (fp);
    for (count = 0; end - beg > 512; count++) {
	mid = (beg + end) / 2;
	fseek (fp, mid, SEEK_SET);
	fgets (line, 256, fp);
	mid = ftell (fp);
	fgets (line, 256, fp);
	sscanf (line, "%s", name);
/*	printf ("%s (%d): %s\n", capName, count, name); /**/
	cmp = strcmp (name, capName);
        /* found the entry */
	if (cmp == 0) {
	    return 1;
	}
	else if (cmp < 0) {
	    beg = mid;
	}
	else {
	    end = mid;
	}
    }
    fseek (fp, beg, SEEK_SET);
/*    printf("--\n"); /**/
    for (;;count++) {
	if (fgets (line, 256, fp) == NULL) {
	    return 0;
	}
	sscanf (line, "%s", name);
/*	printf ("%s (%d): %s\n", capName, count, name); /**/
	cmp = strcmp (name, capName);
	if (cmp == 0) {
	    return 1;
	}
	if (cmp > 0) {
	    return 0;
	}
    }
}


/* retrieve a pronunciation */
int	search_vocab (FILE *fp, const char *inName)
{
    char capName[128];
    int count = 0;
    int poss = 0;
    int i;

    /* normalize the target */
    strcpy (capName, inName);
    for (i = 0; i < strlen (capName); i++)
	if (islower(capName[i]))
	    capName[i] = toupper(capName[i]);
    for (i = strlen (capName) - 1; i >= 0; i--)
	if (!isspace (capName[i]))
	    break;
    capName[i+1] = '\0';

    /* query using item as is */
    if ((count = search_in_dict(fp,capName,poss))) return count;

    /* not found; see if affix stripping helps */
    if (poss = isPossessive (capName)) {
	count = search_in_dict(fp, capName, poss);
        return count;
    }
}

