/* [13oct93] (air)
   Parse a spoken number into a numeric form.

   This code was extracted from the ATIS map_slot routine
   and modified as needed.
*/

#include "trans.h"

parse_number(wrds,sw, ew, ptr)
char	*wrds[];
int	sw, ew;
char	*ptr;
{
  char	buf[100], *str, word[30], *apos, next_wd[30];
  int	val = 0, i, j, k, tmp;

  str= buf;
  *str= 0;

  /* for each word in string */
  for (i=sw; i <= ew; i++) {

    strcpy(word, wrds[i]);
    if (apos = index(word,'\''))
      *apos = 0;
    
    /* if A or AN use 1 */
    if (!strcmp("A", word) || !strcmp("AN", word)) {
      sprintf (str, "%d", 1);
      str += strlen(str);
      continue;
    }

    /* if OH use 0 */
    if (!strcmp("OH", word)) {
      sprintf (str, "%d", 0);
      str += strlen(str);
      continue;
    }

    /* if digit or teen */
    for (j = 0; strcmp(ones[j], "END") && strcmp(ones[j], word); j++);
    if (strcmp(ones[j], "END")) {
      sprintf (str, "%d", j);
      str += strlen(str);
      continue;
    }

    /* if ordinal number */
    for (j = 0; strcmp(ordinal[j], "END") && strcmp(ordinal[j], word); j++);
    if (strcmp(ordinal[j], "END")) {
      if (j < 20) sprintf (str, "%d", j+1);
      else sprintf (str, "%d", 30);
      str += strlen(str);
      continue;
    }

    /* else if tens */
    for (j = 0; strcmp(tens[j], "END") && strcmp(tens[j], word); j++);
    if (strcmp(tens[j], "END")) {
      /* if last word in string */
      if (i >= ew) {
	sprintf (str, "%d", (j+2) * 10);
	str += strlen(str);
	continue;
      }

      /* see if next digit a ones or ordinal */
      strcpy(next_wd,wrds[i+1]);
      if (apos = index(next_wd,'\''))
	*apos = 0;
      for (k=0; (k < 10) && strcmp(ones[k], "END"); k++) {
	if (!strcmp(ones[k], next_wd)) break;
	if (!strcmp(ordinal[k], next_wd)) break;
      }
      if (!strcmp(ones[k], next_wd)) {
	sprintf (str, "%d", (j+2));
	str += strlen(str);
	sprintf (str, "%d", k);
	str += strlen(str);
	i++;
	continue;
      }
      else if (!strcmp(ordinal[k], next_wd)) {
	sprintf (str, "%d", (j+2));
	str += strlen(str);
	if (k < 20) sprintf (str, "%d", k+1);
	else sprintf (str, "%d", 30);
	str += strlen(str);
	i++;
	continue;
      }
      else {
	sprintf (str, "%d", (j+2) * 10);
	str += strlen(str);
	continue;
      }

    }

    /* if hundreds */
    if (!strcmp("HUNDRED", word)) {
      if (*buf) sscanf(buf, "%d", &tmp);
      else tmp = 1;
      val += 100 * tmp;
      str= buf;
      *str= 0;
    }

    /* if thousand */
    if (!strcmp("THOUSAND", word)) {
      if (*buf) sscanf(buf, "%d", &tmp);
      else tmp = 1;
      val += 1000 * tmp;
      str= buf;
      *str= 0;

    /* ignoring the millions, etc for now */

  }
  if (*buf) {
    sscanf(buf, "%d", &tmp);
    val += tmp;
  }

  sprintf (ptr, "%d", val);
}


#ifdef TEST
main (int argc,  char **argv)
{
  char *p,*q,*words[32],out[16];
  int i;

 if (argc!=2) {quit(-1,"usage: %s: <string>\n",argv[0]);}
 p = argv[1];
 i = 0;
 while (strlen((q = (char *) nxtarg(&p," \t")))!=0) {
    words[i] = (char *) malloc (strlen(q)+1);
    strcpy(words[i],q);
    i++;
 }
 parse_number(words,0,i-1,out);
 printf("%s\n",out);
}

#endif
