#include "nodes.h"

/*			AONODE_

    This constructor sets the type of the node by default to OR.

*/

AONODE_::AONODE_()
{
    type = OR;
    n_left = 0;
    solved = DUNNO;
}



/*			AONODE_

    This constructor sets the type of the node to the specified value.

*/

AONODE_::AONODE_(int t)
{
    type = t;
    n_left = 0;
    solved = DUNNO;
}



/*                        AONODE_

    This constructor sets the type of the node to the specified value,
    it also sets n_left to the specified value.

*/

AONODE_::AONODE_(int t, int l)
{
    type = t;
    n_left = l;
    solved = DUNNO;
}



/*			DECN_LEFT

    Decreases the number of successors left by one.

*/

void AONODE_::decn_left()
{
    n_left--;
}



/*			GETTYPE

    Returns type of node: AND or OR.

*/

int AONODE_::gettype() const
{
    return(type);
}


/*			SETTYPE

    Sets type of node to t: AND or OR.

*/

void AONODE_::settype(int t)
{
    type = t;
}



/*			SETSOLVED

    Sets the solved status of node to s: SOLVED, UNSOLVABLE or DUNNO.

*/

void AONODE_::setsolved(int s)
{
    solved = s;
}



/*			GETN_LEFT

    Returns the number of successors left.

*/

int AONODE_::getn_left() const
{
    return(n_left);
}



/*			GETSOLVED

    Returns the solved status of node: SOLVED, UNSOLVABLE, or DUNNO.

*/

int AONODE_::getsolved() const
{
    return(solved);
}



/*			INCN_LEFT

    Increase the number of successors left by one.

*/

void AONODE_::incn_left()
{
    n_left++;
}

