#include <stdio.h>
#include "graph.h"

/*                   DEMO6

    This program is exactly the same as the one in demo3 except that
    we derive PUZZLE_ from class BIDEPTH_GRAPH_ because we want to
    perform a bidirectional search.

*/


class PNODE_ : public NODE_
{
    public:
        PNODE_(const char *, int empty_x, int empty_y);
        PNODE_(const char *, int, int, int, int);

        int get_x() const;
        int get_y() const;
        const char *get_board() const;

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;
        void display() const;
        NODE_ *do_operator(int) const;
    private:
        PNODE_
            *do_left() const,
            *do_right() const,
            *do_up() const,
            *do_down() const;
            int compare_board(const char *) const;
        int
            x,
            y;
        char
            board[3][3];
};



class PUZZLE_ : public BIDEPTH_GRAPH_
{
    public:
        PUZZLE_(PNODE_ *start, PNODE_ *target);
};


