;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN MATCH-PATTERN (PATTERN-NUMBER) "Match a pattern to features (as in one pattern of a MATCH-1-RECOGNITION_AGENT), return 'SUCCEEDED or NIL.  Patterns numbered starting with 0"
   (DECLARE (SPECIAL *CURRENT-DRAGON*))
   (LET (TEST-RESULT (J 0))
        (DOTIMES (I (SLOT-VALUE *CURRENT-DRAGON* 'NUMBER-OF-FEATURES))
               (SETF TEST-RESULT (EVAL (AREF (SLOT-VALUE 
                                                    *CURRENT-DRAGON*
                                                    'TEST-BLOCK)
                                             PATTERN-NUMBER I)))
               (IF (NOT (NULL TEST-RESULT))
                   (PROGN (SETF J (1+ J))
                          (IF (>= J (AREF (SLOT-VALUE *CURRENT-DRAGON*
                                                 'SUCCESS-THRESHOLDS)
                                          PATTERN-NUMBER))
                              (RETURN-FROM MATCH-PATTERN 'SUCCEEDED))))
               )
        (RETURN-FROM MATCH-PATTERN NIL)))


(DEFUN MATCH-THE-PATTERN
   NIL "Match pattern (as in pattern of a DISCRETE-PATTERN-RECOGNITION-AGENT) to features, return 'SUCCEEDED or NIL. "
       (DECLARE (SPECIAL *CURRENT-DRAGON*))
       (LET (TEST-RESULT (J 0))
            (DOTIMES (I (SLOT-VALUE *CURRENT-DRAGON* '
                               NUMBER-OF-FEATURES))
                   (SETF TEST-RESULT (EVAL (AREF (SLOT-VALUE
                                                  *CURRENT-DRAGON*
                                                  'TESTS)
                                                 I)))
                   (IF (NOT (NULL TEST-RESULT))
                       (PROGN (SETF J (1+ J))
                              (IF (>= J (SLOT-VALUE *CURRENT-DRAGON*
                                               'SUCCESS-THRESHOLD))
                                  (RETURN-FROM MATCH-THE-PATTERN
                                         'SUCCEEDED)))))))
