;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMACRO DEFINE-CLASSIFICATION-SPECIALIST (CS-NAME &BODY GT-CODE)
   (IF (NULL GT-CODE)
       (ERROR "Error in the classification specialist definition of ~S. Nothing was specified." 
              CS-NAME))
   `(LET (TEMP)
         (FORMAT *TRACE-OUTPUT* "~%~%~%~%~%")
         (IF (AND (BOUNDP ',CS-NAME)
                  (TYPEP ,CS-NAME 'DRAGON))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Destroying old version of ~S.~%"
                           ',CS-NAME)
                    (TOOLBED::DESTROY ,CS-NAME)
                    (FORMAT *TRACE-OUTPUT* 
                           "Making new classification-specialist named ~S.~%"
                           ',CS-NAME)
                    (SETF ,CS-NAME (PCL::MKI 'classification-specialist)))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Making new classification-specialist named ~S.~%"
                           ',cs-NAME)
                    (DEFPARAMETER ,cs-NAME 
		      		(PCL::MKI 'classification-specialist))))

         (SETF (SLOT-VALUE ,CS-NAME 'UNIQUE-NAME)
               ',CS-NAME)
         (FORMAT *TRACE-OUTPUT* "Compiling ~S. ~%" ',CS-NAME)
         (COMPILE-dragon-type ',CS-NAME ,CS-NAME
                ',GT-CODE)
	 ;; return the instance
	 ,cs-name))




