;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMACRO DEFINE-CLASSIFIER (C-NAME &BODY GT-CODE)
   (IF (NULL GT-CODE)
       (ERROR "Error in the recognition agent definition of ~S. Nothing was specified." 
              C-NAME))
   `(LET (TEMP)
         (FORMAT *TRACE-OUTPUT* "~%~%~%~%~%")
         (IF (AND (BOUNDP ',C-NAME)
                  (TYPEP ,C-NAME 'DRAGON))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Destroying old version of ~S.~%"
                           ',C-NAME)
                    (TOOLBED::DESTROY ,C-NAME)
                    (FORMAT *TRACE-OUTPUT* 
                           "Making new CLASSIFIER named ~S.~%"
                           ',C-NAME)
                    (SETF ,C-NAME (pcl::*make-instance 'CLASSIFIER)))
             (PROGN (FORMAT *TRACE-OUTPUT* 
                           "Making new CLASSIFIER named ~S.~%"
                           ',C-NAME)
                    (DEFPARAMETER ,C-NAME 
		      (PCL::*make-instance 'CLASSIFIER))))
         (SETF (SLOT-VALUE ,C-NAME 'UNIQUE-NAME)
               ',C-NAME)
         (FORMAT *TRACE-OUTPUT* "Compiling ~S. ~%" ',C-NAME)
         (COMPILE-dragon-type ',C-NAME ,C-NAME ',GT-CODE)))



(DEFMETHOD COMPILE-dragon-type (C-NAME (C-INSTANCE CLASSIFIER)
                                     GT-CODE-BODY)
   (LET ((MANDATORIES '(AUTHOR))
         (FORBIDDEN NIL))
        (FORMAT *TRACE-OUTPUT* 
               "Storing the specifcations into appropriate slots.~%")
       
       ;; stuff the rest of the slots, making sure all of the
       
       ;; MANDATORIES and none of the FORBIDDEN list are
       
       ;; present

        (STUFF-C-SLOTS C-INSTANCE GT-CODE-BODY MANDATORIES FORBIDDEN)
        (FORMAT *TRACE-OUTPUT* "Adding default values.~%")
        (IF (slot-empty-p c-instance 'display-name)
            (SETF (SLOT-VALUE C-INSTANCE 'DISPLAY-NAME)
                  (SYMBOL-NAME (SLOT-VALUE C-INSTANCE 'UNIQUE-NAME))))
        (FORMAT *TRACE-OUTPUT* "Building hierarchy.~%")
        (SETF (SLOT-VALUE C-INSTANCE 'HIERARCHY)
              (PCL::*make-instance 'HIERARCHY 'node-type 'symbol))

        (FORMAT *TRACE-OUTPUT* "Building controller.~%")
	(setf (slot-value c-instance 'parsed-controller) nil
	      (slot-value c-instance 'parsed-tracing-controller) nil)

	(if (not (slot-empty-p c-instance 'control-additions))
	    (parse-controller-slot c-instance 'classifier))

	(SETF (SLOT-VALUE C-INSTANCE 'PARSED-CONTROLLER)
	      ;; make sure things come out in the right order -- the
	      ;; user-specified lambdas must come first in the assoc list,
	      ;; so they can shadow any system-define verbs they redefine
	      (append (slot-value c-instance 'parsed-controller)
		      (CONTROLLERS C-INSTANCE))
	      (slot-value c-instance 'parsed-tracing-controller)
	      (append (slot-value c-instance 'parsed-tracing-controller)
		      (controllers c-instance)))

        (FORMAT *TRACE-OUTPUT* "Compiling controller.~%")
	(if *compile-controller*
	    (SETF (SLOT-VALUE C-INSTANCE 'ACTIONS)
		  (COMPILE-CONTROLLER (SLOT-VALUE C-INSTANCE '
						  PARSED-CONTROLLER)))
	    (setf (slot-value c-instance 'actions)
		  (slot-value c-instance 'parsed-controller)))
        (FORMAT *TRACE-OUTPUT* 
               "Finished compiling classifier ~S.~%" 
               C-NAME)))


(DEFUN STUFF-C-SLOTS (C-INSTANCE BODY MANDATORIES FORBIDDEN)
   (DOLIST (SPECIFIER BODY)
          (FORMAT *TRACE-OUTPUT* "     ~S~%" (CAR SPECIFIER))
          (CASE (CAR SPECIFIER)
                (DISPLAY-NAME= (SETF (SLOT-VALUE C-INSTANCE
                                            'DISPLAY-NAME)
                                     (CADR SPECIFIER)))
                (AUTHOR= (SETF (SLOT-VALUE C-INSTANCE 'AUTHOR)
                               (CADR SPECIFIER))
                       (SETF MANDATORIES (REMOVE 'AUTHOR MANDATORIES)))
                (CREATION-DATE= (SETF (SLOT-VALUE C-INSTANCE
                                             'CREATION-DATE)
                                      (CADR SPECIFIER))
                       (SETF MANDATORIES (REMOVE 'CREATION-DATE 
                                                MANDATORIES)))
                (LAST-MODIFICATION-DATE= (SETF (SLOT-VALUE C-INSTANCE
                                                      '
                                                 LAST-MODIFICATION-DATE
                                                      )
                                               (CADR SPECIFIER))
                       (SETF MANDATORIES (REMOVE '
                                                LAST-MODIFICATION-DATE 
                                                MANDATORIES)))
                (SPECIFIC-FUNCTION= (SETF (SLOT-VALUE C-INSTANCE
                                                 'SPECIFIC-FUNCTION)
                                          (CADR SPECIFIER)))
                (ASSOCIATED-CONCEPTS= (SETF (SLOT-VALUE C-INSTANCE
                                                   'ASSOCIATED-CONCEPTS
                                                   )
                                            (CDR SPECIFIER))
                       (ADD-DRAGON-TO-CONCEPTS (SLOT-VALUE C-INSTANCE
                                                      'UNIQUE-NAME)
                              (CDR SPECIFIER)))
                (COMPONENT-OF= (SETF (SLOT-VALUE C-INSTANCE
                                            'COMPONENT-OF)
                                     (CDR SPECIFIER)))
                (COMPONENTS= (IF (MEMBER 'COMPONENTS FORBIDDEN)
                                 (ERROR 
           "ERROR: COMPONENTS is not a permitted specification for ~S."
                                        (SLOT-VALUE C-INSTANCE
                                               'UNIQUE-NAME)))
                       (SETF (SLOT-VALUE C-INSTANCE 'COMPONENTS)
                             (CDR SPECIFIER)))
		(control-additions= (setf
				     (slot-value c-instance
						 'control-additions)
				     (cdr specifier)))
		(tracing-control-additions=
		 (setf (slot-value c-instance 'tracing-control-additions)
		       (cdr specifier)))
                (TOOL-USER-SLOTS= (SETF (SLOT-VALUE C-INSTANCE
                                               'TOOL-USER-SLOTS)
                                        (CDR SPECIFIER)))
                (RATIONALE= (SETF (SLOT-VALUE C-INSTANCE 'RATIONALE)
                                  (CADR SPECIFIER)))
                (EXPERT= (SETF (SLOT-VALUE C-INSTANCE 'EXPERT)
                               (CADR SPECIFIER)))
                (CITATIONS= (SETF (SLOT-VALUE C-INSTANCE 'CITATIONS)
                                  (CADR SPECIFIER)))
                (DISCLAIMER= (SETF (SLOT-VALUE C-INSTANCE 'DISCLAIMER)
                                   (CADR SPECIFIER)))
                (OTHER-KNOWLEDGE-SOURCES= (SETF (SLOT-VALUE
                                                 C-INSTANCE
                                                 '
                                                OTHER-KNOWLEDGE-SOURCES
                                                 )
                                                (CADR SPECIFIER)))
                (MEMORY-RETENTION-LIMIT= (SETF (SLOT-VALUE C-INSTANCE
                                                      '
                                                 MEMORY-RETENTION-LIMIT
                                                      )
                                               (CADR SPECIFIER)))
                (MEMORY-RETENTION-WARNING-LIMIT=
                 (SETF (SLOT-VALUE C-INSTANCE '
                              MEMORY-RETENTION-WARNING-LIMIT)
                       (CADR SPECIFIER)))
                (OTHERWISE (ERROR "ERROR: In ~S, this is not a recognized specification for a classification specialist: ~S"
                                  (SLOT-VALUE C-INSTANCE 'UNIQUE-NAME)
                                  SPECIFIER))))
   (IF MANDATORIES (ERROR "ERROR in compiling ~S. Required specifications for ~S have not been made."
                          (SLOT-VALUE C-INSTANCE 'UNIQUE-NAME)
                          MANDATORIES))
   (FORMAT *TRACE-OUTPUT* 
          "Specification stuffed into appropriate slots. ~%"))
