;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(define-confidence-set continuous-confidence-set
  (min= 0)
  (max= 1)
  (type= number)
  (neutral-equivalent= 0.5)
  (ge= #'>=)
  (le= #'<=)
  (member-confidence-set= (lambda (x) (if (not (typep x 'number))
					  nil
					  (and (>= x min)
					       (<= x max))))))

(define-confidence-set discrete-confidence-set
  (type= symbol)
  (values-list= nil))

(define-confidence-set usual-2-val
  (superclass= discrete-confidence-set)
  (type= symbol)
  (values-list= t f)
  (gt= (lambda (x y) (member y (cdr (member x '(t neutral f))))))
  (lt= (lambda (x y) (member x (cdr (member y '(t neutral f))))))
  (ge= (lambda (x y) (member y (member x '(t neutral f)))))
  (le= (lambda (x y) (member x (member y '(t netural f)))))
  (aliases= (t yes yup yeah y) (f no nope nil forgetit)))

(define-confidence-set usual-3-val 
  (superclass= discrete-confidence-set)
  (values-list= yes neutral no)
  (neutral-equivalent= neutral)
  (aliases= (yes confirmed) (no ruled-out)))

(define-confidence-set usual-9-val
  (superclass= discrete-confidence-set)
  (values-list= confirmed very-likely likely somewhat-likely
		neutral somewhat-unlikely unlikely very-unlikely
		ruled-out)
  (neutral-equivalent= neutral))

(define-confidence-set usual-continuous-val
  (superclass= continuous-confidence-set)
  (min= 0)
  (max= 1))



