;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFMETHOD COMPILE-dragon-type (RA-NAME (RA-INSTANCE 
                                     DISCRETE-PATTERN-RECOGNITION-AGENT
                                                     )
                                            GT-CODE-BODY) 
         "Compiles a discrete-pattern-recognition-agent specification."
   (LET
    ((MANDATORIES '(AUTHOR FEATURES MATCH-CONFIDENCE PATTERN))
     (FORBIDDEN '(JUDGE-LAMBDA HIERARCHY TOP-NODE PATTERNS COMPONENTS))
     )
    (FORMAT *TRACE-OUTPUT* 
           "Storing the specifications into the appropriate slots.~%")
       
       ;; next, stuff the rest of the slots, checking that all
       ;; of the MANDATORIES and none of the FORBIDDEN list are
       ;; present

    (IF (EQUAL (STUFF-RA-SLOTS RA-INSTANCE GT-CODE-BODY MANDATORIES 
                      FORBIDDEN)
               'FREE-FORM)
        (RETURN-FROM COMPILE-dragon-type
               (EVAL `(DEFINE-RECOGNITION-AGENT ,RA-NAME 
                             FREE-FORM-RECOGNITION-AGENT ,@GT-CODE-BODY
                             ))))
    (FORMAT *TRACE-OUTPUT* "Adding default values.~%")
    (IF (slot-empty-p ra-instance 'display-name)
        (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NAME)
              (SYMBOL-NAME (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))))
    (IF (slot-empty-p ra-instance 'display-no-match-confidence)
        (SETF (SLOT-VALUE RA-INSTANCE 'DISPLAY-NO-MATCH-CONFIDENCE)
              'NEUTRAL))
    (IF (slot-empty-p ra-instance 'output-confidence-vocabulary)
        (SETF (SLOT-VALUE RA-INSTANCE 'OUTPUT-CONFIDENCE-VOCABULARY)
              USUAL-9-VAL-GENERIC-INSTANCE))
       
       ;; arrange to set up confidence set, and parse up the
       ;; controller

    (FORMAT *TRACE-OUTPUT* "Setting up controller. ~%")

    (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER) NIL)
    (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER) NIL)
    (IF (NOT (slot-empty-p ra-instance 'control-additions))
        (PARSE-CONTROLLER-SLOT RA-INSTANCE 
			       'DISCRETE-PATTERN-RECOGNITION-AGENT))
       
       ;; set up features, pattern, transforms

    (FORMAT *TRACE-OUTPUT* "Checking that there are the same number of tests as there are features.~%"
           )
    (LET
     ((NUMB-FEATURES (SLOT-VALUE RA-INSTANCE 'NUMBER-OF-FEATURES))
       
       ;; temporary var for holding the transform result types
       ;; for parse-features type-checking

      (TRANSFORM-RESULT-TYPES NIL))
     (IF (NOT (= (LENGTH (SLOT-VALUE RA-INSTANCE 'DISPLAY-TESTS))
                 NUMB-FEATURES))
         (ERROR "ERROR in the specification of discrete pattern RA ~S. The number of tests in the pattern is not equal to the number of features.~%"
                (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME)))
     (IF (NOT (slot-empty-p ra-instance 'display-transforms))
         (PROGN (FORMAT *TRACE-OUTPUT* "Checking that there are the same number of transforms as there are features.~%"
                       )
                (IF (NOT (= NUMB-FEATURES (LENGTH (SLOT-VALUE
                                                   RA-INSTANCE
                                                   'DISPLAY-TRANSFORMS)
                                                 )))
                    (ERROR "ERROR in the specification of RA ~S. The number of transforms does not equal the number of features.~%" 
                           RA-NAME))))
       
       ;; default success-threshold if not there

     (IF (slot-empty-p ra-instance 'success-threshold)
         (SETF (SLOT-VALUE RA-INSTANCE 'SUCCESS-THRESHOLD)
               NUMB-FEATURES)
         (IF (NOT (<= 1 (SLOT-VALUE RA-INSTANCE 'SUCCESS-THRESHOLD)
                   NUMB-FEATURES))
             (ERROR "ERROR: the SUCCESS-THRESHOLD specified for ~S is not between 1 and the number of tests, inclusive."
                    (SLOT-VALUE RA-INSTANCE 'UNIQUE-NAME))))
     (FORMAT *TRACE-OUTPUT* "Transforming the feature specs to runnable form, setting up if-needed triggers.~%"
            )
       
       ;; parse-features sets up FEATURES, FEATURE-FETCH-TYPES,
       ;; and FEATURE-VALUE-TYPES slots 

     (PARSE-FEATURES RA-INSTANCE)
     (FORMAT *TRACE-OUTPUT* "Building runnable form of transforms.~%")
     (IF (slot-empty-p ra-instance 'display-transforms)
         (PROGN (SETF (SLOT-VALUE RA-INSTANCE 'TRANSFORMS)
                      (MAKE-ARRAY (LIST NUMB-FEATURES)
                             :INITIAL-ELEMENT NIL))
                (SETF TRANSFORM-RESULT-TYPES (SLOT-VALUE RA-INSTANCE
                                                    '
                                                    FEATURE-VALUE-TYPES
                                                    )))
         (PROGN 
       
       ;; parse-transforms returns two values - a vector
       ;; containing the parsed transforms, and a vector
       ;; listing the confidence set resulting from applying
       ;; each transform, used for type-checking in
       ;; parse-features

                (SETF TRANSFORM-RESULT-TYPES
                      (MULTIPLE-VALUE-LIST (PARSE-TRANSFORMS
                                            (SLOT-VALUE RA-INSTANCE
                                                   'DISPLAY-TRANSFORMS)
                                            (SLOT-VALUE RA-INSTANCE
                                                   '
                                           OUTPUT-CONFIDENCE-VOCABULARY
                                                   )
                                            (SLOT-VALUE RA-INSTANCE
                                                   'FEATURE-VALUE-TYPES
                                                   ))))
                (SETF (SLOT-VALUE RA-INSTANCE 'TRANSFORMS)
		      (CAR TRANSFORM-RESULT-TYPES))
                (SETF TRANSFORM-RESULT-TYPES (CADR 
                                                 TRANSFORM-RESULT-TYPES
                                                   ))))
     (FORMAT *TRACE-OUTPUT* 
            "Make an array to hold tests in runnable form.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'TESTS)
           (MAKE-ARRAY (LIST NUMB-FEATURES)
                  :ELEMENT-TYPE
                  (OR 'SYMBOL 'CONS)))
     (FORMAT *TRACE-OUTPUT* 
            "Transform the tests in the spec array to runnable form.~%"
            )
     (DOTIMES (J NUMB-FEATURES)
            (SETF (AREF (SLOT-VALUE RA-INSTANCE 'TESTS)
                        J)
                  (PARSE-TEST (AREF (SLOT-VALUE RA-INSTANCE
                                           'DISPLAY-TESTS)
                                    J)
			      (if (confidence-set-p
				   (aref transform-result-types j))
				   (AREF 
				    TRANSFORM-RESULT-TYPES 
				    J)
				  (aref transform-result-types j))
                         J
			 (aref
			  (SLOT-VALUE RA-INSTANCE 'TRANSFORMS) j))))
       
       ;; set up runnable form of match-confidence

     (FORMAT *TRACE-OUTPUT* "Transforming the match-confidence from display from to internal runnable form.~%"
            )
     (SETF (SLOT-VALUE RA-INSTANCE 'MATCH-CONFIDENCE)
           (PARSE-CONFIDENCE (SLOT-VALUE RA-INSTANCE '
                                    DISPLAY-MATCH-CONFIDENCE)))
       
       ;; if the confidence is an INVOKE that is precisely the
       ;; same as something that appars as a feature,
       ;; substitute an appropriate CHECK-FEATURE form so as to
       ;; avoid repeating a dragon invocation

     (FORMAT *TRACE-OUTPUT* "Checking to see if  the match-confidence is an INVOKE's that are precisely the same as something that appears as a feature.~%"
            )
     (IF (FIND (SLOT-VALUE RA-INSTANCE 'MATCH-CONFIDENCE)
               (SLOT-VALUE RA-INSTANCE 'FEATURES)
               :TEST
               #'EQUAL)
         (SETF (SLOT-VALUE RA-INSTANCE 'MATCH-CONFIDENCE)
               `(CHECK-FEATURE ,(POSITION (SLOT-VALUE RA-INSTANCE
                                                 'MATCH-CONFIDENCE)
                                       (SLOT-VALUE RA-INSTANCE
                                              'FEATURES)
                                       :TEST
                                       #'EQUAL))))
       
       ;; similarly for the NO-MATCH confidence

     (FORMAT *TRACE-OUTPUT* "Setting up the NO-MATCH confidence.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
           (PARSE-CONFIDENCE (SLOT-VALUE RA-INSTANCE '
                                    DISPLAY-NO-MATCH-CONFIDENCE)))
     (IF (FIND (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
               (SLOT-VALUE RA-INSTANCE 'FEATURES)
               :TEST
               #'EQUAL)
         (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-CONFIDENCE)
               `(CHECK-FEATURE ,(POSITION (SLOT-VALUE RA-INSTANCE
                                                 'NO-MATCH-CONFIDENCE)
                                       (SLOT-VALUE RA-INSTANCE
                                              'FEATURES)
                                       :TEST
                                       #'EQUAL))))
       
       ;; set up MATCH-ACTION

     (IF
      (NOT (slot-empty-p ra-instance 'display-match-action))
      (SETF
       (SLOT-VALUE RA-INSTANCE 'MATCH-ACTION)
       (CASE
        (LENGTH (SLOT-VALUE RA-INSTANCE 'DISPLAY-MATCH-ACTION))
        (0 NIL)
        (1
         `,(CAR (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                       (MAPCAR #'TRANSFORM-CONFIDENCE-REFERENCES
                              (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                     (SLOT-VALUE RA-INSTANCE
                                            'DISPLAY-MATCH-ACTION))))))
        (OTHERWISE
         `,(CONS 'PROGN (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                               (MAPCAR #'
                                      TRANSFORM-CONFIDENCE-REFERENCES
                                      (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                             (SLOT-VALUE RA-INSTANCE
                                                    '
                                                   DISPLAY-MATCH-ACTION
                                                    ))))))))
      (SETF (SLOT-VALUE RA-INSTANCE 'MATCH-ACTION) NIL))
       
       ;; set up NO-MATCH-ACTION

     (IF
      (NOT (slot-empty-p ra-instance 'display-no-match-action))
      (SETF
       (SLOT-VALUE RA-INSTANCE 'NO-MATCH-ACTION)
       (CASE
        (LENGTH (SLOT-VALUE RA-INSTANCE 'DISPLAY-NO-MATCH-ACTION))
        (0 NIL)
        (1
         `,(CAR (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                       (MAPCAR #'TRANSFORM-CONFIDENCE-REFERENCES
                              (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                     (SLOT-VALUE RA-INSTANCE
                                            'DISPLAY-NO-MATCH-ACTION)))
                       )))
        (OTHERWISE
         `,(CONS 'PROGN (MAPCAR #'TRANSFORM-PATTERN-REFERENCES
                               (MAPCAR #'
                                      TRANSFORM-CONFIDENCE-REFERENCES
                                      (MAPCAR #'TRANSFORM-INVOKE-FORMS
                                             (SLOT-VALUE RA-INSTANCE
                                                    '
                                                DISPLAY-NO-MATCH-ACTION
                                                    ))))))))
      (SETF (SLOT-VALUE RA-INSTANCE 'NO-MATCH-ACTION) NIL))
       
       ;; build judge and tracing judge

     (FORMAT *TRACE-OUTPUT* 
            "Building standard and tracing controller.~%")
     (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER)
	   ;; make sure things come out in the right order -- the
	   ;; user-specified lambdas must come first in the assoc list,
	   ;; so they can shadow any system-define verbs they redefine
           (append (SLOT-VALUE RA-INSTANCE 'PARSED-CONTROLLER)
		   (controllers ra-instance)))
     (SETF (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER)
           (append (SLOT-VALUE RA-INSTANCE 'PARSED-TRACING-CONTROLLER)
		   (tracing-controllers ra-instance)))
     (FORMAT *TRACE-OUTPUT* "Compiling controller.~%")
     (if *compile-controller*
	 (SETF (SLOT-VALUE RA-INSTANCE 'ACTIONS)
	       (COMPILE-CONTROLLER (SLOT-VALUE RA-INSTANCE '
					       PARSED-CONTROLLER)))
         (setf (slot-value ra-instance 'actions)
	       (slot-value ra-instance 'parsed-controller))))
    (FORMAT *TRACE-OUTPUT* 
          "Finished compiling discrete-pattern-recognition-agent ~S.~%" 
           RA-NAME)))

