;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

		       
	      

(defun apply-test (test feature-value dragon)
;;; This function tests the value a dragon got for a particular feature
;;; (feature-value) with the appropriate test for that feature in the pattern
;;; being examined (test). The value may be a symbol, a number, or a confidence
;;; value. The test is the internal run-form of the test created by parse-test
;;; when the agent is built. In that run-form, references to the feature
;;; value are of the form (check-feature feature-number) or 
;;; (fetch-feature feature-number). To apply the form to feature-value, 
;;; the list beginning with check-feature or fetch-feature must be replaced 
;;; by feature-value. Then the new resulting test form will be executed and 
;;; the result returned."

  (labels 
   ((transform-test-form 
     (form feature-value)
     (cond ((symbolp form) form)
	   ((listp form)
	    (case (car form)
		  (check-feature `',feature-value)
		  (fetch-transformed-feature `',feature-value)
		  (otherwise (cons (transform-test-form (car form)
							feature-value)
				   (transform-test-form (cdr form)
							feature-value)))))
	   (t form))))

   (return-from apply-test
		(eval
		 (transform-test-form test feature-value)))))

