;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

;(shadow 'defmacro *the-pcl-package*)

(defvar *defmacro*)

;;;
;;; Install something to process defmacro's lambda list a bit before defmacro
;;; gets to see it.  This allows me to move the &environment to the front of
;;; the list where KCL's defmacro wants it to be.
;;;
;;; This goes to great pains to be sure that it will always indirect through
;;; the function cell of new-defmacro.  That allows me to redefine and have
;;; the new definition take effect.
;;; 
(eval-when (load eval)
  (unless (and (boundp '*defmacro*) *defmacro*)
    (setq *defmacro* (macro-function 'defmacro))
    (setf (macro-function 'defmacro)
	  #'(lambda (form env)
	      (declare (notinline new-defmacro))
	      (new-defmacro form env)))))

(defun new-defmacro (form env)
  (let ((defmacro (car form))
	(name (cadr form))
	(ll (caddr form))
	(body (cdddr form))
	(&env nil))
    (cond ((not (and (eq defmacro 'defmacro)
		     (symbolp name)
		     (listp ll)))
	   ;; Something is wrong, but we'll pass the whole thing off
	   ;; to the real defmacro and let it detect the error and
	   ;; complain about it in its own way.
	   (funcall *defmacro* form env))
	  ((setq &env (member '&environment ll))
	   ;; If &environment is in the lambda list we have to redo
	   ;; the lamnbda list so that it is at the front.
	   (let ((new-ll ())
		 (old-ll ll))
	     (loop (when (eq old-ll &env)
		     (return (setq ll (append (list '&environment
						    (cadr old-ll))
					      (reverse new-ll)
					      (cddr old-ll)))))
		   (push (pop old-ll) new-ll))
	     (funcall *defmacro*
		      (list* 'defmacro name ll body)
		      env)))
	  (t
	   (funcall *defmacro* form env)))))

;;;
;;; setf patches
;;;

(in-package 'system)

(defun get-setf-method (form)
  (multiple-value-bind (vars vals stores store-form access-form)
      (get-setf-method-multiple-value form)
    (unless (listp vars)
	    (error 
 "The temporary variables component, ~s, 
  of the setf-method for ~s is not a list."
             vars form))
    (unless (listp vals)
	    (error 
 "The values forms component, ~s, 
  of the setf-method for ~s is not a list."
             vals form))
    (unless (listp stores)
	    (error 
 "The store variables component, ~s,  
  of the setf-method for ~s is not a list."
             stores form))
    (unless (= (list-length stores) 1)
	    (error "Multiple store-variables are not allowed."))
    (values vars vals stores store-form access-form)))

(defun get-setf-method-multiple-value (form)
  (cond ((symbolp form)
	 (let ((store (gensym)))
	   (values nil nil (list store) `(setq ,form ,store) form)))
	((or (not (consp form)) (not (symbolp (car form))))
	 (error "Cannot get the setf-method of ~S." form))
	((get (car form) 'setf-method)
	 (apply (get (car form) 'setf-method) (cdr form)))
	((get (car form) 'setf-update-fn)
	 (let ((vars (mapcar #'(lambda (x)
	                         (declare (ignore x))
	                         (gensym))
	                     (cdr form)))
	       (store (gensym)))
	   (values vars (cdr form) (list store)
	           `(,(get (car form) 'setf-update-fn)
		     ,@vars ,store)
		   (cons (car form) vars))))
	((get (car form) 'setf-lambda)
	 (let* ((vars (mapcar #'(lambda (x)
	                          (declare (ignore x))
	                          (gensym))
	                      (cd form)))
		(store (gensym))
		(l (get (car form) 'setf-lambda))
		(f `(lambda ,(car l) 
		      (funcall #'(lambda ,(cadr l) ,@(cddr l))
			       ',store))))
	   (values vars (cdr form) (list store)
		   (apply f vars)
		   (cons (car form) vars))))
	((macro-function (car form))
	 (get-setf-method-multiple-value (macroexpand-1 form)))
	(t
	 (error "Cannot expand the SETF form ~S." form))))
