(DEFINE-FILE-INFO PACKAGE (LET ((*PACKAGE*)) (* ;; 
"create the CLOS-BROWSER package") (CLIN-PACKAGE 
"CLOS-BROWSER") (* ;; "make the file in the USER package") (
CLFIND-PACKAGE "USER")) READTABLE "XCL" BASE 10)
(il:filecreated "21-Mar-88 11:03:27" 
il:{phylum}<pcl>clos-browser.\;30 122904 

      il:|changes| il:|to:|  (il:types 
                                    clos-browser:clos-icon 
                                 clos-browser::clos-browser 
                            clos-browser::clos-browser-node
                                    )
                             (il:functions 
                   clos-browser::make-multi-method-sub-menu
                                    )

      il:|previous| il:|date:| "17-Mar-88 16:17:36" 
il:{phylum}<pcl>clos-browser.\;29)


; Copyright (c) 1987, 1988, 1900, 1901 by Xerox Corporation.  All rights reserved.

(il:prettycomprint il:clos-browsercoms)

(il:rpaqq il:clos-browsercoms 
          (

(il:* il:|;;;| "***************************************")

           

(il:* il:|;;;| " Copyright (c) 1988 by Xerox Corporation.  All rights reserved.")

           

(il:* il:|;;;| "Use and copying of this software and preparation of derivative works based upon this software are permitted.  Any distribution of this software or derivative works must comply with all applicable United States export control laws.")

           

(il:* il:|;;;| "This software is made available AS IS, and Xerox Corporation makes no  warranty about the software, its performance or its conformity to any specification.")

           

(il:* il:|;;;| "Any person obtaining a copy of this software is requested to send their name and post office or electronic mail address to:")

           

(il:* il:|;;;| "   CLOS Coordinator")

           

(il:* il:|;;;| "   Xerox Artifical Intelligence Systems   ")

           

(il:* il:|;;;| "   2550 Hanover St.")

           

(il:* il:|;;;| "   Palo Alto, CA 94303")

           

(il:* il:|;;;| 
"(or send internet mail to CLOSSupport.pa@Xerox.arpa)")

           

(il:* il:|;;;| " ****************************************")

           

(il:* il:|;;;| "")

           

(il:* il:|;;;| "Print out a copyright notice when loading")

           
      
      (il:* il:|;;| "")

           (il:p (format t "~&;CLOS-BROWSER Copyright (c) 1988, Xerox Corporation.  All rights reserved.~%"
                        ))
           

(il:* il:|;;;| "LOAD DEPENDENT MODULES")

           
      
      (il:* il:|;;| "Note: before compiling clos-browser:")

           
      
      (il:* il:|;;| "    (load 'web-editor.dfasl)")

           
      
      (il:* il:|;;| "    (load 'clos-browser.dfasl)")

           
      
      (il:* il:|;;| "    (load 'clos-browser 'prop)")

           (il:p (unless (or (eq il:makesysname
                                 ':lyric)
                             (il:getprop 'il:pcl-env
                                    'il:filedates))
                        (il:filesload il:clos-environment))
                 )
           (il:files il:web-editor il:ed-patch)
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "PACKAGE STUFF ")

           (il:props (il:clos-browser 
                            il:makefile-environment)
                  (il:clos-browser il:filetype))
           (il:p il:* clos-browser-package-commands)
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "SYSTEM PATCHES")

           
      
      (il:* il:|;;| "initialize built-in-class-of so compiler use of a gf does not infinitely recurse")

           (il:p (pcl:class-of 1))
           
      
      (il:* il:|;;| "fix a bug in format statement")

           (il:functions pcl::load-defmethod-internal)
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "PCL extensions to match CLOS")

           (il:functions pcl::symbol-class)
           (il:functions pcl::cboundp)
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "PCL internal extensions")

           (pcl::methods (pcl::method-named nil)
                  (clos-browser::subclasses-of (
                                        pcl::standard-class
                                                )))
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "specialize il:getdef ")

           (il:p (unless (pcl::generic-function-p
                          (symbol-function `il:getdef))
                        (pcl::make-specializable
                         'il:getdef :arglist
                         '(il:object &optional type 
                                 il:source il:options))))
           (pcl::methods (il:getdef (pcl::standard-class))
                  (il:getdef (pcl::standard-method)))
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "CLOS-ICON CLASS & INSTANCE INITIALIZATION")

           (pcl::classes clos-browser:clos-icon)
           (il:variables clos-browser:clos-icon)
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "CLOS-BROWSER CLASS")

           (il:functions clos-browser:browse-class 
                  clos-browser::collect-family 
                  clos-browser::make-nodes 
                  clos-browser::clos-browser-close-fn 
                  clos-browser::browser-contains-p)
           (pcl::classes clos-browser::clos-browser)
           (pcl::methods (clos-browser::add-root (
                                 clos-browser::clos-browser
                                                  ))
                  (clos-browser::add-roots (
                                 clos-browser::clos-browser
                                            ))
                  (web::box-node (
                                 clos-browser::clos-browser
                                  ))
                  (web:browse (clos-browser::clos-browser))
                  (clos-browser::clear-method-menu-caches
                   (clos-browser::clos-browser))
                  (web:icon-title (
                                 clos-browser::clos-browser
                                   ))
                  (web:initialize-editor (
                                 clos-browser::clos-browser
                                          ))
                  (clos-browser::new-item (
                                 clos-browser::clos-browser
                                           ))
                  (web:recompute (
                                 clos-browser::clos-browser
                                  ))
                  (clos-browser::real-add-root (
                                 clos-browser::clos-browser
                                                ))
                  (web:shape-to-hold (
                                 clos-browser::clos-browser
                                      ))
                  (clos-browser::contains-p (
                                        pcl::standard-class
                                             
                                 clos-browser::clos-browser
                                             ))
                                   (il:* il:\; 
                                   "multi-method")
)
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "CLOS-BROWSER-NODE CLASS")

           (pcl::classes clos-browser::clos-browser-node)
           (pcl::methods (clos-browser::object-name (
                            clos-browser::clos-browser-node
                                                     ))
                  (clos-browser::override (
                            clos-browser::clos-browser-node
                                           ))
                  (clos-browser::cache (t 
                            clos-browser::clos-browser-node
                                          ))
                  (clos-browser::uncache (
                            clos-browser::clos-browser-node
                                          )))
           (il:vars (clos-browser::*method-prompt-string*
                     (concatenate 'string 
                          "Left button to edit the method." 
                            "
" "Middle button provides a menu of operations.")))
           (il:functions 
                  clos-browser::make-method-menu-items 
             clos-browser::make-top-level-method-menu-items 
                  clos-browser::make-multi-method-sub-menu)
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "OPERATORS (via CLOS-BROWSER-NODE) ON CLOS::STANDARD-CLASS")

           (pcl::methods (pcl:add-method (
                            clos-browser::clos-browser-node
                                          ))
                  (clos-browser::browse-subs (
                            clos-browser::clos-browser-node
                                              ))
                  (clos-browser::edit-class (
                            clos-browser::clos-browser-node
                                             ))
                  (clos-browser::inspect-class (
                            clos-browser::clos-browser-node
                                                ))
                  (clos-browser::menu-methods (
                            clos-browser::clos-browser-node
                                               ))
                  (clos-browser::make-whenselectedfn (
                            clos-browser::clos-browser-node
                                                      ))
                  (clos-browser::describe-class (
                            clos-browser::clos-browser-node
                                                 ))
                  (clos-browser::documentation-class (
                            clos-browser::clos-browser-node
                                                      ))
                  (clos-browser::print-class (
                            clos-browser::clos-browser-node
                                              ))
                  (clos-browser::specialize-class (
                            clos-browser::clos-browser-node
                                                   )))
           (il:functions clos-browser::complete-add-method 
                  clos-browser::complete-specialize 
                  clos-browser::lyric-complete-specialize 
                  clos-browser::this-class-node-p)
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| 
      "OPERATORS ON CLOS::STANDARD-CLASS (directly)")

           (pcl::methods (pcl::compute-inherited-methods
                          (pcl::standard-class))
                  (clos-browser::specialize (
                                        pcl::standard-class
                                             )))
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "OPERATORS ON CLOS::STANDARD-METHOD")

           (pcl::methods (clos-browser::delete (
                                       pcl::standard-method
                                                ))
                                   (il:* il:\; 
                         "note cl:delete is shadowed above")

                  (clos-browser::copy (pcl::standard-method
                                       pcl::standard-class)
                         )
                  (clos-browser::move (pcl::standard-method
                                       pcl::standard-class)
                         )
                                   (il:* il:\; 
                               "web:move is shadowed above")

                  (clos-browser::print-definition (
                                       pcl::standard-method
                                                   ))
                  (clos-browser::rename (
                                       pcl::standard-method
                                         ))
                  (clos-browser::update-cached-menues
                   (pcl::standard-method))
                  (clos-browser::who-owns (
                                       pcl::standard-method
                                           ))
                  
      
      (il:* il:|;;| "update-cached-menues must appear before add-method :after in the coms")

                  (pcl:add-method :after (
                             pcl::standard-generic-function
                                          
                                       pcl::standard-method
                                          )))
           (il:functions clos-browser::replace-specializers
                  )
           
      
      (il:* il:|;;| "")

           

(il:* il:|;;;| "SETUP RELEASE INFO")

           (il:vars (clos-browser::release-id "0.02")
                  (clos-browser::system-date
                   (caar (il:getprop 'il:clos-browser
                                'il:filedates))))
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "SETUP LAFITE FORM")

           (il:functions 
                  clos-browser::make-xclose-lafite-form)
           (il:addvars (il:lafitespecialforms
                        ("CLOS Report" '
                      clos-browser::make-xclose-lafite-form 
              "Report bug or request new feature for CLOS."
                               )))
           (il:p (setq il:lafiteformsmenu nil))
           
      
      (il:* il:|;;| "")

           
      
      (il:* il:|;;| "SETUP BACKGROUND MENU")

           (il:functions clos-browser::in-select-package 
                  clos-browser::classes-in-package)
           (il:p
            
      
      (il:* il:|;;| "pushnew should eliminate this")

            (setq il:|BackgroundMenuCommands|
                  (remove 'il:|BrowseClass| 
                         il:|BackgroundMenuCommands| :key
                         #'car))
            (push
             '(il:|BrowseClass|
               (clos-browser:browse-class)
               "Bring up a class browser."
               (il:subitems (il:|all in a package|
                             (clos-browser:browse-class
                              (
                           clos-browser::classes-in-package
                               (
                            clos-browser::in-select-package
                                )))
                             "Select a package and browse all the classes defined in that package."
                             ))) 
             il:|BackgroundMenuCommands|)
            (setq il:|BackgroundMenu| nil))))



(il:* il:|;;;| "***************************************")




(il:* il:|;;;| 
" Copyright (c) 1988 by Xerox Corporation.  All rights reserved."
)




(il:* il:|;;;| 
"Use and copying of this software and preparation of derivative works based upon this software are permitted.  Any distribution of this software or derivative works must comply with all applicable United States export control laws."
)




(il:* il:|;;;| 
"This software is made available AS IS, and Xerox Corporation makes no  warranty about the software, its performance or its conformity to any specification."
)




(il:* il:|;;;| 
"Any person obtaining a copy of this software is requested to send their name and post office or electronic mail address to:"
)




(il:* il:|;;;| "   CLOS Coordinator")




(il:* il:|;;;| "   Xerox Artifical Intelligence Systems   ")




(il:* il:|;;;| "   2550 Hanover St.")




(il:* il:|;;;| "   Palo Alto, CA 94303")




(il:* il:|;;;| 
"(or send internet mail to CLOSSupport.pa@Xerox.arpa)")




(il:* il:|;;;| " ****************************************")




(il:* il:|;;;| "")




(il:* il:|;;;| "Print out a copyright notice when loading")




(il:* il:|;;| "")

(format t "~&;CLOS-BROWSER Copyright (c) 1988, Xerox Corporation.  All rights reserved.~%"
       )



(il:* il:|;;;| "LOAD DEPENDENT MODULES")




(il:* il:|;;| "Note: before compiling clos-browser:")




(il:* il:|;;| "    (load 'web-editor.dfasl)")




(il:* il:|;;| "    (load 'clos-browser.dfasl)")




(il:* il:|;;| "    (load 'clos-browser 'prop)")

(unless (or (eq il:makesysname ':lyric)
            (il:getprop 'il:pcl-env 'il:filedates))
       (il:filesload il:clos-environment))
(il:filesload il:web-editor il:ed-patch)



(il:* il:|;;| "")




(il:* il:|;;;| "PACKAGE STUFF ")


(il:putprops il:clos-browser il:makefile-environment 
             (:package (let ((*package*))
                            
      
      (il:* il:|;;| "create the CLOS-BROWSER package")

                            (in-package "CLOS-BROWSER")
                            
      
      (il:* il:|;;| "make the file in the USER package")

                            (find-package "USER"))
                    :readtable "XCL" :base 10))

(il:putprops il:clos-browser il:filetype :compile-file)

(il:rpaqq clos-browser-package-commands 
          ((let
            ((*package*))
            
      
      (il:* il:|;;| 
      "avoid symbol conflicts in lyric with Medley code")

            (unless (find-package "SEDIT")
                   (xcl:defpackage "SEDIT"))
            
      
      (il:* il:|;;| 
   "Put IN Seven EXtremely Random USEr Interface COmmands ")

            (provide "CLOS-BROWSER")
            
      
      (il:* il:|;;| "IN")

            (if (find-package "CLOS")
                (in-package "CLOS" :nicknames '("PCL"))
                (in-package "PCL" :nicknames '("CLOS")))
            (in-package "CLOS-BROWSER")
            
      
      (il:* il:|;;| "SHADOW")

                                   (il:* il:\; 
            "has to be after the USE due to Xerox Lisp bug")

            
      
      (il:* il:|;;| "EXPORT")

            (flet
             ((export-from-pkg
               (symbol-names from)
               (let ((pkg (find-package from)))
                    (dolist (name symbol-names)
                           (export (intern name pkg)
                                  pkg)))))
             (export-from-pkg '("BROWSE-CLASS" "CLOS-ICON") 
                    "CLOS-BROWSER"))
            
      
      (il:* il:|;;| "REQUIRE")

                                   (il:* il:\; 
                             "handled via il:files command")

            
      
      (il:* il:|;;| "USE")

            (use-package '("WEB" "PCL" "LISP" "XCL"))
            
      
      (il:* il:|;;| "SHADOW")

            (let ((my-package (find-package "CLOS-BROWSER")
                         ))
                 (flet ((hog-the-symbol-for-myself
                         (&rest symbol-names)
                         (dolist (name symbol-names)
                                (shadow (intern name 
                                               my-package)
                                       my-package))))
                       
      
      (il:* il:|;;| "From CL")

                       (hog-the-symbol-for-myself "DELETE")
                       
      
      (il:* il:|;;| "From WEB")

                       (hog-the-symbol-for-myself "MOVE")))
            
      
      (il:* il:|;;| "IMPORT")

            (flet
             ((il:import-from-package
               (il:names il:from &optional il:shadow-p)
               (let
                ((il:from-package (find-package il:from)))
                (funcall (if il:shadow-p #'shadowing-import
                             #'import)
                       (mapcar #'(lambda (il:name)
                                        (intern il:name 
                                            il:from-package
                                               )) il:names)
                       ))))
             (il:import-from-package '("CBOUNDP" 
                                             "CLASS-NAME" 
                                             "SYMBOL-CLASS"
                                             ) "PCL")))))
(let
 ((*package*))
      
      (il:* il:|;;| 
      "avoid symbol conflicts in lyric with Medley code")

 (unless (find-package "SEDIT")
        (xcl:defpackage "SEDIT"))
      
      (il:* il:|;;| 
   "Put IN Seven EXtremely Random USEr Interface COmmands ")

 (provide "CLOS-BROWSER")
      
      (il:* il:|;;| "IN")

 (if (find-package "CLOS")
     (in-package "CLOS" :nicknames '("PCL"))
     (in-package "PCL" :nicknames '("CLOS")))
 (in-package "CLOS-BROWSER")
      
      (il:* il:|;;| "SHADOW")

                                   (il:* il:\; 
            "has to be after the USE due to Xerox Lisp bug")

      
      (il:* il:|;;| "EXPORT")

 (flet ((export-from-pkg (symbol-names from)
               (let ((pkg (find-package from)))
                    (dolist (name symbol-names)
                           (export (intern name pkg)
                                  pkg)))))
       (export-from-pkg '("BROWSE-CLASS" "CLOS-ICON") 
              "CLOS-BROWSER"))
      
      (il:* il:|;;| "REQUIRE")

                                   (il:* il:\; 
                             "handled via il:files command")

      
      (il:* il:|;;| "USE")

 (use-package '("WEB" "PCL" "LISP" "XCL"))
      
      (il:* il:|;;| "SHADOW")

 (let ((my-package (find-package "CLOS-BROWSER")))
      (flet ((hog-the-symbol-for-myself
              (&rest symbol-names)
              (dolist (name symbol-names)
                     (shadow (intern name my-package)
                            my-package))))
            
      
      (il:* il:|;;| "From CL")

            (hog-the-symbol-for-myself "DELETE")
            
      
      (il:* il:|;;| "From WEB")

            (hog-the-symbol-for-myself "MOVE")))
      
      (il:* il:|;;| "IMPORT")

 (flet
  ((il:import-from-package
    (il:names il:from &optional il:shadow-p)
    (let ((il:from-package (find-package il:from)))
         (funcall (if il:shadow-p #'shadowing-import
                      #'import)
                (mapcar #'(lambda (il:name)
                                 (intern il:name 
                                        il:from-package)) 
                       il:names)))))
  (il:import-from-package '("CBOUNDP" "CLASS-NAME" 
                                  "SYMBOL-CLASS") "PCL")))



(il:* il:|;;| "")




(il:* il:|;;;| "SYSTEM PATCHES")




(il:* il:|;;| 
"initialize built-in-class-of so compiler use of a gf does not infinitely recurse"
)

(pcl:class-of 1)



(il:* il:|;;| "fix a bug in format statement")


(defun pcl::load-defmethod-internal (clos-browser::gf-spec
                                     
                                   clos-browser::qualifiers 
                                 clos-browser::specializers 
                                  clos-browser::lambda-list 
                                     clos-browser::doc 
                                     clos-browser::fn 
                                     clos-browser::uid 
                                 clos-browser::method-class
                                     )
   (let ((clos-browser::method (pcl::add-named-method
                                clos-browser::gf-spec 
                                clos-browser::qualifiers 
                                clos-browser::specializers 
                                clos-browser::lambda-list 
                                clos-browser::fn 
                                :documentation 
                                clos-browser::doc)))
        (unless (or (eq clos-browser::method-class
                        'pcl::standard-method)
                    (eq (pcl::symbol-class 
                               clos-browser::method-class t
                               )
                        (pcl:class-of clos-browser::method)
                        ))
               (format *error-output*
                      (concatenate 'string 
        "~%At the time the method with qualifiers ~S and~%" 
             "specializers ~S on the generic function ~S~%" "was compiled, the method-class for that generic function was~%" 
             "~S.  But, the method class is now ~S, this~%" 
     "may mean that this method was compiled improperly.~%"
                             )
                      clos-browser::qualifiers 
                      clos-browser::specializers 
                      clos-browser::gf-spec 
                      clos-browser::method-class
                      (pcl::class-name (pcl:class-of 
                                       clos-browser::method
                                              ))))
        (set clos-browser::uid clos-browser::method)))




(il:* il:|;;| "")




(il:* il:|;;| "PCL extensions to match CLOS")


(defun pcl::symbol-class (pcl::class-name &optional 
                                clos-browser::environment)
   (if pcl::class-name (pcl:class-named pcl::class-name 
                              clos-browser::environment)
       (error "NIL is not a valid class name.")))


(defun pcl::cboundp (symbol) (xcl:ignore-errors
                              (pcl::symbol-class symbol)))




(il:* il:|;;| "")




(il:* il:|;;| "PCL internal extensions")


(pcl:defmethod pcl::method-named (clos-browser::method-spec
                                  ) 
              "Return the method named by the method-spec."
   (let
    ((clos-browser::gf (pcl::gdefinition (car 
                                  clos-browser::method-spec
                                              )))
     (clos-browser::qualifiers (when (> (length 
                                  clos-browser::method-spec
                                               )
                                        2)
                                     (cadr 
                                  clos-browser::method-spec
                                           )))
     (clos-browser::specializers
      (il:for clos-browser::specializer-name
         il:in (car (last clos-browser::method-spec))
         il:collect (pcl::symbol-class 
                           clos-browser::specializer-name))
      ))
      
      (il:* il:|;;| "fill out the needed missing unspecialized parameters required by get-method as specializers")

    (let ((clos-browser::number-of-specializers
           (length (pcl:slot-value
                    (first (pcl:slot-value clos-browser::gf
                                  'pcl::methods))
                    'pcl::type-specifiers))))
         (dotimes (clos-browser::t-classes
                   (- clos-browser::number-of-specializers
                      (length clos-browser::specializers)))
                (setq clos-browser::specializers
                      (append clos-browser::specializers
                             (list (pcl:class-named t))))))
    (pcl:get-method clos-browser::gf 
           clos-browser::qualifiers 
           clos-browser::specializers)))


(pcl:defmethod clos-browser::subclasses-of ((
                                        clos-browser::class
                                             
                                        pcl::standard-class
                                             ))
   (append (list clos-browser::class)
          (il:for clos-browser::subclass
             il:in (pcl:slot-value clos-browser::class
                          'pcl::direct-subclasses)
             il:join (if (pcl:slot-value 
                                clos-browser::subclass
                                'pcl::direct-subclasses)
      
      (il:* il:|;;| 
      "then recursively collect the sub classes")

                         (clos-browser::subclasses-of
                          clos-browser::subclass)
      
      (il:* il:|;;| "otherwise just return this leaf")

                         (list clos-browser::subclass)))))




(il:* il:|;;| "")




(il:* il:|;;| "specialize il:getdef ")

(unless (pcl::generic-function-p (symbol-function
                                  `il:getdef))
       (pcl::make-specializable 'il:getdef :arglist
              '(il:object &optional type il:source 
                      il:options)))

(pcl:defmethod il:getdef ((clos-browser::self 
                                 pcl::standard-class)
                          &optional ignore 
                          clos-browser::source 
                          clos-browser::options)
   (il:getdef (pcl::class-name clos-browser::self)
          `il:classes clos-browser::source 
          clos-browser::options))


(pcl:defmethod il:getdef ((clos-browser::self 
                                 pcl::standard-method)
                          &optional ignore il:source 
                          il:options) (il:getdef
                                       (
                                      pcl::full-method-name
                                        clos-browser::self 
                                        nil)
                                       'il:method il:source 
                                       il:options))




(il:* il:|;;| "")




(il:* il:|;;;| "CLOS-ICON CLASS & INSTANCE INITIALIZATION")


(pcl:defclass clos-browser:clos-icon (pcl::object)
   ((clos-browser::class-browsers :allocation :class 
           :initform nil)          (il:* il:\; 
                                "list of all open browsers")

    (clos-browser::destination-browser :allocation :class 
           :initform nil)          (il:* il:\; 
                            "browser containing boxed node")

    (clos-browser::menu-cache-switch :allocation :class 
           :initform :lazy 
      
      (il:* il:|;;| "valid values:")
      
      (il:* il:|;;| ":none for never use cache")
      
      (il:* il:|;;| ":lazy for invalidate cache at method create or remove time causing re-compute and cache at menu request time.")
      
      (il:* il:|;;| ":eager (not implemented) for re-compute and cache menu whenever a method is created or removed")

           )))


(xcl:defglobalparameter clos-browser:clos-icon (
                                          pcl:make-instance
                                                '
                                     clos-browser:clos-icon
                                                ) )




(il:* il:|;;| "")




(il:* il:|;;;| "CLOS-BROWSER CLASS")


(defun clos-browser:browse-class (&optional 
                           clos-browser::class-name-or-list 
                                        &key (
                                    clos-browser::direction
                                              :sub)
                                        (
                              clos-browser::window-or-title
                                         "CLOS-browser")
                                        
                                 clos-browser::good-classes 
                                        position)
   (let* ((clos-browser::root-classes
           (when clos-browser::class-name-or-list
                 (if (listp 
                           clos-browser::class-name-or-list
                            )
                     (mapcar #'pcl::symbol-class 
                           clos-browser::class-name-or-list
                            )
                     (cons (pcl::symbol-class 
                           clos-browser::class-name-or-list
                                  )))))
          (clos-browser::nodes (clos-browser::make-nodes
                                (
                               clos-browser::collect-family
                                 nil 
                                 clos-browser::root-classes
                                 )))
          (clos-browser::clos-browser (pcl:make-instance
                                       '
                                 clos-browser::clos-browser
                                       )))
         (web:initialize-editor clos-browser::clos-browser)
         (setf (pcl:slot-value clos-browser::clos-browser
                      'clos-browser::root-classes)
               clos-browser::root-classes)
         (setf (pcl:slot-value clos-browser::clos-browser
                      'clos-browser::title)
               clos-browser::class-name-or-list)
         (web:browse clos-browser::clos-browser 
                clos-browser::nodes 
                clos-browser::window-or-title 
                clos-browser::good-classes position)
         (unless clos-browser::nodes (
                                     clos-browser::add-root
                                      
                                 clos-browser::clos-browser
                                      ))
         clos-browser::clos-browser))


(defun clos-browser::collect-family (clos-browser::family
                                     
                                   clos-browser::class-list
                                     ) "gather all of the sub-classes of the class passed as family"
      
      (il:* il:|;;| "for efficiency, to avoid gathering and filtering subclasses more than once, we assume family only contains classes whose family has already been gathered.")

   (if clos-browser::class-list
       (let ((clos-browser::first-class (car 
                                   clos-browser::class-list
                                             ))
             (rest (cdr clos-browser::class-list)))
            (if (member clos-browser::first-class 
                       clos-browser::family)
                (progn 
      
      (il:* il:|;;| 
      "skip gathering class-direct-subclasses ")

                       (clos-browser::collect-family 
                              clos-browser::family rest))
                (progn (push clos-browser::first-class 
                             clos-browser::family)
                       (clos-browser::collect-family
                        clos-browser::family
                        (append rest (
                               pcl::class-direct-subclasses
                                      
                                  clos-browser::first-class
                                      ))))))
       clos-browser::family))


(defun clos-browser::make-nodes (clos-browser::class-list)
   (let*
    ((clos-browser::node-hash (make-hash-table))
     (clos-browser::node-list
      (map 'list
           #'(lambda (clos-browser::class
                      &aux
                      (clos-browser::node
                       (pcl:make-instance '
                            clos-browser::clos-browser-node
                              )))
                    (setf (pcl:slot-value 
                                 clos-browser::node
                                 'clos-browser::class)
                          clos-browser::class)
                    (setf (web:node-name clos-browser::node
                                 )
                          (pcl::class-name 
                                 clos-browser::class))
                    (setf (gethash clos-browser::class 
                                 clos-browser::node-hash)
                          clos-browser::node)
                    clos-browser::node) 
           clos-browser::class-list)))
    (dolist (clos-browser::node clos-browser::node-list)
           (setf (web:node-links clos-browser::node)
                 (map 'list #'(lambda (clos-browser::sub)
                                     (gethash 
                                          clos-browser::sub 
                                    clos-browser::node-hash
                                            ))
                      (pcl::class-direct-subclasses
                       (pcl:slot-value clos-browser::node
                              'clos-browser::class)))))
    clos-browser::node-list))


(defun clos-browser::clos-browser-close-fn (
                                       clos-browser::window
                                            )
   (let ((clos-browser::browser (il:windowprop 
                                       clos-browser::window
                                       'web:web-editor)))
        (setf (pcl:slot-value clos-browser:clos-icon
                     'clos-browser::class-browsers)
              (remove clos-browser::browser
                     (pcl:slot-value clos-browser:clos-icon
                            'clos-browser::class-browsers))
              )
        (when (eq clos-browser::browser (pcl:slot-value
                                         
                                     clos-browser:clos-icon
                                         '
                          clos-browser::destination-browser
                                         ))
              (setf (pcl:slot-value clos-browser:clos-icon
                           '
                          clos-browser::destination-browser
                           )
                    nil))))


(defun clos-browser::browser-contains-p (
                                        clos-browser::class
                                         
                                      clos-browser::browser
                                         ) "created because too slow to call contains-p method inside a tight loop"
   (let ((clos-browser::node
          (car (member clos-browser::class
                      (pcl:slot-value clos-browser::browser
                             'web::starting-list)
                      :test
                      #'clos-browser::this-class-node-p))))
        (when (and clos-browser::node
                   (not (member clos-browser::class
                               (pcl:slot-value 
                                      clos-browser::browser
                                      'web::bad-list)
                               :test
                               #'
                            clos-browser::this-class-node-p
                               )))
              clos-browser::node)))


(pcl:defclass clos-browser::clos-browser (web:web-editor)
   ((clos-browser::root-classes)
    (web:title-items :allocation :instance 
      
      (il:* il:|;;| 
      "Items for menu of selections in title of window")

           :initform
           '(("Recompute" web:recompute 
                  "Recompute lattice from starting objects"
                    (il:subitems ("Recompute" web:recompute 
                  "Recompute lattice from starting objects"
                                        )
                           ("Recompute labels" 
                                  web:recompute-labels 
                                  "Recomputes the labels")
                           ("Recompute in place" 
                                  web:recompute-in-place 
                 "Recompute keeping current view in window"
                                  )
                           ("Clear caches" 
                     clos-browser::clear-method-menu-caches 
                          "Clear cached menues of methods."
                                  )))
             ("Browser looks" nil ""
                    (il:subitems ("Shape to hold" 
                                        web:shape-to-hold 
     "Make window large or small enough to just hold graph"
                                        )
                           ("Change font size" 
                                  web:change-font-size 
                                  "Choose a new size Font")
                           ("Change format" 
                                  web:change-format 
                   "Change format between lattice and tree"
                                  )))
             ("Add root " clos-browser::add-root 
              "Add named item to startingList for browser."
                    (il:subitems ("all in a package" 
                                    clos-browser::add-roots 
        "Add all the classes in a package to this browser."
                                        )))
      
      (il:* il:|;;| "(\"Unhide class\" remove-from-bad-list \"Restore item previously deleted from browser\")")

             ))
    (web:left-button-items :allocation :class 
      
      (il:* il:|;;| "Menu items for LeftButton seletion -- Value sent as message to object or browser -- see local-commands")

           :initform web::box-node)
    (web:middle-button-items
     :allocation :instance 
      
      (il:* il:|;;| "Menu items for MiddleButton seletion -- Value sent as message to object or browser -- see local-commands")

     :initform
     '(("Edit" clos-browser::edit-class "Edit the class."
              (il:subitems ("Edit" clos-browser::edit-class 
                                  "Edit the class.")
                     ("Inspect" clos-browser::inspect-class 
                      "Bring up an inspector on the class."
                            )
                     ("Rename" clos-browser::rename-class 
                            "Not Implemented")
                     ("Delete" clos-browser::delete-class 
                            "Not Implemented")))
       ("Add method" (pcl:add-method nil)
              "Add a method to the class.")
       ("Browse" clos-browser::browse-subs 
              "Bring up a browser on this class."
              (when nil            (il:* il:\; 
                             "superclasses not implemented")

                    (il:subitems ("sub classes" 
                                  clos-browser::browse-subs 
                        "Bring up a browser on this class."
                                        )
                           ("super classes" 
                                clos-browser::browse-supers 
                                  "Not Implemented"))))
       ("Print" clos-browser::print-class 
              "Print the form defining the class."
              (il:subitems ("Print" 
                                  clos-browser::print-class 
                       "Print the form defining the class."
                                  )
                     ("Describe" 
                            clos-browser::describe-class 
                        "Print a description of the class."
                            )
                     ("Documentation" 
                          clos-browser::documentation-class 
                 "Display the documentation for the class."
                            )))
       ("Specialize" clos-browser::specialize-class 
              "Create a new sub-class of this class.")
       ("------" clos-browser::edit-class "Above this line operates on the class.
Below this line operates on individual slots and methods.")
       ("slots" clos-browser::edit-class 
              "Edit the defclass definition." nil
              (il:subitems ("local" 
                                  clos-browser::edit-class 
                                  "Not Implemented")
                     ("inherited" clos-browser::edit-class 
                            "Not Implemented")
                     ("all" clos-browser::edit-class 
                            "Not Implemented")))
       ("methods" (clos-browser::menu-methods)
              
             "Build a menu of methods local to this class."
              (il:subitems
               ("local" (clos-browser::menu-methods)
                      
       "Show a menu of methods specialized on this class.."
                      (il:subitems ("Use cached menu"
                                    (
                                 clos-browser::menu-methods
                                     )
                                    
                     "Do not recompute the menu of methods"
                                    )
                             ("Recompute menu" (
                                 clos-browser::menu-methods
                                                nil nil nil 
                                                t)
                                    
                            "Recompute the menu of methods"
                                    )))
               ("inherited" (clos-browser::menu-methods
                             :inherited)
                      
               "Show only methods inherited by this class."
                      (il:subitems ("Use cached menu"
                                    (
                                 clos-browser::menu-methods
                                     :inherited)
                                    
                     "Do not recompute the menu of methods"
                                    )
                             ("Recompute menu" (
                                 clos-browser::menu-methods
                                                :inherited 
                                                nil nil t)
                                    
                            "Recompute the menu of methods"
                                    )))
               ("all" (clos-browser::menu-methods :all)
                      
               "Show all methods understood by this class."
                      (il:subitems ("Use cached menu"
                                    (
                                 clos-browser::menu-methods
                                     :all)
                                    
                     "Do not recompute the menu of methods"
                                    )
                             ("Recompute menu" (
                                 clos-browser::menu-methods
                                                :all nil 
                                                nil t)
                                    
                            "Recompute the menu of methods"
                                    )))))))
    (clos-browser::title :initform "CLOS Browser" 
                                   (il:* il:\; 
                          "Title passed to GRAPHER package")
)))


(pcl:defmethod clos-browser::add-root ((
                                      clos-browser::browser
                                        
                                 clos-browser::clos-browser
                                        )
                                       &optional
                                       (
                                     clos-browser::new-item
                                        (
                                     clos-browser::new-item
                                         
                                      clos-browser::browser
                                         ))) 
    "Add a named item to the starting list of the browser "
   (if (clos-browser::real-add-root clos-browser::browser 
              clos-browser::new-item)
       (web:recompute clos-browser::browser)
      
      (il:* il:|;;| "otherwise warn the user")

       (web:prompt-print clos-browser::browser
              (format nil "~A not added to browser." 
                     clos-browser::new-item))))


(pcl:defmethod clos-browser::add-roots ((
                                      clos-browser::browser
                                         
                                 clos-browser::clos-browser
                                         )
                                        &optional
                                        (
                                    clos-browser::new-items
                                         (
                           clos-browser::classes-in-package
                                          (
                            clos-browser::in-select-package
                                           )))) "Add all classes in a package to the starting list of the browser"
   (dolist (clos-browser::class clos-browser::new-items)
          (unless (clos-browser::real-add-root 
                         clos-browser::browser 
                         clos-browser::class)
                 (web:prompt-print clos-browser::browser
                        (format nil 
                               "~A not added to browser." 
                               clos-browser::class))))
   (web:recompute clos-browser::browser))


(pcl:defmethod web::box-node ((clos-browser::browser 
                                 clos-browser::clos-browser
                                     )
                              clos-browser::object 
                            clos-browser::keep-previous-box
                              ) (pcl:call-next-method)
                                (setf (pcl:slot-value
                                       
                                     clos-browser:clos-icon
                                       '
                          clos-browser::destination-browser
                                       )
                                      clos-browser::browser
                                      ))


(pcl:defmethod web:browse ((clos-browser::self 
                                 clos-browser::clos-browser
                                  )
                           &optional 
                           clos-browser::browse-list 
                           clos-browser::window-or-title 
                           clos-browser::good-list position
                           )
   (let ((clos-browser::browser (pcl:call-next-method)))
        (pushnew clos-browser::browser (pcl:slot-value
                                        
                                     clos-browser:clos-icon
                                        '
                               clos-browser::class-browsers
                                        ))))


(pcl:defmethod clos-browser::clear-method-menu-caches ((
                                         clos-browser::self
                                                        
                                 clos-browser::clos-browser
                                                        ))
   (dolist (clos-browser::node (pcl:slot-value 
                                      clos-browser::self
                                      '
                                clos-browser::starting-list
                                   (il:* il:\; 
    "starting-list is really all the nodes in the browser.")

                                      ))
          (setf (pcl:slot-value clos-browser::node
                       'clos-browser::menu-cache)
                nil)))


(pcl:defmethod web:icon-title ((clos-browser::self 
                                 clos-browser::clos-browser
                                      ))
   (web:node-name (car (last (pcl:slot-value 
                                    clos-browser::self
                                    `web::starting-list)))))


(pcl:defmethod web:initialize-editor ((
                                      clos-browser::browser
                                       
                                 clos-browser::clos-browser
                                       )) 
                             "initialize and setup closefn"
   (pcl:call-next-method)
   (pushnew clos-browser::browser (pcl:slot-value
                                   clos-browser:clos-icon
                                   '
                               clos-browser::class-browsers
                                   ))
   (let ((clos-browser::window (pcl:slot-value 
                                      clos-browser::browser
                                      'web::window)))
        (il:windowaddprop clos-browser::window 'il:closefn
               'clos-browser::clos-browser-close-fn t))
   clos-browser::browser)


(pcl:defmethod clos-browser::new-item ((clos-browser::self
                                        
                                 clos-browser::clos-browser
                                        )
                                       &optional 
                                     clos-browser::new-item
                                       )
   (unless clos-browser::new-item (setq 
                                     clos-browser::new-item
                                        (web:prompt-read
                                         clos-browser::self 
                                         "Class"))))


(pcl:defmethod web:recompute ((clos-browser::self 
                                 clos-browser::clos-browser
                                     )
                              &optional 
                             clos-browser::dont-reshape-flg
                              ) 
      
      (il:* il:|;;| "this should be moved to a more intelligent recompute-nodes function that does not have to re-build every single node.")

   (setf
    (pcl:slot-value clos-browser::self 'web::starting-list)
    (clos-browser::make-nodes
     (clos-browser::collect-family
      nil
      (il:for clos-browser::each
         il:in (reverse            (il:* il:\; 
                   "so they come out in the original order")

                      (pcl:slot-value clos-browser::self
                             'web::starting-list))
         il:when clos-browser::each
         il:collect (pcl:slot-value clos-browser::each
                           `clos-browser::class)))))
   (pcl:call-next-method)
   (when (pcl:slot-value clos-browser:clos-icon
                'clos-browser::destination-browser)
      
      (il:* il:|;;| "Node has been invalidated, so get rid of this pointer to it. ")

         (setf (pcl:slot-value (pcl:slot-value 
                                     clos-browser:clos-icon
                                      '
                          clos-browser::destination-browser
                                      )
                      'web::boxed-node)
               nil)
         (setf (pcl:slot-value clos-browser:clos-icon
                      'clos-browser::destination-browser)
               nil)))


(pcl:defmethod clos-browser::real-add-root ((
                                      clos-browser::browser
                                             
                                 clos-browser::clos-browser
                                             )
                                            
                                        clos-browser::class
                                            ) 
          "Add a class to the starting list of the browser"
   (when
    clos-browser::class
    (let* ((clos-browser::class (if (typep 
                                        clos-browser::class
                                           '
                                        pcl::standard-class
                                           )
                                    clos-browser::class
                                    (pcl::symbol-class
                                     clos-browser::class)))
           (clos-browser::new-node
            (car (clos-browser::make-nodes (list 
                                        clos-browser::class
                                                 )))))
          (if clos-browser::new-node
              (progn (pushnew clos-browser::new-node
                            (pcl:slot-value 
                                   clos-browser::browser
                                   'web::starting-list))
                     (if (pcl:slot-value 
                                clos-browser::browser
                                'web::good-list)
                         (pushnew clos-browser::new-node
                                (pcl:slot-value
                                 clos-browser::browser
                                 'web::good-list)))
                     (setf (pcl:slot-value 
                                  clos-browser::browser
                                  'web::bad-list)
                           (il:dremove 
                                  clos-browser::new-node
                                  (pcl:slot-value
                                   clos-browser::browser
                                   'web::bad-list)))
                     clos-browser::browser)
      
      (il:* il:|;;| "otherwise return nil")

              nil))))


(pcl:defmethod web:shape-to-hold ((web::self 
                                 clos-browser::clos-browser
                                         )) "give a larger width for empty browsers so add-node will have room"
   (let*
    ((web::window (pcl:slot-value web::self 'web::window))
     (web::nodes (il:|fetch| il:graphnodes
                    il:|of| (il:windowprop web::window
                                   'il:graph))))
    (if
     web::nodes
     (pcl:call-next-method)
     (let ((web::region (il:windowprop web::window
                               'il:region))
           (web::min-height (il:fontheight (il:dspfont
                                            nil web::window
                                            )))
           (web::min-width
            (max 250 (il:iplus 5 (il:stringwidth
                                  (pcl:slot-value
                                   web::self
                                   'web::title)
                                  (il:dspfont nil 
                              il:|WindowTitleDisplayStream|
                                         ))))))
          (web::set-region web::self
                 (il:createregion (il:|fetch| il:left
                                     il:|of| web::region)
                        (il:|fetch| il:bottom il:|of|
                                              web::region)
                        web::min-width web::min-height))))))


(pcl:defmethod clos-browser::contains-p ((
                                        clos-browser::class
                                          
                                        pcl::standard-class
                                          )
                                         (
                                      clos-browser::browser
                                          
                                 clos-browser::clos-browser
                                          ))
   (let ((clos-browser::node
          (car (member clos-browser::class
                      (pcl:slot-value clos-browser::browser
                             'web::starting-list)
                      :test
                      #'clos-browser::this-class-node-p))))
        (when (and clos-browser::node
                   (not (member clos-browser::class
                               (pcl:slot-value 
                                      clos-browser::browser
                                      'web::bad-list)
                               :test
                               #'
                            clos-browser::this-class-node-p
                               )))
              clos-browser::node)))




(il:* il:|;;| "")




(il:* il:|;;;| "CLOS-BROWSER-NODE CLASS")


(pcl:defclass clos-browser::clos-browser-node (web:web-node
                                               )
   ((clos-browser::class           (il:* il:\; 
                       "The class represented by this node")
)
    (clos-browser::menu-cache)     (il:* il:\; "Menus of methods and slots.  See clos-icon for the switch that controls when this gets updated.")

    (clos-browser::large-menu-size :allocation :class 
           :initform 22)
    (clos-browser::large-menu-font
     :allocation :instance :initform
     (il:fontcreate `(il:helvetica 8)))
    (clos-browser::local-method-operations
     :allocation :instance :initform
     '(("Edit" 'ed 
         "Bring up the editor on this method's definition."
              (il:subitems ("Inspect" 'inspect 
                                  "Inspect this method")))
       ("Print" 'clos-browser::print-definition 
              "Pretty Print this method's definition."
              (il:subitems ("Print" 'print 
                          "Print this method's definition."
                                  )
                     ("Describe" 'describe 
                            "Describe this method.")
                     ("Documentation" 'documentation 
                       "Print this method's documentation."
                            )))
       ("Delete" 'clos-browser::delete 
              "Remove this method.")
       ("Copy" 'clos-browser::copy 
              "Copy this method to boxed class.")
       ("Move" 'clos-browser::move 
              "Move this method to boxed class.")
       ("Rename" 'clos-browser::rename 
   "Change the name of this method to new name you specify"
              )
       ("Break" 'pcl::break-method 
    "Cause a break window whenever this method is invoked."
              )
       ("Trace" 'pcl::trace-method "Trace this method.")
       ("UnBreak" 'pcl::unbreak-method 
              "Unbreak this method.")))
    (clos-browser::inherited-method-operations
     :allocation :instance :initform
     '(("Edit" 'ed 
         "Bring up the editor on this method's definition."
              (il:subitems ("Inspect" 'inspect 
                                  "Inspect this method")))
       ("Print" 'clos-browser::print-definition 
              "Pretty Print this method's definition."
              (il:subitems ("Print" 'print 
                          "Print this method's definition."
                                  )
                     ("Describe" 'describe 
                            "Describe this method.")
                     ("Documentation" 'documentation 
                       "Print this method's documentation."
                            )))
       ("Override" 'clos-browser::override 
              "Create a local method with this name.")
       ("Break" 'pcl::break-method 
    "Cause a break window whenever this method is invoked."
              )
       ("Trace" 'pcl::trace-method "Trace this method.")
       ("UnBreak" 'pcl::unbreak-method 
              "Unbreak this method.")
       ("Who owns" 'clos-browser::who-owns 
    "Show the classes on which this method is specialized."
              )))
    (clos-browser::all-method-operations
     :allocation :instance :initform
     '(("Edit" 'ed 
         "Bring up the editor on this method's definition."
              (il:subitems ("Inspect" 'inspect 
                                  "Inspect this method")))
       ("Print" 'clos-browser::print-definition 
              "Pretty Print this method's definition."
              (il:subitems ("Print" 'print 
                          "Print this method's definition."
                                  )
                     ("Describe" 'describe 
                            "Describe this method.")
                     ("Documentation" 'documentation 
                       "Print this method's documentation."
                            )))
       ("Delete" 'clos-browser::delete 
              "Remove this method.")
       ("Copy" 'clos-browser::copy 
              "Copy this method to boxed class.")
       ("Move" 'clos-browser::move 
              "Move this method to boxed class.")
       ("Rename" 'clos-browser::rename 
   "Change the name of this method to new name you specify"
              )
       ("Override" 'clos-browser::override 
              "Create a local method with this name.")
       ("Break" 'pcl::break-method 
    "Cause a break window whenever this method is invoked."
              )
       ("Trace" 'pcl::trace-method "Trace this method.")
       ("UnBreak" 'pcl::unbreak-method 
              "Unbreak this method.")
       ("Who owns" 'clos-browser::who-owns 
    "Show the classes on which this method is specialized."
              )))))


(pcl:defmethod clos-browser::object-name ((
                                         clos-browser::self
                                           
                            clos-browser::clos-browser-node
                                           )) (
                                              web:node-name
                                               
                                         clos-browser::self
                                               ))


(pcl:defmethod clos-browser::override ((clos-browser::node
                                        
                            clos-browser::clos-browser-node
                                        )
                                       clos-browser::method
                                       ) 
                "Create a method specialized on the class."
   (pcl:add-method clos-browser::node nil
          (pcl:slot-value (pcl::method-generic-function
                           clos-browser::method)
                 'pcl::name)))


(pcl:defmethod clos-browser::cache (clos-browser::menu
                                    (clos-browser::node
                                     
                            clos-browser::clos-browser-node
                                     )
                                    &optional 
                             clos-browser::inherited-or-all
                                    )
   (let ((clos-browser::menu-type
          (case clos-browser::inherited-or-all
                ((nil :local)
                 'clos-browser::local-methods-menu)
                (:inherited '
                       clos-browser::ihherited-methods-menu
                       )
                (:all 'clos-browser::all-methods-menu))))
        (if (not (assoc clos-browser::menu-type
                        (pcl:slot-value clos-browser::node
                               'clos-browser::menu-cache)))
      
      (il:* il:|;;| "then initialize alist")

            (setf (pcl:slot-value clos-browser::node
                         'clos-browser::menu-cache)
                  (acons clos-browser::menu-type 
                         clos-browser::menu
                         (pcl:slot-value clos-browser::node
                                'clos-browser::menu-cache))
                  )
      
      (il:* il:|;;| 
      "otherwise replace what is already there")

            (rplacd (assoc clos-browser::menu-type
                           (pcl:slot-value 
                                  clos-browser::node
                                  'clos-browser::menu-cache
                                  ))
                   clos-browser::menu))))


(pcl:defmethod clos-browser::uncache ((clos-browser::node
                                       
                            clos-browser::clos-browser-node
                                       )
                                      &optional 
                             clos-browser::inherited-or-all
                                      )
   (rplacd (assoc (case clos-browser::inherited-or-all
                        ((nil :local)
                         'clos-browser::local-methods-menu)
                        (:inherited '
                       clos-browser::ihherited-methods-menu
                               )
                        (:all '
                             clos-browser::all-methods-menu
                              ))
                  (pcl:slot-value clos-browser::node
                         'clos-browser::menu-cache))
          nil))


(il:rpaq clos-browser::*method-prompt-string* 
         (concatenate 'string 
                "Left button to edit the method." "
" "Middle button provides a menu of operations."))

(defun clos-browser::make-method-menu-items (pcl::methods
                                             
                                        clos-browser::class 
                                             &optional 
                             clos-browser::inherited-or-all
                                             ) 
                  "gather method-list into menu items list"
   (let
    ((clos-browser::method-menu-items (
             clos-browser::make-top-level-method-menu-items
                                       pcl::methods 
                             clos-browser::inherited-or-all
                                       ))
     (clos-browser::extra-menu-item-positions))
    (let
     ((clos-browser::previous.item nil)
      (clos-browser::this.position 0)
      clos-browser::gf-name)
     (dolist
      (clos-browser::this.item 
             clos-browser::method-menu-items)
      (setq clos-browser::gf-name (car 
                                    clos-browser::this.item
                                       ))
      (incf clos-browser::this.position)
      (if
       (not (and clos-browser::previous.item
                 (if (not (first clos-browser::this.item))
      
      (il:* il:|;;| 
      "then look for different gf objects with nil name")

                     (eq (pcl::method-generic-function
                          (second 
                                clos-browser::previous.item
                                 ))
                         (pcl::method-generic-function
                          (second clos-browser::this.item))
                         )
      
      (il:* il:|;;| 
   "otherwise use slightly more efficient test for same gf")

                     (eq (first clos-browser::previous.item
                                )
                         (first clos-browser::this.item))))
            )
      
      (il:* il:|;;| "then go on to the next")

       (setq clos-browser::previous.item 
             clos-browser::this.item)
      
      (il:* il:|;;| "otherwise we have multi-methods")

       (progn
      
      (il:* il:|;;| 
      "build a sub-menu of all the multi-methods")

        (if (not (fourth clos-browser::previous.item))
      
      (il:* il:|;;| "then create the sub-menu")

            (nconc clos-browser::previous.item
                   (list (list 'il:subitems
                               (
                   clos-browser::make-multi-method-sub-menu
                                (second 
                                clos-browser::previous.item
                                       )
                                clos-browser::class)
                               (
                   clos-browser::make-multi-method-sub-menu
                                (second 
                                    clos-browser::this.item
                                       )
                                clos-browser::class))))
      
      (il:* il:|;;| 
      "otherwise add another item to the sub-menu")

            (nconc (fourth clos-browser::previous.item)
                   (list (
                   clos-browser::make-multi-method-sub-menu
                          (second clos-browser::this.item)
                          clos-browser::class))))
      
      (il:* il:|;;| 
 "collect the position of the extra multi-method menu item")

        (push clos-browser::this.position 
              clos-browser::extra-menu-item-positions)))))
      
      (il:* il:|;;| 
      "remove extra multi-method menu items last first.")

    (dolist (clos-browser::each.position 
                   clos-browser::extra-menu-item-positions)
           (setq clos-browser::method-menu-items
                 (delete-if #'xcl:true 
                        clos-browser::method-menu-items 
                        :start (- 
                                clos-browser::each.position 
                                  1)
                        :end clos-browser::each.position)))
      
      (il:* il:|;;| "prepend the Add method item")

    (append '(("Add method" nil "Bring up an editor containing a template for a new method on this class."
                     )) clos-browser::method-menu-items)))


(defun clos-browser::make-top-level-method-menu-items (
                                               pcl::methods
                                                       
                                                  &optional 
                             clos-browser::inherited-or-all
                                                       ) 
                "gather local-methods into menu items list"
   (declare (special clos-browser::*method-prompt-string*))
   (sort (il:for clos-browser::each.method il:in 
                                               pcl::methods
            il:bind clos-browser::method-name
            il:unless (and (not (eql 
                             clos-browser::inherited-or-all 
                                     :all))
                           (typep clos-browser::each.method
                                  '
                         pcl::standard-reader/writer-method
                                  )) 
      
      (il:* il:|;;| 
      "weed out auto-generated slot access methods ")
 il:eachtime (setq clos-browser::method-name
                   (car (pcl::full-method-name 
                               clos-browser::each.method 
                               nil)))
            il:collect (list clos-browser::method-name 
                             clos-browser::each.method 
                       clos-browser::*method-prompt-string*
                             ))
         #'il:alphorder :key #'car))


(defun clos-browser::make-multi-method-sub-menu (
                                       clos-browser::method
                                                 
                                        clos-browser::class
                                                 ) 
   "make a menu item to distinguish methods on the same gf"
   (let
    (clos-browser::sub-item-name)
    (declare (special clos-browser::*method-prompt-string*)
           )
      
      (il:* il:|;;| "first put out the qualifiers if any")

    (dolist (clos-browser::qualifier (pcl:slot-value
                                      clos-browser::method
                                      'pcl::options))
           (setq clos-browser::sub-item-name
                 (concatenate 'string 
                        clos-browser::sub-item-name
                        (when clos-browser::sub-item-name 
                              " ")
                        (prin1-to-string 
                               clos-browser::qualifier))))
      
      (il:* il:|;;| "then do the specializers")

    (dolist
     (clos-browser::type-specifier (pcl:slot-value
                                    clos-browser::method
                                    'pcl::type-specifiers))
     (setq clos-browser::sub-item-name
           (concatenate
            'string clos-browser::sub-item-name
            (when clos-browser::sub-item-name " ")
            (if (eq clos-browser::class 
                    clos-browser::type-specifier)
      
      (il:* il:|;;| "then lets just do a plus sign")

                "+"
      
      (il:* il:|;;| "else print the name")

                (prin1-to-string 
      
      (il:* il:|;;| "test until class-name works properly")

                       (if (typep 
                               clos-browser::type-specifier
                                  'pcl::standard-class)
                           (pcl::class-name 
                               clos-browser::type-specifier
                                  )
                           clos-browser::type-specifier))))
           ))
    (list clos-browser::sub-item-name clos-browser::method 
          clos-browser::*method-prompt-string*)))




(il:* il:|;;| "")




(il:* il:|;;| 
"OPERATORS (via CLOS-BROWSER-NODE) ON CLOS::STANDARD-CLASS")


(pcl:defmethod pcl:add-method ((clos-browser::node 
                            clos-browser::clos-browser-node
                                      )
                               clos-browser::form &optional 
                               clos-browser::method-name) "bring up sedit on a template to add a method to this class"
   (let
    ((pcl::class-name (pcl::class-name (pcl:slot-value
                                        clos-browser::node
                                        '
                                        clos-browser::class
                                        )))
     clos-browser::context)
    (unless clos-browser::form
           (setq clos-browser::form
                 (list 'pcl:defmethod (or 
                                  clos-browser::method-name
                                          (:gap-object))
                       (list (list (intern "SELF")
                                   pcl::class-name))
                       (list (if clos-browser::method-name 
      
      (il:* il:|;;| 
      "then we are specializing an existing method")

                                 'pcl:call-next-method
      
      (il:* il:|;;| "otherwise this is a new method ")

                                 'break)))))
    (let ((clos-browser::name (format nil 
                                     "New method on ~A" 
                                     pcl::class-name)))
         (if (eq il:makesysname ':lyric)
             (let ((clos-browser::context
                    (il:sedit clos-browser::form
                           (list 'il:name 
                                 clos-browser::name)
                           :dontwait)))
                  (xcl::set-completion-fn 
                         clos-browser::context
                         '(
                          clos-browser::complete-add-method
                           )))
      
      (il:* il:|;;| "otherwise medley or newer")

             (sedit:sedit clos-browser::form
                    (list :name clos-browser::name 
                          :completion-fn #'
                          clos-browser::complete-add-method
                          )
                    :dontwait)))))


(pcl:defmethod clos-browser::browse-subs ((
                                         clos-browser::node
                                           
                            clos-browser::clos-browser-node
                                           ))
   (clos-browser:browse-class (pcl:slot-value
                               (pcl:slot-value 
                                      clos-browser::node
                                      'clos-browser::class)
                               'pcl::name)))


(pcl:defmethod clos-browser::edit-class ((
                                         clos-browser::node
                                          
                            clos-browser::clos-browser-node
                                          ))
   (let ((clos-browser::class (pcl::class-name
                               (pcl:slot-value 
                                      clos-browser::node
                                      'clos-browser::class)
                               )))
        (in-package (package-name (symbol-package 
                                        clos-browser::class
                                         )))
        (ed clos-browser::class '(clos-browser::classes
                                  :dontwait))))


(pcl:defmethod clos-browser::inspect-class ((pcl::object
                                             
                            clos-browser::clos-browser-node
                                             ))
   (inspect (pcl:slot-value pcl::object '
                   clos-browser::class)))


(pcl:defmethod clos-browser::menu-methods ((
                                         clos-browser::node
                                            
                            clos-browser::clos-browser-node
                                            )
                                           &optional 
                             clos-browser::inherited-or-all 
                                        clos-browser::items 
                                     clos-browser::fix-flag 
                               clos-browser::recompute-flag
                                           ) "pops up a menu of the methods for the class representing the node."
      
      (il:* il:|;;| "If INHERITED-OR-ALL is NIL or :local only local methods are menued.")
      
      (il:* il:|;;| "If INHERITED-OR-ALL is :inherited only inherited methods are menued.")
      
      (il:* il:|;;| 
      "If INHERITED-OR-ALL is :all all methods are menued.")
      
      (il:* il:|;;| "If items are present, the list of methods is not re-generated.")
      
      (il:* il:|;;| "If the fix-flag is t, the user is asked to position the menu and no \"Fix menu\" item appears.")
      
      (il:* il:|;;| "The whenselectedfn can call this again to generate a fixed menu.")

   (let
    ((clos-browser::class (pcl:slot-value 
                                 clos-browser::node
                                 'clos-browser::class))
     (clos-browser::menu
      (unless (or clos-browser::recompute-flag
                  (eq (pcl:slot-value 
                             clos-browser:clos-icon
                             '
                            clos-browser::menu-cache-switch
                             )
                      :none))
             (rest                 (il:* il:\; 
                                   "use the cached menu")

                   (assoc (case 
                             clos-browser::inherited-or-all
                                ((nil :local)
                                 '
                           clos-browser::local-methods-menu
                                 )
                                (:inherited '
                       clos-browser::ihherited-methods-menu
                                       )
                                (:all '
                             clos-browser::all-methods-menu
                                      ))
                          (pcl:slot-value 
                                 clos-browser::node
                                 'clos-browser::menu-cache)
                          )))))
      
      (il:* il:|;;| "unless it was cached, make the menu")

    (unless
     (and clos-browser::menu (il:type? il:menu 
                                    clos-browser::menu))
      
      (il:* il:|;;| 
      "unless the menu items were passed in, compute them")

     (unless clos-browser::items
            (setq clos-browser::items
                  (clos-browser::make-method-menu-items
                   (case clos-browser::inherited-or-all
                         ((nil :local)
                          (pcl::class-direct-methods 
                                 clos-browser::class))
                         (:inherited (
                             pcl::compute-inherited-methods
                                      clos-browser::class))
                         (:all (
                             pcl::compute-inherited-methods
                                clos-browser::class :all)))
                   clos-browser::class)))
      
      (il:* il:|;;| "create the menu using whenselectedfn")

     (setq clos-browser::menu
           (il:create il:menu
                  il:title il:_ (if clos-browser::fix-flag
                                    (pcl::class-name 
                                        clos-browser::class
                                           )
                                    "methods")
                  il:menufont il:_
                  (when (> (length clos-browser::items)
                           (pcl:slot-value 
                                  clos-browser::node
                                  '
                              clos-browser::large-menu-size
                                  ))
                        (pcl:slot-value clos-browser::node
                               '
                              clos-browser::large-menu-font
                               ))
                  il:menuuserdata il:_ '(:escape t) 
                                   (il:* il:\; "cause symbols to print in mouse process's read-table & package")

                  il:whenselectedfn il:_
                  (clos-browser::make-whenselectedfn 
                         clos-browser::node 
                         clos-browser::inherited-or-all 
                         clos-browser::items)
                  il:items il:_
                  (append clos-browser::items
                         (unless clos-browser::fix-flag
                                '(("Fix menu" nil "Place this menu on the screen.  WARNING: cached menues are not kept up-to-date"
                                         ))))))
      
      (il:* il:|;;| "cache the menu on the node")

     (clos-browser::cache clos-browser::menu 
            clos-browser::node 
            clos-browser::inherited-or-all))
    (if clos-browser::fix-flag 
      
      (il:* il:|;;| "ask user to position menu")

        (il:movew (il:addmenu clos-browser::menu))
      
      (il:* il:|;;| "otherwise just pop it up")

        (il:menu clos-browser::menu))))


(pcl:defmethod clos-browser::make-whenselectedfn ((
                                         clos-browser::node
                                                   
                            clos-browser::clos-browser-node
                                                   )
                                                  &optional 
                             clos-browser::inherited-or-all 
                                        clos-browser::items
                                                  )
   `(lambda
     (clos-browser::menu-item ignore 
            clos-browser::mouse-key)
     (let
      ((clos-browser::method-name (first 
                                    clos-browser::menu-item
                                         ))
       (clos-browser::method (second 
                                    clos-browser::menu-item
                                    )))
      (if
       (null clos-browser::method)
      
      (il:* il:|;;| "do the non-method items")

       (cond
          ((string= clos-browser::method-name "Add method")
           (pcl:add-method ',clos-browser::node nil))
          ((string= clos-browser::method-name "Fix menu")
      
      (il:* il:|;;| 
      "call MENU-LOCAL-METHODS again to create fixed menu ")

           (clos-browser::menu-methods ',clos-browser::node
                  ',clos-browser::inherited-or-all
                  ',clos-browser::items t))
          (t clos-browser::operation))
      
      (il:* il:|;;| "got a method, lets get an operation")

       (let
        ((clos-browser::operation
          (case
           clos-browser::mouse-key
           (il:left 'ed)
           (il:middle
            (il:menu
             (il:create
              il:menu
              il:title il:_ clos-browser::method-name
              il:items il:_
              (pcl:slot-value
               ',clos-browser::node
               ',(case clos-browser::inherited-or-all
                       ((nil :local)
                        '
                      clos-browser::local-method-operations
                        )
                       (:inherited '
                  clos-browser::inherited-method-operations
                              )
                       (:all '
                        clos-browser::all-method-operations
                             )))))))))
      
      (il:* il:|;;| 
      "got an operation, lets use it on the method")

        (case
         clos-browser::operation
         ((nil)
          nil)
         ((clos-browser::copy clos-browser::move)
                                   (il:* il:\; 
                               "need to supply destination")

          (funcall clos-browser::operation 
                 clos-browser::method 
      
      (il:* il:|;;| "to class")

                 (progn (unless (pcl:slot-value
                                 clos-browser:clos-icon
                                 '
                          clos-browser::destination-browser
                                 )
                               (error 
             "Please box a destination class, then say OK."
                                      ))
                        (pcl:slot-value
                         (pcl:slot-value
                          (pcl:slot-value 
                                 clos-browser:clos-icon
                                 '
                          clos-browser::destination-browser
                                 )
                          `web::boxed-node)
                         `clos-browser::class))
      
      (il:* il:|;;| "from class")

                 (pcl:slot-value ',clos-browser::node
                        'clos-browser::class)))
         ((clos-browser::delete)   (il:* il:\; 
                             "need to supply extra confirm")

          (when (il:mouseconfirm (format nil 
           "Are you sure you wish to delete the ~A method?"
                                        (
                                      pcl::full-method-name
                                         
                                       clos-browser::method
                                         )))
                (funcall clos-browser::operation 
                       clos-browser::method)))
         ((clos-browser::override) (il:* il:\; 
                                   "use add-method ")

          (funcall clos-browser::operation
                 ',clos-browser::node clos-browser::method)
          )
         (otherwise (funcall clos-browser::operation 
                           clos-browser::method))))))))


(pcl:defmethod clos-browser::describe-class ((
                                         clos-browser::self
                                              
                            clos-browser::clos-browser-node
                                              ))
   (describe (pcl:slot-value clos-browser::self
                    `clos-browser::class)))


(pcl:defmethod clos-browser::documentation-class ((
                                         clos-browser::self
                                                   
                            clos-browser::clos-browser-node
                                                   ))
   (documentation (pcl:slot-value clos-browser::self
                         'clos-browser::class)))


(pcl:defmethod clos-browser::print-class ((
                                         clos-browser::self
                                           
                            clos-browser::clos-browser-node
                                           ))
   (pprint (il:getdef (pcl:slot-value clos-browser::self
                             `clos-browser::class))))


(pcl:defmethod clos-browser::specialize-class ((
                                         clos-browser::node
                                                
                            clos-browser::clos-browser-node
                                                )
                                               &optional 
                                         clos-browser::form 
                               clos-browser::new-class-name
                                               )
   (clos-browser::specialize (pcl:slot-value 
                                    clos-browser::node
                                    'clos-browser::class)
          clos-browser::form clos-browser::new-class-name))


(defun clos-browser::complete-add-method (
                                      clos-browser::context
                                          structure 
                                          &optional
                                          (
                                     clos-browser::changed?
                                           t))
   (declare (ignore clos-browser::context))
   (case clos-browser::changed? ((:abort nil)
                                 nil)
         (otherwise (eval (copy-tree 
                                   (il:* il:\; "to ensure the original list does not get destructively clobbered")

                                 structure)))))


(defun clos-browser::complete-specialize (ignore structure 
                                     clos-browser::changed?
                                                )
   (declare (ignore clos-browser::context))
   (case
    clos-browser::changed?
    ((:abort nil)
     nil)
    (t
     (let
      ((clos-browser::originalcursor (il:cursor)))
      (unwind-protect
       (progn
        (il:setcursor il:waitingcursor)
        (let ((clos-browser::sub-class (copy-tree 
                                   (il:* il:\; "so original list does not get clobbered if this class's name changes")

                                              structure))
              clos-browser::super-class)
      
      (il:* il:|;;| "check for bug")

             (when (symbolp clos-browser::sub-class)
                   (setq clos-browser::sub-class
                         (pcl::symbol-class 
                                clos-browser::sub-class)))
             (dolist (clos-browser::browser
                      (pcl:slot-value 
                             clos-browser:clos-icon
                             'clos-browser::class-browsers)
                      )
                    (dolist (clos-browser::super-class
                             (pcl:slot-value 
                                    clos-browser::sub-class
                                    'pcl::local-supers))
                           (when (clos-browser::contains-p
                                  clos-browser::super-class 
                                  clos-browser::browser)
                                 (clos-browser::add-root
                                  clos-browser::browser 
                                  clos-browser::sub-class)
                                 (return))))))
       (il:setcursor clos-browser::originalcursor))))))


(defun clos-browser::lyric-complete-specialize (ignore
                                                structure)
   (let
    ((clos-browser::originalcursor (il:cursor)))
    (unwind-protect
     (progn (il:setcursor il:waitingcursor)
            (let ((clos-browser::sub-class
                   (eval (copy-tree 
                                   (il:* il:\; "so original list does not get clobbered if this class's name changes")

                                structure)))
                  clos-browser::super-class)
      
      (il:* il:|;;| "check for bug")

                 (when (symbolp clos-browser::sub-class)
                       (setq clos-browser::sub-class
                             (pcl::symbol-class 
                                    clos-browser::sub-class
                                    )))
                 (dolist (clos-browser::browser
                          (pcl:slot-value 
                                 clos-browser:clos-icon
                                 '
                               clos-browser::class-browsers
                                 ))
                        (dolist (clos-browser::super-class
                                 (pcl:slot-value
                                  clos-browser::sub-class
                                  'pcl::local-supers))
                               (when (
                                   clos-browser::contains-p
                                      
                                  clos-browser::super-class 
                                      clos-browser::browser
                                      )
                                     (
                                     clos-browser::add-root
                                      clos-browser::browser 
                                    clos-browser::sub-class
                                      )
                                     (return))))))
     (il:setcursor clos-browser::originalcursor))))


(defun clos-browser::this-class-node-p (clos-browser::class
                                        clos-browser::node)
   (eq clos-browser::class (pcl:slot-value 
                                  clos-browser::node
                                  'clos-browser::class)))




(il:* il:|;;| "")




(il:* il:|;;| "OPERATORS ON CLOS::STANDARD-CLASS (directly)"
)


(pcl:defmethod pcl::compute-inherited-methods ((pcl::self
                                                
                                        pcl::standard-class
                                                )
                                               &optional 
                                              pcl::all-flag
                                               ) "Compute and return all inherited methods of a class.  If all-flag eq :all then methods on t and the passed class are included."
      
      (il:* il:|;;| "The following does not use generic function dispatch-orders, discriminating-functions, or classical-method-tables.")
      
      (il:* il:|;;| "For each method in the direct-methods of each inherited class in the class-precedence-list for the class of interest, in class precedence order check to see if we have already analyzed its generic function.")
      
      (il:* il:|;;| "If it is a new gf then if there is exactly one type specifier then add the direct method to the list of inherited methods.")
      
      (il:* il:|;;| "If there is more than one type specifier then for every method in the gf for each specializer if the specializing class is equal to or later than the current class in the class precedence list, ignoring t, pushnew the method on the list of inherited methods.")

   (let
    ((pcl::filtered-classes nil)
     (pcl::my-gfs nil)
     (pcl::class-precedence-list (pcl:slot-value
                                  pcl::self
                                  '
                                 pcl::class-precedence-list
                                  ))
     (pcl::inherited-methods nil)
     (pcl::t-class (pcl::symbol-class 't)))
    (unless (eq pcl::all-flag :all)(il:* il:\; 
                           "ignore t and the bottom class ")

           (push pcl::t-class pcl::filtered-classes)
           (push pcl::self pcl::filtered-classes)
           (setq pcl::my-gfs (mapcar #'
                               pcl::method-generic-function
                                    (
                                  pcl::class-direct-methods
                                     pcl::self))))
    (dolist
     (pcl::class pcl::class-precedence-list)
     (unless
      (member pcl::class pcl::filtered-classes)
      (dolist
       (pcl::direct-method (pcl::class-direct-methods
                            pcl::class))
       (let
        ((pcl::gf (pcl::method-generic-function 
                         pcl::direct-method)))
        (unless
         (member pcl::gf pcl::my-gfs :test #'eq)
         (if
          (= 1 (length (pcl:slot-value pcl::direct-method
                              'pcl::type-specifiers))
                                   (il:* il:\; "Note: this check relies on guaranteed congruent lambda lists.  There should be some way to query the gf directly.")

             )
      
      (il:* il:|;;| "then only one specializer so this method must be inherited. ")

          (push pcl::direct-method pcl::inherited-methods)
      
      (il:* il:|;;| 
    "otherwise more than one so must look at specializers ")

          (dolist
           (pcl::gf-method (pcl:slot-value pcl::gf
                                  'pcl::methods))
           (dolist (pcl::specifier (pcl:slot-value
                                    pcl::gf-method
                                    'pcl::type-specifiers))
                  (unless (or (eq pcl::t-class 
                                  pcl::specifier)
                              (not (member pcl::specifier 
                                 pcl::class-precedence-list 
                                          :test
                                          #'eq)))
                         (pushnew pcl::gf-method 
                                pcl::inherited-methods)
                         (return))))))
        (push pcl::gf pcl::my-gfs)))))
    pcl::inherited-methods))


(pcl:defmethod clos-browser::specialize ((
                                        clos-browser::class
                                          
                                        pcl::standard-class
                                          )
                                         &optional 
                                         clos-browser::form 
                               clos-browser::new-class-name
                                         )
   (let
    ((pcl::class-name (pcl::class-name clos-browser::class)
            )
     clos-browser::context)
    (unless clos-browser::form
           (setq clos-browser::form
                 (list 'pcl:defclass (or 
                               clos-browser::new-class-name
                                         (:gap-object))
                       (list pcl::class-name)
                       (list (list 'clos-browser::slot-1)
                             (list 'clos-browser::slot-2 
                                   :accessor '
                      clos-browser::<generic-function-name>
                                   )
                             (list 'clos-browser::slot-3 
                                   :reader '
                      clos-browser::<generic-function-name>
                                   )
                             (list 'clos-browser::slot-4 
                                   :allocation :class 
                                   :initform nil)
                             (list 'clos-browser::slot-5 
                                   :initarg '
                               clos-browser::<initarg-name>
                                   )
                             (list 'clos-browser::slot-6 
                                   :initform
                                   (list '
                                       clos-browser::<form>
                                         ))
                             (list 'clos-browser::slot-7 
                                   :type '
                             clos-browser::<type-specifier>
                                   ))
                       (list :default-initargs
                             (list 'clos-browser::<argname>
                                   'clos-browser::<value>))
                       (list :documentation "none")
                       (list :metaclass '
                             pcl::standard-class))))
      
      (il:* il:|;;| "call sedit")

    (let ((clos-browser::name (format nil 
                                     "New sub-class of ~A" 
                                     pcl::class-name)))
         (if (eq il:makesysname ':lyric)
             (let ((clos-browser::context
                    (il:sedit clos-browser::form
                           (list 'clos-browser::name 
                                 clos-browser::name)
                           :dontwait)))
                  (xcl::set-completion-fn 
                         clos-browser::context
                         '(
                    clos-browser::lyric-complete-specialize
                           )))
             (sedit:sedit clos-browser::form
                    (list :name clos-browser::name 
                          :completion-fn #'
                          clos-browser::complete-specialize
                          )
                    :dontwait)))))




(il:* il:|;;| "")




(il:* il:|;;| "OPERATORS ON CLOS::STANDARD-METHOD")


(pcl:defmethod clos-browser::delete ((clos-browser::method
                                      pcl::standard-method)
                                     )
   (let ((clos-browser::method-name (pcl::full-method-name
                                     clos-browser::method))
         )
        (if (pcl:remove-method (
                               pcl::method-generic-function
                                clos-browser::method)
                   clos-browser::method)
            (format t "~%The ~A specialized method has been removed from the ~A generic function."
                   (cadr clos-browser::method-name)
                   (car clos-browser::method-name))
            (format t "~%Could not remove the method ~A specialized from the ~A generic function."
                   (cadr clos-browser::method-name)
                   (car clos-browser::method-name)))
        (format t "~%")
        (il:delfromfiles clos-browser::method-name
               'pcl::methods)
        (clos-browser::update-cached-menues 
               clos-browser::method)))


(pcl:defmethod clos-browser::copy ((clos-browser::method
                                    pcl::standard-method)
                                   (clos-browser::to-class
                                    pcl::standard-class)
                                   &optional 
                                   clos-browser::from-class
                                   )
   (when (eq clos-browser::to-class 
             clos-browser::from-class)
         (return-from clos-browser::copy))
      
      (il:* il:|;;| "if we have the source code, find all the references to the from class, change them to the to-class, and evaluate the new form.   If from-class is not provided, if method is specialized on just one class, use it, otherwise ask the user.")
      
      (il:* il:|;;| "If we dont have source code, we could ask if you want to just move the method object, but instead we print a complaint and punt.")

   (let
    ((clos-browser::method-definition
      (copy-tree (xcl:ignore-errors (il:getdef 
                                       clos-browser::method
                                           ))))
     (clos-browser::non-t-classes
      (mapcar #'(lambda (clos-browser::class)
                       (unless (eq clos-browser::class
                                   't)
                              clos-browser::class))
             (pcl::method-type-specifiers 
                    clos-browser::method))))
    (unless clos-browser::method-definition
           (format t "The definition for ~A is not loaded"
                  (pcl::full-method-name 
                         clos-browser::method nil))
           (return-from clos-browser::copy nil))
    (if
     clos-browser::from-class
      
      (il:* il:|;;| 
      "method should be specialized on from-class.")

     (unless (member clos-browser::from-class 
                    clos-browser::non-t-classes)
            (error 
         "The ~A method is not specialized on the ~A class"
                   (pcl::full-method-name 
                          clos-browser::method nil)
                   (pcl::class-name 
                          clos-browser::from-class)))
      
      (il:* il:|;;| 
      "otherwise see if we can deduce FROM-CLASS ")

     (case (length clos-browser::non-t-classes)
           (0 (format t 
               "Unspecialized methods cannot be copied. ~A"
                     (pcl::full-method-name 
                            clos-browser::method nil)))
           (1 (setq clos-browser::from-class (car 
                                clos-browser::non-t-classes
                                                  )))
           (otherwise
            (setq clos-browser::from-class
                  (pcl::symbol-class
                   (il:promptforword (format nil 
              "Which class in ~A do you wish to move from?"
                                            (
                                      pcl::full-method-name
                                             
                                       clos-browser::method 
                                             nil))))))))
      
      (il:* il:|;;| "should contain from-class.  If it is not the same, abort.")

    (clos-browser::replace-specializers 
           clos-browser::method-definition (pcl::class-name
                                            
                                   clos-browser::from-class
                                            )
           (pcl::class-name clos-browser::to-class))
    (print (eval clos-browser::method-definition))))


(pcl:defmethod clos-browser::move ((clos-browser::method
                                    pcl::standard-method)
                                   (clos-browser::to-class
                                    pcl::standard-class)
                                   &optional 
                                   clos-browser::from-class
                                   )
   (when (eq clos-browser::to-class 
             clos-browser::from-class)
         (return-from clos-browser::move))
   (if (clos-browser::copy clos-browser::method 
              clos-browser::to-class 
              clos-browser::from-class)
       (clos-browser::delete clos-browser::method)
       (format t "copy of ~A to ~A failed"
              (xcl:ignore-errors (pcl::full-method-name
                                  clos-browser::method))
              (xcl:ignore-errors (pcl::class-name 
                                     clos-browser::to-class
                                        )))))


(pcl:defmethod clos-browser::print-definition ((
                                         clos-browser::self
                                                
                                       pcl::standard-method
                                                ))
   (pprint (il:getdef clos-browser::self)))


(pcl:defmethod clos-browser::rename ((clos-browser::method
                                      pcl::standard-method)
                                     clos-browser::new-name
                                     )
   (unless clos-browser::new-name
          (setq clos-browser::new-name
                (read (make-string-input-stream
                       (il:promptforword
                        (format nil "~%New name for ~A"
                               (pcl::full-method-name
                                clos-browser::method)))))))
   (let ((clos-browser::method-definition
          (xcl:ignore-errors (il:getdef 
                                    clos-browser::method)))
         )
        (unless clos-browser::method-definition
               (format t 
                      "The definition for ~A is not loaded"
                      (pcl::full-method-name 
                             clos-browser::method nil))
               (return-from clos-browser::rename nil))
        (if (and (setf (second 
                            clos-browser::method-definition
                              )
                       clos-browser::new-name)
                 (print (eval 
                            clos-browser::method-definition
                              )))
            (clos-browser::delete clos-browser::method)
            (format t "~%Rename of ~A to ~A failed"
                   (xcl:ignore-errors (
                                      pcl::full-method-name
                                       clos-browser::method
                                       ))
                   clos-browser::new-name))))


(pcl:defmethod clos-browser::update-cached-menues ((
                                       clos-browser::method
                                                    
                                       pcl::standard-method
                                                    )
                                                   
                                                  &optional
                                                   (
                                 clos-browser::cache-switch
                                                    (
                                             pcl:slot-value
                                                     
                                     clos-browser:clos-icon
                                                     '
                            clos-browser::menu-cache-switch
                                                     ))) 
         "set cached menues for this method's class to nil"
   (let
    ((clos-browser::originalcursor (il:cursor)))
    (unwind-protect
     (progn
      (il:setcursor il:waitingcursor)
      (dolist
       (clos-browser::browser (pcl:slot-value 
                                     clos-browser:clos-icon
                                     '
                               clos-browser::class-browsers
                                     ))
       (dolist
        (clos-browser::class (pcl:slot-value 
                                    clos-browser::method
                                    'pcl::type-specifiers))
      
      (il:* il:|;;| "fix bug in the inconsistent way CLOS objects store T class specializers and do method lookup.")

        (when (eq clos-browser::class t)
              (setq clos-browser::class (pcl::symbol-class
                                         t)))
        (let
         ((clos-browser::node (
                           clos-browser::browser-contains-p
                               clos-browser::class 
                               clos-browser::browser)))
         (when
          clos-browser::node
          (case
           clos-browser::cache-switch
           (:lazy (clos-browser::uncache clos-browser::node
                         )
                  (clos-browser::uncache clos-browser::node 
                         :all)
                  (dolist (clos-browser::sub-class
                           (clos-browser::subclasses-of
                            (pcl:slot-value 
                                   clos-browser::node
                                   'clos-browser::class)))
                         (when (setq clos-browser::node
                                     (
                                   clos-browser::contains-p
                                      
                                    clos-browser::sub-class 
                                      clos-browser::browser
                                      ))
                               (clos-browser::uncache
                                clos-browser::node 
                                :inherited)
                               (clos-browser::uncache
                                clos-browser::node :all))))
           (:eager (print 
         ":eager method menu cacheing not yet implemented."
                          ))
           (otherwise nil          (il:* il:\; "do nothing")
)))))))
     (il:setcursor clos-browser::originalcursor))))


(pcl:defmethod clos-browser::who-owns ((
                                       clos-browser::method
                                        
                                       pcl::standard-method
                                        ))
   (print (pcl::full-method-name clos-browser::method)))


(pcl:defmethod pcl:add-method
   :after
   ((clos-browser::generic-function 
           pcl::standard-generic-function)
    (clos-browser::method pcl::standard-method))
   "Update cached menues."
   (let
    (clos-browser::cache-switch)
    (when (and clos-browser::method (pcl:slot-value
                                     clos-browser:clos-icon
                                     '
                               clos-browser::class-browsers
                                     )
                                   (il:* il:\; 
                                  "there are some browsers")

               (not (eq (setq clos-browser::cache-switch
                              (pcl:slot-value 
                                     clos-browser:clos-icon
                                     '
                            clos-browser::menu-cache-switch
                                     ))
                        :none))    (il:* il:\; 
                              "we want auto cache updating")

               )
          (clos-browser::update-cached-menues 
                 clos-browser::method 
                 clos-browser::cache-switch))
    clos-browser::generic-function))


(defun clos-browser::replace-specializers (
                            clos-browser::method-definition
                                           
                              clos-browser::from-class-name 
                                clos-browser::to-class-name 
                                           &key 
                      clos-browser::in-lamda-list-only-flag
                                           )
   (nsubst clos-browser::to-class-name 
          clos-browser::from-class-name
          (if clos-browser::in-lamda-list-only-flag 
      
      (il:* il:|;;| "get the lamba list")

              (third (multiple-value-list
                      (pcl::parse-defmethod (cdr 
                            clos-browser::method-definition
                                                 ))))
                                   (il:* il:\; "note this gets argument names as well as specializers.  Usually not what you want.  Needs to be made smarter to just get specializers.")
      
      (il:* il:|;;| "otherwise do the whole method")

              clos-browser::method-definition)))




(il:* il:|;;| "")




(il:* il:|;;;| "SETUP RELEASE INFO")


(il:rpaq clos-browser::release-id "0.02")

(il:rpaq clos-browser::system-date 
         (caar (il:getprop 'il:clos-browser 'il:filedates)))



(il:* il:|;;| "")




(il:* il:|;;| "SETUP LAFITE FORM")


(defun clos-browser::make-xclose-lafite-form
   nil (declare (special clos-browser::release-id 
                       clos-browser::system-date))
       (il:makexxxsupportform (il:concat "CLOS " 
                                   clos-browser::release-id
                                     )
              "CLOSSupport.pa" clos-browser::system-date))


(il:addtovar il:lafitespecialforms ("CLOS Report"
                                    '
                      clos-browser::make-xclose-lafite-form 
              "Report bug or request new feature for CLOS."
                                    ))
(setq il:lafiteformsmenu nil)



(il:* il:|;;| "")




(il:* il:|;;| "SETUP BACKGROUND MENU")


(defun clos-browser::in-select-package
   nil
   "pops up a menu of packages"
                             (il:* il:\; 
                            "Edited 18-Mar-87 13:13 by smL")
                                   (il:* il:\; "")
      
      (il:* il:|;;| 
      "kirk: 16Mar88 modified for clos-browser")

   (let
    ((package
      (il:menu
       (il:|create|
        il:menu
        il:title il:_ "Select package"
        il:items il:_
        (il:sort
         (il:|for| package il:|in| (list-all-packages)
            il:|bind| il:package-name
            il:|collect|
            (il:setq il:package-name (package-name package)
             )
            `(,(il:concat (or (car (package-nicknames
                                    package))
                              il:package-name)
                      ":") ',il:package-name
                    ,(il:concat 
                            "Set the current package to " 
                            il:package-name ":")))
         (il:function (il:lambda (il:x il:y)
                        (il:alphorder (car il:x)
                               (car il:y)))))
        il:centerflg il:_ t))))
    (il:|if| package
        il:|then| (in-package package))))


(defun clos-browser::classes-in-package (package &optional 
                               clos-browser::map-on-package
                                               ) "Retrieves a list of all the classes for a given package.  When map-on-package is t this can be very slow."
      
      (il:* il:|;;| "The maphash is always fast, whereas for some strange reason map-on-package varys among packages greatly.")

   (let
    ((clos-browser::classes))
    (unless (typep package 'package)
           (setq package (find-package package)))
    (if clos-browser::map-on-package
        (do-symbols (clos-browser::sym package)
               (if (and (eq (symbol-package 
                                   clos-browser::sym)
                            package)
                        (pcl::symbol-class 
                               clos-browser::sym t))
                   (push clos-browser::sym 
                         clos-browser::classes)))
        (maphash #'(lambda (clos-browser::key 
                                  clos-browser::val)
                          (if (eq (symbol-package 
                                         clos-browser::key)
                                  package)
                              (push clos-browser::key 
                                    clos-browser::classes))
                          ) pcl::*class-name-hash-table*))
    clos-browser::classes))

      
      (il:* il:|;;| "pushnew should eliminate this")

(setq il:|BackgroundMenuCommands| (remove 'il:|BrowseClass| 
                                il:|BackgroundMenuCommands| 
                                         :key #'car))
(push '(il:|BrowseClass| (clos-browser:browse-class)
              "Bring up a class browser."
              (il:subitems (il:|all in a package|
                            (clos-browser:browse-class
                             (
                           clos-browser::classes-in-package
                              (
                            clos-browser::in-select-package
                               )))
                            "Select a package and browse all the classes defined in that package."
                            ))) il:|BackgroundMenuCommands|
      )
(setq il:|BackgrundMenu| nil)
(il:putprops il:clos-browser il:copyright (
"Xerox Corporation" 1987 1988 1900 1901))
(il:declare\: il:dontcopy
  (il:filemap (nil)))
il:stop
