#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



;  renamed the loop macro to be g-loop because common lisp has its own loop
;  macro defined.

(defmacro g-loop (&rest l)
    `(prog ,(get-odd-elements (get-keyword 'init l))
	   ,@(setq-non-nil-vars (get-keyword 'init l))
	   ,@(get-keyword 'before-starting l)
	   loop
	   ,@(apply #'append (mapcar #'do-clause l))
	   (go loop)
	   exit
	   ,@(get-keyword 'before-returning l)
	   (return ,@(get-keyword 'result l))))

(defun get-keyword (keyword clauses)
    (let ((item (assoc keyword clauses)))
         (cond (item (cdr item)))))

(defun get-odd-elements (l)
    (cond ((null l) nil)
	  ((null (cdr l))
	   (error "LOOP Error: Odd number of INIT elements"))
          ((cons (car l)
		 (get-odd-elements (cddr l))))))
          
(defun setq-next-vars (l)
    (cond ((null l) nil)
	  ((null (cdr l))
	   (error "LOOP Error: Odd number of NEXT elements"))
	  ((cons (list 'setq (car l)(cadr l))
		 (setq-next-vars (cddr l))))))

(defun setq-non-nil-vars (l)
    (cond ((null l) nil)
	  ((cadr l)
	   (cons (list 'setq (car l)(cadr l))
                 (setq-non-nil-vars (cddr l))))
          ((setq-non-nil-vars (cddr l)))))
 	

(defun do-clause (clause)
    (case (car clause)
	((init result before-starting before-returning) nil)
	(while `((or ,(cadr clause) (go exit))))
	(do (append (cdr clause) nil))
        (next (setq-next-vars (cdr clause)))
	(until `((and ,(cadr clause) (go exit))))
	(error "LOOP error: unknown keyword")))



	   
