#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


(setq *GI-SCHEMAS* '(

; may want to make fails both evaluable and non-evaluable
; no longer used, see ebs hack in corresponding-..
;(def-gi-from-node-failure
;    (interacts <s>)
;    (exists (<failed-s>) (fails <failed-s>)
;	    (no-change <s> <failed-s>)))

(def-goal-protection-interaction
    (interacts <s>)
    (let (<pgoal>) (is-interact-literal <pgoal>)
      (and (protected-goal <s> <pgoal>)
	   (let (<lit>) (ps-negate <lit> <pgoal>)
	     (known <s> <lit>)))))

; not really necessary...could be done more
; concisely, used for top-level prereq interactions only
(def-goal-top-level-prerequiste-violation
    (interacts <s>)
    (let (<goal>) (is-interact-literal <goal>)
	 (and (is-top-level-goal <s> <goal>)
	      (or (and (is-negated <goal>)
		       (was-added <s> <goal>))
		  (and (~ (is-negated <goal>))
		       (was-deleted <s> <goal>))))))


(def-reset-interacts
    (interacts <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	 (let (<op>) (old-legal-operator <op>)
            (and (alt-on-deck <s> <goal> <op>)
	         (op-interacts <s> <goal> <op>)))))


(def-interaction
    (interacts <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	 (and (primary-candidate-goal <s> <goal>)
	      (goal-interaction <s> <goal>))))


(def-interacts-after-goal-selection
    (interacts <s>)
    (exists (<goal>) (is-goal-literal <goal>)
	    (and (is-top-level-goal <s> <goal>)
		 (goal-selected-by-scr <s> <goal>)
		 (goal-interaction <s> <goal>))))


; top level node interacts is probably a useless thing to learn...
; but needed as intermediate result for top-level clones


(def-top-level-interacts
    (interacts <s>)
    (let (<goal-set>) (set-of-goal-formulii <goal-set>)
           (forall (<goal>) (in-set <g> <goal-set>)
	       (and (is-top-level-goal <s> <g>)
	            (goal-interaction <s> <g>)))))


(def-prerequisite-interaction
    (goal-interaction <s> <g>)
    (or (and (is-negated <g>)
	     (was-added <s> <g>))
	(and (~ (is-negated <g>))
	     (was-deleted <s> <g>))))

; this is the top level call.

(def-goal-interacts
   (goal-interacts <s> <g>)
   (exists (<goal>) (is-goal-literal <g>)  
        (goal-interaction <s> <g>)))

(def-goal-interacts-due-to-goal-rejection
    (goal-interaction <s> <g>)
    (top-level-goal-rejected-by-scr <s> <g>))

(def-goal-interacts-after-op-selection
  (goal-interaction <s> <g>)
  (exists (<op>) (legal-operator <op>)
     (and (op-selected-by-scr <s> <g> <op>)
          (op-interacts <s> <g> <op>))))
  
(def-all-ops-interact
  (goal-interaction <s> <g>)
  (forall (<op>) (is-op <op>)
   (op-interacts <s> <g> <op>)))
	       

(def-op-interacts-from-scr-rejection
    (op-interacts <s> <g> <op>)
    (op-rejection-rule-fired <s> <g> <op>))

;(def-op-interacts-by-op-failure
;    (op-interacts <s> <g> <op>)
;    (op-fails <s> <g> <op>))


(def-cached-reset-interacts
   (op-interacts <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
        (let (<s2>) (interacts <s2>)
          (implies-op-interacts <s> <g> <op> <s2>)))))




(def-reset-op-interacts
    (op-interacts <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
	(let (<bvars>) (get-reset-alt <s> <op> <bvars>)
	  (and (has-bound-vars <s> <g> <op> <bvars>)
               (forall (<add>) (get-used-add <add> <op>) ; ignores deletes...  
                 (add-interacts <s> <g> <add> <op>)))))))


(def-op-interacts
    (op-interacts <s> <g> <op>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>)(legal-operator <op>)
       (forall (<add>) (in-add-list <add> <op>) ; ignores deletes...  
         (add-interacts <s> <g> <add> <op>)))))


(def-not-relevent-contributes-to-interaction
  (add-interacts <s> <goal> <add> <op>)
  (not-relevent <add> <goal> nil))


(def-add-interacts
    (add-interacts <s> <goal> <add> <op>)
    (and (has-rhs-constants <goal> <add>)
	 (let (<r-bindings>)
	      (relevent-bindings <r-bindings> <op> <add> <goal>)
	      (let (<orig-preconds>) (get-lpreconds <orig-preconds> <op>)
		   (let (<dvars>) (ps-make-dvars <dvars> <add> nil)
			(exp-interacts  <orig-preconds> <r-bindings> <op> <add> <goal> <dvars> <s>))))))

(def-bindings-interact
    (bindings-interact <s> <g> <op> <bindings>)
    (exists (<g>) (is-goal-literal <g>)
      (exists (<op>) (legal-operator <op>)
       (let (<b>) (ps-get-op-bindings <op> <b>)
         (let (<add>) (ps-get-add-for-op <op> <add>)
	  (let (<dvars>) (ps-make-dvars <dvars> <b> nil)
	   (let (<orig-preconds>) (get-lpreconds <orig-preconds> <op>)
	    (and (is-equal <b> <bindings>)
	         (exp-interacts <orig-preconds> nil <op> <add> <g> <dvars> <s>)))))))))

; vars list doesn't contain bound vars.

(def-exp-or-application-interacts
   (exp-interacts <exp> <b> <op> <add> <g> <dvars> <s>)
   (or (application-interacts <add> <op> <b> <dvars> <g> <s>)
       (exp-interacts <exp> <b> <op> <add> <g> t <s>)))

(def-exp-interacts
 (exp-interacts <exp> <b> <op> <add> <g> <dvars> <s>) 
 (let (<exp-type>)  (is-car <exp-type> <exp>)
    (or	(bindings-rejected <s> <exp> <g> <op> <add> <b> <dvars>)
        (and (ps-is-equal <exp-type> forall) ; should use caps, but can't!
	     (let (<vars-lst>)  (ps-get-vars-lst <vars-lst> <b> <exp>)
	      (let (<gen-exp>) (ps-get-gen-exp <gen-exp> <exp>)
	       (let (<sub-exp>) (ps-get-exp <sub-exp> <exp>)
  	        (forall-interacts <vars-lst> <gen-exp> <sub-exp> 
		    <b> <op> <add> <g> <dvars> <s>)))))
       (and (ps-is-equal <exp-type> exists)
	    (let (<vars-lst>)  (ps-get-vars-lst <vars-lst> <b> <exp>)
	      (let (<gen-exp>) (ps-get-gen-exp <gen-exp> <exp>)
	       (let (<sub-exp>) (ps-get-exp <sub-exp> <exp>)
                (exists-interacts <vars-lst> <gen-exp> <sub-exp> <b> 
		   <op> <add> <g> <dvars> <s>)))))
       (and (ps-is-equal <exp-type> and)
	    (let (<subexps>) (is-cdr <subexps> <exp>)
             (and-interacts <subexps> <b> <op> <add> <g> <dvars> <s>)))
       (and (ps-is-equal <exp-type> or)
	    (let (<subexps>) (is-cdr <subexps> <exp>)
             (or-interacts <subexps> <b> <op> <add> <g> <dvars> <s>)))
       (and (is-negated <exp>)
	    (let (<rest>) (is-cadr <rest> <exp>)
		 (and (~ (is-predicate <rest>)) ; negated exists unimplmented
    		      (too-soon))))
       (and (or (is-predicate <exp-type>)
		(is-negated <exp>))
	    (lit-subgoal-interacts <exp> <b> <op> <add> <g> <s>)))))

(def-lexp-interaction-last-possibility
  (exp-interacts <exp> <b> <op> <add> <g> <dvars> <s>)
  (bindings-rejected <s> <exp> <g> <op> <add> <b> <dvars>))

(def-lit-interaction-not-same-bindings
  (lit-subgoal-interacts <exp> <b> <op> <add> <g> <s>)
  nil)

(def-lit-inference-interaction
(lit-subgoal-interacts <exp> <b> <op> <add> <g> <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
   (and (is-open-world-exp <iexp>)
	   		;  have to change, look at all r-clones
        (exists (<s2>) (interacts <s2>)
          (generate-subgoal-state <s2> <iexp> <g> <b> <s>)))))
 
(def-lit-static-interaction
  (lit-subgoal-interacts <exp> <b> <op> <add> <g> <s>)
  (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
        (~ (known <s> <iexp>))))

; dont need to say that condition is not known, since
; conjunct later interacts...

(def-later-reset-subgoal-interaction
(lit-subgoal-interacts <exp> <b> <op> <add> <g>  <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
    (exists (<s2>) (interacts <s2>)
	; (and  (is-reset-interaction.... <s2>)) should put in, but unnecessary
              (generate-subgoal-state <s2> <iexp> <g> <b> <s>))))

(def-lit-subgoal-interaction
(lit-subgoal-interacts <exp> <b> <op> <add> <g> <s>)
 (let (<iexp>)(ps-subst-bindings <iexp> <exp> <b>)
   (and (~ (known <s> <iexp>))
	   		;  have to change, look at all r-clones
        (exists (<s2>) (interacts <s2>)
          (generate-subgoal-state <s2> <iexp> <g> <b> <s>)))))


(def-forall-interacts
 (forall-interacts <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
  (let (<igen-exp>)(ps-subst-bindings <igen-exp> <gen-exp> <b>)
   (and (known <s> <igen-exp>)
        (exp-interacts <sub-exp> <b> <op> <add> <g> <dvars> <s>))))

(def-exists-and-interacts
 (exists-interacts <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
 (or (exp-interacts <gen-exp> <b> <op> <add> <g> <dvars> <s>)
     (exp-interacts <sub-exp> <b> <op> <add> <g> <dvars> <s>)))

(def-exists-interacts
 (exists-interacts <vars-lst> <gen-exp> <sub-exp> <b> <op> <add> <g> <dvars> <s>)
 (or (exp-interacts <gen-exp> <b> <op> <add> <g> <dvars> <s>)
     (let (<igen-exp>)(ps-subst-bindings <igen-exp> <gen-exp> <b>)
      (let (<new-dvars>) (ps-make-dvars <new-dvars> <vars-lst> <dvars>)
       (forall <vars-lst> (known <s> <igen-exp>)
        (exp-interacts <sub-exp> <b> <op> <add> <g> <new-dvars> <s>))))))


(def-and-interacts
 (and-interacts <exps> <b> <op> <add> <g> <dvars> <s>) 
 (and (~ (is-null <exps>))
      (let (<subexp>) (is-car <subexp> <exps>)
        (or (exp-interacts <subexp> <b> <op> <add> <g> <dvars> <s>)
            (let (<rest>) (is-cdr <rest> <exps>)
              (and-interacts <rest> <b> <op> <add> <g> <dvars> <s>))))))

(def-null-or-interacts
 (or-interacts <exps> <b> <op> <add> <g> <dvars> <s>)
  (is-null <exps>))

(def-or-interacts
 (or-interacts <exps> <b> <op> <add> <g> <dvars> <s>)
  (let (<subexp>) (is-car <subexp> <exps>)
    (and (exp-interacts <subexp> <b> <op> <add> <g> <dvars> <s>)
           (let (<rest>) (is-cdr <rest> <exps>)
             (or-interacts <rest> <b> <op> <add> <g> <dvars> <s>)))))


(def-application-interacts
 (application-interacts <add> <op> <r-bindings> <dvars> <g> <s>)
 (exists (<s2>)  (interacts <s2>)
   (apply-op-to-generate-new-state <s2> <op> <add> <r-bindings> <g> <s>)))

		  ))

