#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

; This is some hairy stuff in here.....compiled versions of proof schemas.


; possible bug, I use singleton-realify when I really should use all-realify
; in many places -- most exp can be universally quantified and match a 
; variety of things.

(proclaim '(special *CLOSED-PREDS* *STATIC-PREDS* *FUNCTION-PREDS* 
		*MACRO-LEARNING* *COMPILED-SCHEMAS*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


;  WARNING -- when regressing, we use same var names as in operators.
;  I think this could end up over specializing things if two operators
; have the same variable names...

(setq *COMPILED-SCHEMAS*
  '(generate-subgoal-state apply-op-to-generate-new-state 
       top-level-goal-rejected-by-scr op-rejection-rule-fired 
       implies-op-fails legal-operator implies-op-interacts
       op-binding-list is-goal-literal 
       already-ach-lit start-macrop goal-rejected-by-scr
       goal-selected-by-scr op-selected-by-scr node-rejection-rule-fired 
       apply-op-to-generate-succ-state no-change bindings-rejected
       is-succeeding-subgoal-state has-rhs-constants not-relevent))

(defun has-rhs-constants (h goal add)
  (cond ((or (is-variable goal) (is-variable add)) 
	 (error "HAS-RHS-CONSTANTS: no vars allowed"))
	(t (g-loop (init ret-val nil)
		   (next goal (cdr goal) add (cdr add))
		   (while goal)
		   (do (if (not (is-variable (car add)))
			   (push `(is-equal ,(car goal) ,(car add))
				 ret-val)))
		   (result (cond ((null ret-val) t)
				 ((null (cdr ret-val)) (car ret-val))
				 ((cons 'and ret-val))))))))


(defun start-macrop (h op)
  (list 'macrop (list (list op  (get op 'params)))))

(defun legal-operator (h op)
    (cond ((is-variable op) 
	   (list 'is-equal op (get h 'h-op)))
	  (t t)))

(defun already-ach-lit (h g)
  (cond ((is-variable g)
	 (let ((a-goal (cadr (node-failure-reason (getn h)))))
	   (cond ((negated-p a-goal)
		  (list 'is-equal g
			(list '~ (cons (caadr a-goal)
				       (make-n-proof-vars
					(length (cdadr a-goal)))))))
		 (t (list 'is-equal g 
			  (cons (car a-goal)
				(make-n-proof-vars (length (cdr a-goal)))))))))
	(t t)))


(defun is-goal-literal (h g)
  (cond ((is-variable g)
	 (let ((real-g (get h 'h-goal)))
	   (cond ((negated-p real-g)
		  (list 'is-equal g
			(list '~ 
			      (cons (caadr real-g)
				    (make-n-proof-vars
				     (length (cdadr real-g)))))))
		 (t (list 'is-equal g 
			  (cons (car real-g)
				(make-n-proof-vars (length (cdr real-g)))))))))
	(t t)))



(defun op-binding-list (h b op)
    (cond ((is-variable op) (error "op cant be var"))
	  (t `(is-equal ,b ,(get op 'params)))))

(defun implies-op-fails (h n g op exp)
    (cond ((atomic-formula-p exp)
	   (cond ((and (eq (car exp) 'alt-on-deck)
		       (eq (caddr exp) (caddr (get h 'alt-form)))
		       (eq (cadddr exp) (cadddr (get h 'alt-form))))
		  `(and (is-equal ,g ,(caddr exp))
			(is-equal ,op ,(cadddr exp))))
		 ((eq (car exp) 'has-bound-vars) t)
		 ((node-subst n exp))))
	  ((negated-p exp) exp) 
	  ((member (car exp) '(forall exists))
	   (list (car exp) (get-vars-lst exp)
		 (implies-op-fails h n g op (get-gen-exp exp))
		 (implies-op-fails h n g op (get-exp exp))))
	  ((member (car exp) '(and or))
	   (cons (car exp)
		 (g-map (sub-exp in (cdr exp))
		       (save (implies-op-fails h n g op sub-exp)))))))

(defun implies-op-interacts (h n g op exp)
   (implies-op-fails h n g op exp))

	  
; entry = ((rule-nm bindings sel-goal))

(defun goal-selected-by-scr (h n g)
    (let ((entry (node-select-goal-hst (getn h)))
	  rule-nm bindings r-sel-goal sig lhs sig-lhs)
	 (setq rule-nm (caar entry)
	       bindings (cadar entry)
	       r-sel-goal (caddar entry))
	 (cond ((null entry) (error "bad discrimination"))
	       ((cdr entry)(error "more than one goal-select entry"))
	       ((not (get rule-nm 'was-learned)) 
		(error "not learned goal-select rule" rule-nm))
	       ((not (equal r-sel-goal (get h 'h-goal)))
		(error "not same goal?"))
	       (t (format t "~%~%WARNING--- GOAL-SELECTED by learned rule, UNTESTED-CODE")))
	 (setq sig-lhs (list (get rule-nm 'sig-for-ebs)
			     (get rule-nm 'lhs-for-ebs)))
	 (setq sig-lhs (fresh-vars sig-lhs))
	 (setq sig (cdr (car sig-lhs))
	       lhs (cadr sig-lhs))
	 (list 'and 
	       (list 'is-equal n (car sig))
	       (list 'is-equal g (cadr sig))
	       lhs)))

; shouldnt be used at top-level-node

(defun goal-rejected-by-scr (h n g)
    (let ((entry (node-reject-goal-hst (getn h)))
	  rule-nm bindings r-rej-goal sig lhs sig-lhs)
	 (setq rule-nm (caar entry)
	       bindings (cadar entry)
	       r-rej-goal (caddar entry))
	 (cond ((null entry) (error "bad discrimination"))
	       ((and (cdr entry)
		     (error "more than one goal-reject entry")))
	       ((not (get rule-nm 'was-learned)) 
		(error "not learned goal-reject rule" rule-nm))
	       ((not (equal r-rej-goal (get h 'h-goal)))
		(error "not same goal?"))
	       (t (format t "~%~%WARNING--- GOAL-REJECTED by learned rule, UNTESTED-CODE")))
	 (setq sig-lhs (list (get rule-nm 'sig-for-ebs)
			     (get rule-nm 'lhs-for-ebs)))
	 (setq sig-lhs (fresh-vars sig-lhs))
	 (setq sig (cdr (car sig-lhs))
	       lhs (cadr sig-lhs))
	 (list 'and 
	       (list 'is-equal n (car sig))
	       (list 'is-equal g (cadr sig))
	       lhs)))


(defun top-level-goal-rejected-by-scr (h n g)
    (format t "~%~%WARNING--- top-level GOAL REJECTED, UNTESTED-CODE")
    (g-loop (init entries (node-reject-goal-hst (getn h))
		rule-nm nil bindings nil r-rej-goal nil 
		sig nil lhs nil sig-lhs nil entry nil)
	  (before-starting 
	      (cond ((null entries) (error "bad discrimination"))
		    ((not-top-level-node (getn h))
		     (error "must be top-leve node"))))
	  (while (setq entry (pop entries)))
	  (do (setq rule-nm (car entry)
		    bindings (cadr entry)
		    r-rej-goal (caddr entry))
	      (cond ((not (get rule-nm 'was-learned)) 
		     (error "not learned goal-reject rule" rule-nm)))
	      (cond ((equal r-rej-goal (get h 'h-goal))
		     (setq sig-lhs (list (get rule-nm 'sig-for-ebs)
					 (get rule-nm 'lhs-for-ebs)))
		     (setq sig-lhs (fresh-vars sig-lhs))
		     (setq sig (cdr (car sig-lhs))
			   lhs (cadr sig-lhs))
		     (return (list 'and 
				   (list 'is-equal n (car sig))
				   (list 'is-equal g (cadr sig))
				   lhs)))))
	  (result (error "couldn't find rej-goal"))))

; record = (rule-nm bindings sel-op)

(defun op-selected-by-scr (h n g op)
    (let ((record (get h 'op-select-record))
	  rule-nm bindings r-sel-op sig lhs sig-lhs)
	 (setq rule-nm (car record)
	       bindings (cadr record)
	       r-sel-op (caddr record))
	 (cond ((null record) (error "bad discrimination"))
	       ((not (get rule-nm 'was-learned)) 
		(error "not learned op-select rule" rule-nm))
	       ((not (eq op r-sel-op))(error "bad r-sel-op")))
	 (setq sig-lhs (list (get rule-nm 'sig-for-ebs)
			     (get rule-nm 'lhs-for-ebs)))
	 (setq sig-lhs (fresh-vars sig-lhs))
	 (setq sig (cdr (car sig-lhs))
	       lhs (cadr sig-lhs))
	 (list 'and 
	       (list 'is-equal n (car sig))
	       (list 'is-equal g (cadr sig))
	       (list 'is-equal op (caddr sig))
	       lhs)))

; returns first sub exp where vars have been generated.

(defun safely-generated (vars exp dvars)
    (cond ((null (ldiffq vars dvars)) exp)
	  ((member (car exp) '(exists forall))
	   (safely-generated vars (get-exp exp) 
	       (append (cdr (get-gen-exp exp)) dvars)))
	  ((member (car exp) '(and or))
	   (g-loop (init ret-val nil)
		 (next exp (cdr exp))
		 (while exp)
		 (do (setq ret-val (safely-generated vars (car exp) dvars)))
		 (until ret-val)
		 (result ret-val)))))



; cons or onto list, or ret single val

; entry is  (dvars op real-goal real-bindings rule-name)
		 
; if dvars is t, this unfortunately doesn't guarantee that
; all the appropriate variables have been defined...so added safely
; generated hack

(defun bindings-rejected (h s exp g op add right-b dvars)
  (if (node-EBL-reject-bindings-hst (getn h)) 
      (g-loop (init ret-val nil entry nil found-entries nil rule nil
		    entries (get h 'EBL-reject-bindings-hst)
		    sig-lhs nil sig nil lhs nil)
	      (while (setq entry (pop entries)))
	      (do (cond ((and (cond ((eq dvars t) 
				     (or (null (ldiffq (car entry)
						       (get op 'all-rhs-lhs-vars)))
					 (equal exp (safely-generated 
						     (car entry) 
						     (get op 'lpreconds)
						     (get op 'all-rhs-lhs-vars)))))
				    ((null (ldiffq (car entry) dvars)) t))
			      (eq (cadr entry) op)
			      (equal (caddr entry)(get h 'h-goal))
			      (equal (get h 'h-goal) ; check for correct add
				     (subpair (get op 'params) (cadddr entry)
					      add)))
			 (push entry found-entries)
			 (setq rule (caddr (cddr entry)))
			 (setq sig-lhs (list (get rule 'sig-for-ebs)
					     (get rule 'lhs-for-ebs)))
			 (setq sig-lhs (fresh-vars sig-lhs))
			 (setq sig (cdr (car sig-lhs))
			       lhs (cadr sig-lhs))
			 (push `(and (is-equal ,s ,(car sig))
				     (is-equal ,g ,(cadr sig))
				     (is-equal ,op ,(caddr sig))
				     (is-equal ,(subst-bindings
						 (get op 'params) right-b)
					       ,(cadddr sig))
				     ,lhs)
			       ret-val))))
	      (result (cond (found-entries
			     (setf 
			      (get h 'EBL-reject-bindings-hst)
			      (del-memq-list found-entries
					     (get h 'EBL-reject-bindings-hst)))
			     (cond ((null ret-val) (error "no entry found"))
				   ((null (cdr ret-val)) (car ret-val))
				   ((cons 'or ret-val)))))))))

				      


	 
(defun node-rejection-rule-fired (h s)
    (let ((rule-nm (caar (node-reject-node-hst (getn h))))
	  sig lhs sig-lhs)	  
	 (setq sig-lhs (list (get rule-nm 'sig-for-ebs)
			     (get rule-nm 'lhs-for-ebs)))
	 (setq sig-lhs (fresh-vars sig-lhs))
	 (setq sig (cdr (car sig-lhs))
	       lhs (cadr sig-lhs))
	 `(and (is-equal ,s ,(car sig))
	       ,lhs)))


(defun op-rejection-rule-fired (h s g op)
    (let ((rule (get h 'op-reject-rule))
	  sig lhs sig-lhs)
	 (or (get rule 'sig-for-ebs)
	     (error "NO EBS-SIG found " rule))
	 (setq sig-lhs (list (get rule 'sig-for-ebs)
			     (get rule 'lhs-for-ebs)))
	 (setq sig-lhs (fresh-vars sig-lhs))
	 (setq sig (cdr (car sig-lhs))
	       lhs (cadr sig-lhs))
	 `(and (is-equal ,s ,(car sig))
	       (is-equal ,g ,(cadr sig))
	       (is-equal ,op ,(caddr sig))
	       ,lhs)))
	   

    
(defun cmp-uniq (exp)
    (prog (new-vars old-vars new-exp)
	  (setq old-vars (find-all-vars exp))
	  (setq new-vars (make-n-proof-vars (length old-vars)))
	  (setq new-exp (subpair old-vars new-vars exp))
	  (return new-exp)))

(defun corres-atomics (exp1 exp2)
    (cond ((member (car exp1) '(and or))
	   (g-map (sub1 in (cdr exp1))
		 (sub2 in (cdr exp2))
		 (splice (corres-atomics sub1 sub2))))
	  ((member (car exp1) '(forall exists))
	   (nconc (corres-atomics (get-gen-exp exp1) (get-gen-exp exp2))
		  (corres-atomics (get-exp exp1) (get-exp exp2))))
	  ((negated-p exp1)
	   (list (list exp1 exp2) (list (cadr exp1)(cadr exp2))))
	  ((eq 'known (car exp1))
	   (cons (list exp1 exp2) (corres-atomics (caddr exp1) (caddr exp2))))
	  ((atomic-formula-p exp1)
	   (list (list exp1 exp2)))
	  ((error "bad-exp"))))
    
	  
    

; the list of open schemas that have been compiled and are not evaluable.

(defun generate-subgoal-state (h exp g-goal parent-goal rhs-bindings new-state) 
    (let ((new-exp (cmp-uniq exp)))
	 (r-generate-subgoal-state new-exp h g-goal 
	     parent-goal rhs-bindings new-state 
	     (get h 'h-goal)
	     (get h 'h-child)
	     (corres-atomics new-exp exp))))
    

; assumes state (node) is first arg
(defun node-subst (new-node exp)
    (cond ((member (car exp)
		 '(alt-on-deck high-on-goal-stack direct-supergoal-of 
		      was-added was-deleted was-deleted-by is-top-level-goal
		      previous-state-diff protected-goal has-bound-vars 
		      adjunct-goal on-goal-stack current-goal in-goal-exp
		      primary-candidate-goal candidate-goal
		      known achievable provable))
	   (cons (car exp) (cons new-node (cddr exp))))
	  (exp)))


(defun singleton-realify (orig-exp h childn pairs)
    (let ((exp (cadr (assoc orig-exp pairs))))   
	 (cond ((or (member (car (get h 'te)) 
			  '(fails goal-fails op-fails bindings-fail sole-op))
		    (and (member (car (get h 'te))
				 '(interacts goal-interacts op-interacts
					     bindings-interact))
			 (eq 'supporting-failure (node-gi-label childn))
			 (not (previously-proved ; in case side extended
				  (list 'interacts childn)))))
		(let ((sub-hist (te-to-hist (list 'fails childn))))
		     (or sub-hist (error "singleton-realify: no hist found"))
		     (cond ((caadr (assoc exp (get sub-hist (node-name childn))
					  :test #'equal))) ; dependencies
			   (t (format t"~%Warning: Couldn't realify: ~a ~a ~a~%" exp h childn) nil))))
	       ((member (car (get h 'te))
			'(interacts goal-interacts
				    op-interacts bindings-interact))
		; hack alert
		(let ((sub-hist (te-to-hist
				 (cond ((and (get h 'h-child)
					     (eq 'supporting-failure
						 (node-gi-label (get h 'h-child)))
					     (not (previously-proved ; in case side extended
						   (list 'interacts childn))))
					(list 'fails childn))
				       (t (list 'interacts childn))))))
		     (or sub-hist (error "singleton-realify: no hist found"))
		     (cond ((caadr (assoc exp (get sub-hist (node-name childn))
					  :test #'equal))) ; dependencies
			   (t
			    (format t "~%Warning: Couldn't realify: ~a ~a ~a~%"
				    exp h childn) nil))))
	       ((member (car (get h 'te)) '(op-succeeds))
		(let ((sub-hist (te-to-hist 
				    (cond ((get h 'top-level-succ-with-mult-goals)
					   (list 'op-succeeds childn
						 (get h 'new-h-goal)
						 (get h 'new-h-applic-op)
						 (get h 'new-h-bindings)))
					  ((list 'op-succeeds childn
						 (get h 'h-goal)
						 (get h 'h-applic-op)
						 (get h 'h-bindings)))))))
		     (or sub-hist (error "singleton-realify no hist found"))
		     (cond ((caadr (assoc exp (get sub-hist (node-name childn))
					  :test #'equal))) ; dependencies
			   (t (format t "~%warning, singleton-realify: couldn't find exp ~A ~A ~A~%" exp h childn) nil))))
	       (t (format t "~% Problem in singleton-realify ~A ~A ~A"
			  exp h childn)
                  (throw 'learning-result nil)))))



;  can make this more elegant
(defun all-realify (orig-exp h childn pairs)
   (let ((exp (cadr (assoc orig-exp pairs :test #'equal))))   
	 (cond ((or (member (car (get h 'te))
			    '(fails goal-fails op-fails bindings-fail))
		    (and (member (car (get h 'te)) 
			       '(interacts goal-interacts
					   op-interacts bindings-interact))
			 (eq 'supporting-failure (node-gi-label childn))
			 (not (previously-proved ; in case side extended
				  (list 'interacts childn)))))
		(let ((sub-hist (te-to-hist (list 'fails childn))))
		     (or sub-hist (error "all-realifys: no hist found"))
		     (cond ((cadr (assoc exp (get sub-hist (node-name childn))
					 :test #'equal))) ;dependencies
			   (t (format t "~%Warning, all-realify: couldnt find exp ~a ~a ~a~%" exp h childn)
			      nil))))
	       ((member (car (get h 'te)) '(interacts goal-interacts op-interacts bindings-interact))
		(let ((sub-hist (te-to-hist (cond ((and (eq 'supporting-failure 
							    (node-gi-label (get h 'h-child)))
							(not (previously-proved ; in case side extended
								 (list 'interacts childn))))
						   (list 'fails childn))
						  (t (list 'interacts childn))))))
		     (or sub-hist (error "all-realifys: no hist found"))
		     (cond ((cadr (assoc exp (get sub-hist (node-name childn))
					 :test #'equal))) ; dependencies
			   (t (format t "~%Warning, all-realify: couldnt find exp ~a ~a ~a~%" exp h childn) nil))))
	       ((member (car (get h 'te)) '(op-succeeds))
		(let ((sub-hist (te-to-hist 
				    (cond ((get h 'top-level-succ-with-mult-goals)
					   (list 'op-succeeds childn
						 (get h 'new-h-goal)
						 (get h 'new-h-applic-op)
						 (get h 'new-h-bindings)))
					  ((list 'op-succeeds childn
						 (get h 'h-goal)
						 (get h 'h-applic-op)
						 (get h 'h-bindings)))))))
		     (or sub-hist (error "all-realifys: no hist found"))
		     (cond ((cadr (assoc exp (get sub-hist (node-name childn))
					 :test #'equal))) ; dependencies
			   (t (format t "~%Warning, all-realify: couldnt find exp ~A ~A ~A~%" exp h childn) nil))))
	       (t (format t "~% Problem in all-realify ~A ~A ~A" exp h childn)
                  (throw 'learning-result nil)))))
		

(defun r-generate-subgoal-state (exp h g-goal parent-goal b new-state 
				     r-goal child pairs)
  (cond ((atomic-formula-p exp)
	 (cond ((eq (car exp) 'alt-on-deck)
		(let ((realified-goal (caddr (singleton-realify exp h
								child pairs))))
		  (cond ((null realified-goal) nil)
			;; should test node too...?
			((equal r-goal realified-goal)  
			 (get-eqs (caddr exp) parent-goal))
			((node-subst new-state exp)))))
	       ((eq (car exp) 'has-bound-vars)
		(gen-subgoal-state-for-has-bound-vars
		 exp h child b pairs r-goal parent-goal new-state))
	       ((eq (car exp) 'not-top-level-node) t)
	       ((eq (car exp) 'current-goal)(debug-break))
	       ((eq (car exp) 'candidate-goal) ; only used by goal-stack
		;; cycle, in which case g-goal is gr-cond, so am ok with this
		(get-eqs g-goal (caddr exp)))
	       ((eq (car exp) 'primary-candidate-goal)
		(get-eqs g-goal (caddr exp)))
	       ((eq (car exp) 'on-goal-stack) ; affects meaning of
		(gen-subgoal-state-for-goal-stack 
		 exp h child pairs r-goal parent-goal new-state))
	       ((and (eq (car exp) 'is-subgoal)
		     (lit-match (caddr exp) g-goal)) ; have to change
		t)
	       (t (node-subst new-state exp))))
	((negated-p exp)
	 (list '~ (r-generate-subgoal-state (cadr exp) h g-goal parent-goal
					    b new-state r-goal child pairs)))
	((member (car exp) '(let forall exists))
	 (list (car exp)
	       (get-vars-lst exp)
	       (r-generate-subgoal-state (get-gen-exp exp) h g-goal 
				 parent-goal b new-state r-goal child pairs)
	       (r-generate-subgoal-state (get-exp exp) h g-goal 
				 parent-goal b new-state r-goal child pairs)))
	((member (car exp) '(and or))
	 (cons (car exp)
	       (g-map (sub-exp in (cdr exp))
		      (save (r-generate-subgoal-state sub-exp h g-goal 
						      parent-goal b new-state
						      r-goal child pairs)))))))
    
(defun gen-subgoal-state-for-has-bound-vars (exp h child b pairs
						 r-goal parent-goal new-state)
  (let ((realified-goal (caddr (singleton-realify exp h child pairs)))
	(real-op (cadddr exp))) ; assume op is bound
    (cond ((null realified-goal) nil)
	  ((equal r-goal realified-goal)  ;  should test node too...?
	   (cons 'and
		 (cons (get-eqs (caddr exp) parent-goal)
		       (g-map (bvar in (caddr (cddr exp)))
 			      (var in (subst-bindings (get real-op 'vars) b))
			      (when bvar)
			      (save (list 'is-equal bvar var))))))
	  (t (node-subst new-state exp)))))
    
(defun gen-subgoal-state-for-goal-stack (exp h child pairs r-goal
					     parent-goal new-state)
  (let ((r-on-gs-exps (all-realify exp h child pairs)))
    ;; assume if we find more than one realified
    ;; then exp is univ quantified
    (cond ((null r-on-gs-exps) nil) ; didn't matter !
	  ((simp-collapse
	    (cons 'or (g-map (r-on-gs in r-on-gs-exps)
			 (save (cond ((equal r-goal (caddr r-on-gs))
				      (get-eqs (caddr exp) parent-goal))
				     (t (node-subst new-state exp)))))))))))

(defun simp-collapse (exp)
    (cond ((atom exp) exp)
	  ((not (member (car exp) '(and or))) exp)
	  ((null (cdr exp)) (error "simp-collapse error"))
	  ((null (cddr exp)) (cadr exp))
	  (t exp)))
	   

(defun is-succeeding-subgoal-state (h child goal node)
    (r-node-replace child node))
    
(defun no-change (h new-s old-s)
  (r-node-replace old-s new-s))

; assumes no knowns within knowns

(defun r-node-replace (exp newn)
    (cond ((eq exp t) exp)
	  ((member (car exp) '(and or))
	   (cons (car exp)
		 (g-map (sub in (cdr exp))
		       (save (r-node-replace sub newn)))))
	  ((member (car exp) '(exists forall))
	   (list (car exp)(get-vars-lst exp)
		 (r-node-replace (get-gen-exp exp) newn)
		 (r-node-replace (get-exp exp) newn)))
	  ((negated-p exp)
	   (list (car exp)
		 (r-node-replace (cadr exp) newn)))
	  ((atomic-formula-p exp)
	   (node-subst newn exp))
	  (exp)))
		  
		  
    


; expect exp = (and sub (is-equal ...)(is-equal ...)(is-equal .)(is-equal..))
; break out last is equals..

(defun apply-op-to-generate-succ-state (h old-exp op goal-add new-state)
    (let ((child (get h 'h-child))
	  (new-exp (cmp-uniq old-exp))
	  sub-result)
	 ; hack, special casing
	 (setq sub-result
	       (cond ((get h 'top-level-succ-with-mult-goals)
		      (regress new-exp h op new-state
			  (make-binding-list (get op 'vars)
			      (get h 'h-bindings))
			  child (corres-atomics new-exp old-exp)))
		     (t (regress new-exp h op new-state
			    (make-binding-list (get op 'vars)
				(alt-vars (node-generating-alt child)))
			    child (corres-atomics new-exp old-exp)))))
	 (subpair 
	     (get-imp-succ-vars new-exp)
	     (get-imp-succ-vars old-exp)
	     sub-result)))


; horrible, have to recover variable names that were lost...

(defun get-imp-succ-vars (exp)
    (prog (eqs e1 e2 e3 e4)
	  (setq eqs (cddr exp))
	  (setq e1 (car eqs))
	  (setq e2 (cadr eqs))
	  (setq e3 (caddr eqs))
	  (setq e4 (cadddr eqs))
	  (return (list (caddr e1)
			(caddr e2)
			(caddr e3)
			(caddr e4)))))
	


;  we dont need g as a param, I added it by mistake

; h = child

(defun apply-op-to-generate-new-state (h old-exp op goal-add 
					 rght-bindings g new-state)
    (let ((child (get h 'h-child))
	  (new-exp (cmp-uniq old-exp)))
	 (subst-bindings (regress new-exp h op new-state
			     (make-binding-list (get op 'vars)
				 (alt-vars (node-generating-alt child)))
			     child (corres-atomics new-exp old-exp))
	     rght-bindings)))



(defun regress (exp h op new-state h-bindings child pairs)
    (cond ((eq (car exp) 'exists)
	   (list 'exists (get-vars-lst exp)
		 (regress (get-gen-exp exp)
			  h op new-state h-bindings child pairs)
		 (regress (get-exp exp)
			  h op new-state h-bindings child pairs)))
	  ((eq (car exp) 'forall)
	   (list 'forall (get-vars-lst exp)
		 (regress (get-gen-exp exp)
			  h op new-state h-bindings child pairs)
		 (regress (get-exp exp)
			  h op new-state h-bindings child pairs)))
	  ((member (car exp) '(and or))
	   (cons (car exp)
		 (g-map (sub in (cdr exp))
		        (save (regress sub h op
				       new-state h-bindings child pairs)))))
	  ((negated-p exp)
	   (cond ((eq 'exists (caadr exp))
		  exp)
		 ((or (static-p (cadr exp))
		      (function-p (cadr exp)))
		  (node-subst new-state exp))
		 ((neg-regress-pred exp h op h-bindings child pairs))))
	  ((atomic-formula-p exp) 
	   (cond ((eq (car exp) 'known)
		  (list 'known new-state
			(regress (caddr exp)
                                h op new-state h-bindings child pairs)))
		 ((eq (car exp) 'current-goal) (debug-p))
		 ; not really correct?
		 ((eq (car exp) 'not-top-level-node) t)
		 ((eq (car exp) 'primary-candidate-goal)
		  (cons 'on-goal-stack (cons new-state (cddr exp))))
		 ((and (eq (car exp) 'protected-goal)
		       (equal (caddr (singleton-realify exp h child pairs))
			      (alt-goal (node-generating-alt child))))
		  (cond ((negated-p (caddr exp))
			 (regress-deletion exp op new-state h-bindings h
			     child pairs))
			(t (regress-addition exp op new-state h-bindings h
			       child pairs))))
		 ((eq (car exp) 'was-added)
		  (regress-addition exp op new-state h-bindings h child pairs))
		 ((member (car exp) '(was-deleted was-deleted-by))
		  (regress-deletion exp op new-state h-bindings h child pairs))
		 ((eq (car exp) 'previous-state-diff)
		  (cond ((get op 'inference-rule) exp)
			(t (regress-previous-state-diff
			    exp h child op h-bindings new-state pairs))))
		 ; below used when top-level goal is deleted by 
		 ((and (or (eq (car exp) 'is-top-level-goal)
			   (eq (car exp) 'adjunct-goal))
		       (let ((r-goal (singleton-realify exp h child pairs)))
			    (cond ((not r-goal) 
				   (format t "~%WARNING: cant singleton-realify adjunct") nil)
				  ((and (caddr r-goal)
					(exp-match (caddr r-goal) '((nil nil))
						   (node-state (getn h))))))))
		  (list 'in-goal-exp new-state (caddr exp)))
		 ((eq (car exp) 'macrop)
		  (list 'macrop (cons (list op (get op 'vars)) 
				      (cadr exp))))
		 ((static-p exp) (node-subst new-state exp))
		 ;; just noticed, shouldn't all functions be static? so is this redundant?
		 ((function-p exp) (node-subst new-state exp))
		 ((regress-pred exp h op h-bindings child pairs))))))

; regresses was-added and protected-goal lits
; should add something to insure not deleted, like in regress-deletion

(defun regress-addition (orig-exp op new-state h-bindings h child-n pairs)
    (let ((lit (caddr orig-exp))
	  (r-lit (caddr (singleton-realify orig-exp h child-n pairs))))
	 (cond ((null r-lit) nil)
	       ((not (member r-lit
			     (cond ((negated-p lit)
				    (state-false-assertions
					(node-state (node-parent child-n))))
				   ((state-true-assertions 
					(node-state (node-parent child-n)))))
			     :test #'equal))
		(get-eqs lit
		    (find-matching-diff r-lit
			(subst-bindings (get op 'add-list) h-bindings)
			(get op 'add-list))))
	       (t (node-subst new-state orig-exp)))))


; regress was-deleted and goal-protection lits.

(defun regress-deletion (orig-exp op new-state h-bindings h child-n pairs)
    (let ((lit (caddr orig-exp))
	  (r-lit (caddr (singleton-realify orig-exp h child-n pairs))))
	 (cond ((null r-lit) nil)
	       ((member r-lit
			(state-true-assertions 
			    (node-state (node-parent child-n)))
			:test #'equal)
		(pre-addition-checks lit
		    (get-eqs lit
			(find-matching-diff r-lit
			    (subst-bindings (get op 'del-list) h-bindings)
			    (get op 'del-list)))
		    (get op 'add-list) op))
	       (t (node-subst new-state orig-exp)))))




;  uses lit-match instead of equals cause of wild-card deletes
; Can possibly return bad results when real diffs has variables 
; (realify problem?) and there are two or more predicates that might match.

(defun find-matching-diff (real-eff real-diffs diffs)
    (cond ((null diffs) nil)
	  ((and (has-vars (car real-diffs))
		(rhs-match real-eff (car real-diffs)))
	   (car diffs))
	  ((lit-match real-eff (car real-diffs))
	   (car diffs))
	  (t (find-matching-diff real-eff (cdr real-diffs) (cdr diffs)))))

;  regress (previous-state-diff <s> <differences>)

(defun regress-previous-state-diff (exp h childn op h-bindings new-state pairs)
    (g-loop (init effs (append (g-map (del in (get op 'del-list))
				   (save (negate del)))
			     (get op 'add-list))
		eff nil matching-diff nil eq-constraints nil
		diffs (caddr exp) new-diffs diffs real-eff nil
		real-effs (subst-bindings effs h-bindings)
		real-diffs (caddr (singleton-realify exp h childn pairs))
	        super-real-effs (get-actual-diffs 
				       (state-closed-world
					(node-state childn)) 
				       (state-closed-world
					(node-state (getn h))))
		real-wild-dels (find-real-wild-deletions real-effs
					super-real-effs))
	  (while (and (setq eff (pop effs))
		      (setq real-eff (pop real-effs))))
	  (do (cond ((setq matching-diff
			   (find-matching-diff real-eff real-diffs diffs))
		     (push (get-eqs eff matching-diff) eq-constraints)
		     (setq new-diffs (del-eq matching-diff new-diffs)))
		    ((and (negated-p real-eff)
			  (has-vars real-eff)) ; is wild card del
		     (setq new-diffs
			   (append (make-n-wild-diffs real-wild-dels
				       (negate eff) (negate real-eff))
				   new-diffs))
		     (setq real-wild-dels 
			   (rm-found-wild-dels (negate real-eff) 
			       real-wild-dels)))
		    ((and (member real-eff super-real-effs
		  			:test #'equal) ; insures not added
						       ; and deleted
			  (push (negate eff) new-diffs)))))
	  (result (cond ((null new-diffs) (cons 'and eq-constraints))
			((null eq-constraints)
			 (list 'previous-state-diff new-state new-diffs))
			(t (cons 'and 
			        (cons (list 'previous-state-diff new-state
					   new-diffs)
				     eq-constraints)))))))
	   
(defun find-real-wild-deletions (real-effs super-real-effs)
     (g-map (eff in super-real-effs)
	   (when (and (negated-p eff)
		      (not (member eff real-effs
				   :test #'equal)))) ; must have var
           (save (negate eff))))
		       


     
; see how many times eff was deleted, and make n diffs.
; produces overspecific rules perhaps, but at least it should always work

(defun make-n-wild-diffs (real-wild-dels del almost-real-del)
  (g-map (real-d in real-wild-dels)
	 (when (lit-match almost-real-del real-d))
	 (save (make-del-with-unique-wild-card del almost-real-del))))

(defun rm-found-wild-dels (almost-real-del real-wild-dels)
  (let ((found-guys 
	 (g-map (d in real-wild-dels)
		(when (lit-match almost-real-del d))
		(save d))))
    (ldifference real-wild-dels found-guys)))



(defun make-del-with-unique-wild-card (del real-del)
    (g-map (v1 in del)
	  (v2 in real-del)
	  (save (cond ((is-variable v2)
		       (car (make-n-unique-vars 1)))
		      (t v1)))))


(defun get-eqs (lit1 lit2)
  (cond ((negated-p lit1)
	 (and (negated-p lit2)
	      (get-eqs (cadr lit1)(cadr lit2))))
	(t (cons 'and
		 (g-map (arg1 in lit1)
			(arg2 in lit2)
			(save (list 'is-equal arg1 arg2)))))))



; dels can be wildcards. (ifs not currently addressed).
; negated exps handled in spearate function
; exp is a postive lit

(defun regress-pred (exp h op h-bindings child pairs)
    (let ((add-lst (get op 'add-list))
	  (del-lst (get op 'del-list))
	  (real-exps (all-realify exp h child pairs)))
	 (cond ((null real-exps) 
		(cond ((and (eq 'scheduled (car exp))
			    (or *MACRO-LEARNING*  ; hack altert to deal
				;; with forall that goes away, leaving
				;; an unbound var in  notequal. should
				;; handle in simplifier
				(member (car (get h 'te)) 
				      '(op-succeeds goal-succeeds
					   bindings-succeed))))
		       exp)
		      (t nil)))
	       ((cdr real-exps)
		(amb-regress-pred exp real-exps add-lst del-lst 
		    op h-bindings))
	       ((unamb-regress-pred exp (car real-exps) add-lst del-lst 
		    op h-bindings)))))


(defun unamb-regress-pred (exp real-exp add-lst del-lst op h-bindings)
    (cond ((g-loop (init add nil real-add nil)
		 (while (setq add (pop add-lst)))
		 (do (setq real-add (subst-bindings add h-bindings))
		     (cond ((equal real-add real-exp)
			    (return (get-eqs exp add)))))))
	  ((deletion-checks exp del-lst op))))

(defun amb-regress-pred (exp real-exps add-lst del-lst op h-bindings)
    (cond ((g-loop (init add nil real-add nil ret-val nil)
		 (while (setq add (pop add-lst)))
		 (do (setq real-add (subst-bindings add h-bindings))
		     (cond ((member real-add real-exps :test #'equal)
			    (push (get-eqs exp add) ret-val))))
		 (result (and ret-val 
			      `(or ,(deletion-checks exp del-lst op)
				   ,@ret-val)))))
	  ((deletion-checks exp del-lst op))))

; new note, wildcards will always be equal, ie.
; (or (not-equal <x> <*v>)..) = (or nil ...)

(defun deletion-checks (exp del-lst op)
    (g-loop (init del nil ret-val nil)
	  (while (setq del (pop del-lst)))
	  (do (and (lit-match del exp) ; for wild-cards
		   (push (cons 'or
			       (g-map (v1 in (cdr exp))
				     (v2 in (cdr del)) ; wildcard check
				     (when (and (member v2 (get op 'all-vars))
						(not (member v2 (get op 'wildcard-vars)))))
				     (save (list 'not-equal v1 v2))))
			 ret-val)))
	  (result (cond (ret-val (cons 'and (cons exp ret-val)))
			(exp)))))


(defun addition-checks (exp add-lst op)
    (g-loop (init add nil ret-val nil)
	  (while (setq add (pop add-lst)))
	  (do (and (lit-match add exp) ; for wild-cards ?? needed?
		   (push (cons 'or
			       (g-map (v1 in (cdr exp))
				     (v2 in (cdr add)) ; wildcard check
				     (when (member v2 (get op 'vars)))
				     (save (list 'not-equal v1 v2))))
			 ret-val)))
	  (result (cond (ret-val (cons 'and (cons (negate exp) ret-val)))
			((negate exp))))))


; need this to make sure even if the deletion happens, don't want the add to
; happen.
; adds list of tests to make sure addition doesnt happen to new-exp

(defun pre-addition-checks (exp new-exp add-lst op)
    (g-loop (init add nil ret-val nil)
	  (while (setq add (pop add-lst)))
	  (do (and (lit-match add exp) ; for wild-cards ?? needed?
		   (push (cons 'or
			       (g-map (v1 in (cdr exp))
				     (v2 in (cdr add)) ; wildcard check
				     (when (member v2 (get op 'vars)))
				     (save (list 'not-equal v1 v2))))
			 ret-val)))
	  (result (cond (ret-val
				(cons 'and (cons new-exp ret-val)))
			(new-exp)))))
			


	   
; CAN TAKE THIS OUT now, I think

(defun was-only-one (lit child)
    (g-loop (init plits (cond ((negated-p lit)
			     (setq lit (cadr lit))
			     (state-false-assertions 
				 (node-state (node-parent child))))
			    (t (state-true-assertions 
				   (node-state (node-parent child)))))
		found-one nil)
	  (while plits)
	  (do (cond ((lit-match lit (car plits))
		     (cond (found-one (return))
			   ((setq found-one t))))))
	  (next plits (cdr plits))
	  (result found-one)))
	  

;  (not relevent <add> <goal>)

(defun not-relevent (h lit1 lit2 bindings)
   (r-not-relevent lit1 lit2 bindings (get h 'h-goal)))

(defun r-not-relevent (lit1 lit2 bindings real-lit2)
    (let ((arg1 (car lit1))
	  (arg2 (car lit2))
	  (real1 (car real-lit2)))
	 (cond ((null lit1) (format t "~%error in compiled NOT-RELEVENT"))
	       ((didnt-match arg1 real1 bindings)
		(cond ((is-constant arg1)
		       (cond ((is-constant arg2)
			      (cond ((not (equal arg1 arg2)) t)
				    ((format t "~%err2 in NOT-RELEVENT"))))
			     (t `(not-equal ,arg1 ,arg2))))
		      (t `(not-equal ,(cadr (assoc arg1 bindings)) ,arg2))))
	       (t (r-not-relevent (cdr lit1) (cdr lit2)
		     (cons (list arg1 arg2) bindings)  		
		     (cdr real-lit2))))))

	
; exp is a negated lit.

(defun neg-regress-pred (exp h op h-bindings child pairs)
  (let ((add-lst (get op 'add-list))
	(del-lst (nconc (g-map (add in (get op 'add-list))
			       (when (negated-p add))
			       (save (cadr add)))
			(get op 'del-list)))
	(real-exps (mapcar #'cadr (all-realify exp h child pairs))))
    (setq exp (cadr exp))
    (cond ((null real-exps) nil)
	  ((cdr real-exps)
	   (neg-amb-regress-pred exp real-exps add-lst del-lst 
				 op h-bindings))
	  ((neg-unamb-regress-pred exp (car real-exps) add-lst del-lst 
				   op h-bindings)))))

; DELETES can have wildcards!! 

(defun neg-unamb-regress-pred (exp real-exp add-lst del-lst op h-bindings)
  (cond ((g-loop (init del nil real-del nil)
		 (while (setq del (pop del-lst)))
		 (do (setq real-del (subst-bindings del h-bindings))
		     (cond ((and (has-vars real-del)
				 (lit-match real-del real-exp))
			    (return (pre-addition-checks 
				     exp (get-eqs 
					  exp (make-del-with-unique-wild-card
					       del real-del))
				     add-lst op)))
			   ((equal real-del real-exp)
			    (return (pre-addition-checks exp (get-eqs exp del)
							 add-lst op)))))))
	((addition-checks exp add-lst op))))

(defun neg-amb-regress-pred (exp real-exps add-lst del-lst op h-bindings)
    (cond ((g-loop (init del nil real-del nil ret-val nil)
		 (while (setq del (pop del-lst)))
		 (do (setq real-del (subst-bindings del h-bindings))
		     (cond ((and (has-vars real-del)
				 (g-map (real-exp in real-exps)
				       (when (lit-match real-del real-exp))
				       (save real-exp)))
			    (push (get-eqs exp (make-del-with-unique-wild-card del real-del))
				  ret-val))
			   ((member real-del real-exps :test #'equal)
			    (push (get-eqs exp del) ret-val))))
		 (result (and ret-val 
			      `(or ,(addition-checks exp add-lst op)
				   ,(pre-addition-checks exp
					(cons 'or ret-val) add-lst op))))))
	  ((addition-checks exp add-lst op))))















