;;;
;;;
(proclaim '(special *SINGLE-HIERARCHY*))
;;;
;;; A formula is a ground level predicate that occurs as a precondition or 
;;; effect of an operator.

;;;(defstruct (formula (:print-function (lambda (formula stream level)
;;;				       (declare (ignore stream level))
;;;				       (format stream "#S~a" 
;;;                                            (formula-type formula)))))
;;;  instance    ; e.g., (in-room block1 room5)
;;;  type        ; e.g., (in-room block room)
;;;  predeladd   ; one of 'precond, 'add, 'del
;;;  status      ; one of 'primary or 'secondary
;;;  operator)   ; name of the operator

;;;=============================================================================

(defun find-constraints (context-array goal-list group-graph)
  (let ((hierarchy (copy-array group-graph)))
    (add-goal-constraints hierarchy  context-array
			  (1- (array-dimension context-array 1)))
    (cond ((null *SINGLE-HIERARCHY*)
	   (delete-unreachable-groups hierarchy 
				      (find-goals goal-list hierarchy))
;	   (remove-unnecessary-constraints hierarchy)
	   ))
    hierarchy))

;;;
;;;
;;;
;;; Given a particular problem, it determines what constraints need to
;;; be added to the directed graph to guarantee monotonicity.  This is
;;; done recursively for all of the literals that could be subgoaled on
;;; from all possible contexts.
;;;
(defun add-goal-constraints (hierarchy context-array index)
  (cond ((zerop index))
	((aref context-array 1 index 0)
	 (setf (aref context-array 1 index 1) t)
	 (add-subgoal-constraints hierarchy context-array 
				  (aref context-array 0 index 0)
				  (aref context-array 1 index 0))
	 (add-goal-constraints hierarchy context-array (1- index)))
	(t (add-goal-constraints hierarchy context-array (1- index)))))
;;;
;;;
(defun add-subgoal-constraints (hierarchy context-array literal subgoals)
  (cond ((null subgoals))
	(t 
	 (add-subgoal-constraint hierarchy context-array literal 
				 (first (car subgoals))
				 (second (car subgoals)))
	 (add-subgoal-constraints hierarchy context-array literal (cdr subgoals))
	 )))
;;;
;;;
(defun add-subgoal-constraint (hierarchy context-array literal op lit-types)
  (cond ((null lit-types))
	(t (let ((col (determine-column context-array op))
		 (row (determine-row context-array (car lit-types))))
	     (add-constraint literal (car lit-types) hierarchy 'p)
	     (cond ((null (aref context-array col row 1))
		    (setf (aref context-array col row 1) t)
		    (add-subgoal-constraints hierarchy context-array 
					     (car lit-types)
					     (aref context-array col row 0))))
	     (add-subgoal-constraint hierarchy context-array literal op 
				     (cdr lit-types))))))


;;;
;;;
;;;
;;; Takes the hierarchy and removes and propagates constraits such
;;; that the final partial order is still guaranteed to avoid
;;; monotonicity violations but allow literals to arise a different 
;;; levels.  This is useful for conditions that can be achieved
;;; without violating other conditions of the same type.
;;;
(defun remove-unnecessary-constraints (hierarchy)
  (do ((x 1 (1+ x)))
      ((= x (array-dimension hierarchy 0)))
    (do ((y 1 (1+ y)))
	((= y (array-dimension hierarchy 0)))
      (cond ((unnecessary-constraint hierarchy x y)
	     (add-related-constraints 
	      hierarchy x
	      (find-additional-row-constraints hierarchy x (list y) nil nil))
	     (setf (aref hierarchy x y) '(p)))))))
;;;	
;;;
;;;
;;; Given a list of constraints, add them to the hierarchy.
;;;
(defun add-related-constraints (hierarchy x constraints)
  (cond ((null constraints))
	(t (setf (aref hierarchy x (car constraints)) '(t)))))
;;;
;;;
;;;
;;; The the additional set of constraints that need to be added in 
;;; order to remove an unnecessary constraint.  This essentially
;;; propagates the constraints from the row constraint that is being
;;; moved.  Although, it actually does this recursively in order to
;;; only add those constraints that are absolutely necessary.
;;;
(defun find-additional-row-constraints (hierarchy row-x unchecked
						  checked constraints)
  (cond ((null unchecked) constraints)
	((member (car unchecked) checked :test #'eql)
	 (find-additional-row-constraints hierarchy row-x (cdr unchecked)
					  checked constraints))
	((constraint-p hierarchy (car unchecked)(car unchecked))
	 (find-additional-row-constraints hierarchy row-x (cdr unchecked)
					  (cons (car unchecked) checked)
					  (cons (car unchecked) constraints)))
	(t 
	 (find-additional-row-constraints 
	  hierarchy row-x 
	  (append (additional-row-constraints hierarchy row-x (car unchecked) 1)
		  (cdr unchecked))
	  (cons (car unchecked) checked)
	  constraints))))
;;;
;;;
;;; Find those constraints that occur in row-y, but not in row-x.
;;;
(defun additional-row-constraints (hierarchy row-x row-y index)
  (cond ((eql index (array-dimension hierarchy 1)) nil)
	((and (not (constraint-p hierarchy row-x index))
	      (constraint-p hierarchy row-y index))
	 (cons index (additional-row-constraints hierarchy row-x row-y
						 (1+ index))))
	(t (additional-row-constraints hierarchy row-x row-y (1+ index)))))
;;;
;;;
;;;
;;; An unnecessary constraint is one that constrains a literal to be
;;; lower than another literal even though that literal does not
;;; interact with other literals of the same type.
;;;
(defun unnecessary-constraint (hierarchy x y)
  (cond ((not (or (not (constraint-p hierarchy x y))
		  (constraint-p hierarchy y y))))))
;;;
;;;
;;; In the array 'e is a constraint due to the effects, 'p is a
;;; constraint due to the preconditions and 'g is a constraint due
;;; to a generator.
;;;
(defun constraint-p (array x y)
  (aref array x y))
;  (member 't (aref array x y) :test #'eq))
	








