;;------------------------------------------------
;; Utilities for accessing labels
;;
;; Author: Julie D. Roomy
;; Sponsoring Professor: Oren Etzioni
;;
;; The functions in this file, are meant for use outside of label-PSG.lisp.
;; any new functions which will be called by rules.lisp for example, should
;; go in this file.
;;------------------------------------------------

;; possible labels are:
;; leaf labels: unachievable gs-cycle p-holds s-holds unknown
;; internal labels: failure rec-failure success unknown



;;--------------
;; failed-label?
(defun failed-label? (label)
  (member label '(REC-FAILURE FAILURE GS-CYCLE UNACHIEVABLE)))



;;--------------
;; pure-failure-label?
(defun pure-failure-label? (label)
  (member label '(FAILURE UNACHIEVABLE)))


;;-----------
;; rec-label?
(defun rec-label? (label)
  (member label '(REC-FAILURE UNKNOWN)))


;;-------------
;; success-label?
(defun success-label? (label)
  (member label '(SUCCESS P-HOLDS S-HOLDS)))


;;-----------------
;; immediate-label?
(defun immediate-label? (label)
  (or (member label '(UNACHIEVABLE P-HOLDS S-HOLDS))
      (member label *non-goals*)
      (member label *static-preds*)))