(defun print-me (toprint)
  (print toprint))
;;; Rob Spiger and Julie Roomy


;;; taken from schedworld, and used for greater-than-zero-and-less-than
(eval-when (compile)
  (load-path *PLANNER-PATH* "g-loop"))


;;; if at least two of the three params are variables, return no-match-attempted
(defun func-subtract (original sub result)
  (cond ((is-variable sub)
	 (if (is-variable result) 
	     'no-match-attempted
	     (if (is-variable original) 
		 'no-match-attempted
		 (binding-list sub (list (- original result))))))
	((is-variable result)
	 (if (is-variable sub)
	     'no-match-attempted
	     (if (is-variable original)
		 'no-match-attempted
		 (binding-list result (list (- original sub))))))
	((is-variable original)
	 (if (is-variable sub)
	     'no-match-attempted
	     (if (is-variable result)
		 'no-match-attempted
		 (binding-list original (list (+ sub result))))))
	(T (= original (+ sub result)))))


(defun func-multiple (x y coefficient)      ;x = y*coefficient
  (cond ((is-variable x)
	 (if (is-variable y)
	     'no-match-attempted
	     (binding-list x (* coefficient y))))
	((is-variable y)
	 (binding-list y (/ x coefficient)))
	(T (= x (* coefficient y)))))

(defun func-get-new-stick-name-or-return-true (new-name)
  (cond ((is-variable new-name)
	 (setf name-generator (+ name-generator 1))
	 (binding-list new-name (list (list 'stick name-generator))))
	(T 'T)))

(defun func-get-new-frame-name (new-name)
  (cond ((is-variable new-name)
	 (setf name-generator (+ name-generator 1))
	 (binding-list new-name (list (list 'frame name-generator))))
	(T 'no-match-attempted)))

(defun func-get-new-fabric-name (new-name)
  (cond ((is-variable new-name)
	 (setf name-generator (+ name-generator 1))
	 (binding-list new-name (list (list 'fabric name-generator))))
	(T 'T)))


(defun func-point-on-stick (stick-size point)
  (cond ((is-variable stick-size) 'nil)         ;this should never occur
	((is-variable point)
	 (binding-list point (greater-than-zero-less-than-or-equal-to  stick-size)))
	(T (<= point stick-size))))


; copied directly from schedworld 

;  BINDING-LIST returns a binding list for a single variable, only
;
(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))



;copied ideas from schedworld times-before,

(defun greater-than-zero-less-than-or-equal-to (x)
  (g-loop
   (init y 1 ret-val nil)
   (while (not (> y x)))
   (do (push y ret-val))
   (next y (+ 1 y))
   (result ret-val)))

(defun func-greater-than (x y)
  (cond ((is-variable x) 'no-match-attempted)
	((is-variable y) 'no-match-attempted)
	((and (numberp x)(numberp y)) (> x y))
	(T 'nil)))

	 

	

	     
	       
		      