;;;-----------------------------------------------------
;;;   testtaskalloc.lisp 
;;;
;;;
;;;-----------------------------------------------------
(defun create-test-processors (n &optional (ps 50) (as 100))
   (let (result)
  (dotimes (x n result) (push (make-processor 
			:ipname (make-symbol (format nil "P~A" x))
			:available-storage as
			:processor-speed ps) result))))
								 
	   
(defun create-test-tasks (n &optional (mr 20))
  (let (result)
    (dotimes (x n result) (push (make-task
			:tname (make-symbol (format nil "t~A" x))
			:memory-requirement mr) result))))


;;;; testing routine to find any potential bugs, or to see how
;;;  the agorithm works

(defun test-task-allocation (n &optional (stream t))
  (do ((count 0 (1+ count))
       (test (make-test-constraints)
	     (make-test-constraints))
       assignment cost)
      ((>= count n))
	(multiple-value-setq (assignment cost)
			     (allocate-tasks test :verbose nil))
	(if assignment 
	    (progn 
	      (format stream "--------------------------~%")
	      (format stream "~A~%" test)
	      (format stream "test ~A: ~A~%" count 
			   (print-assignment assignment)))
	    (format stream "test ~A: No assignment found~%" count))))


;;;------------------------------------------------

(defun make-test-constraints ()
  (let* ((tasks (create-test-tasks (1+ (random 10)) (random 20)))
	(processors
	 (create-test-processors (1+ (random 5)) (random 50) (random 100)))
	(tn (length tasks))
	(pn (length processors)))
    (make-constraints :processors processors
		      :tasks tasks
		      :P (make-random-array (list tn pn))
		      :E (make-random-array (list tn tn))
		      :C (make-random-array (list tn tn) 'integer 100)
		      :D (make-random-array (list pn pn) 'integer 100)
		      :Q (make-random-array (list tn pn) 'integer 50))))
		      

;;; this function is used in testing the algorithm;
;;; only for two-dimensional array

(defun make-random-array (dimensions &optional (elttype 'bit) (n 2))
  (make-array dimensions :element-type elttype :initial-contents
	      (mapcar #'(lambda (x)
			  (mapcar #'(lambda (y) 
				      (random n))
				  (make-list (second dimensions))))
		      (make-list (car dimensions)))))

;;; simple structure:  all tasks can be executed on all processes,
;;; all tasks can execute on the same processor, all processor
;;; speeds are the same, all data transfers are the same.  The
;;; assignment should be to assign all the tasks to the first
;;; process.  That is, we assume that with the absence of
;;; information, the communication costs will always exceed
;;; the processor costs; hence, putting all on one processor
;;; is best.

(setq *test-structure-1*
      (make-constraints 
                        :processors (create-test-processors 3)
                        :tasks (create-test-tasks 5)
                        :P (make-array '(5 3) :element-type 'bit 
				       :initial-element 1)
			:E (make-array '(5 5) :element-type 'bit 
				       :initial-element 0)
			:C (make-array '(5 5) :initial-element 10)
			:D (make-array '(3 3) :initial-contents
				       '((0 10 10)
					 (10 0 10)
					 (10 10 0)))
			:Q (make-array '(5 3) :initial-element 100)
			))

;;;  This test has all the characteristics of the first test, but
;;;  two of the tasks can't be executed on process P0, while
;;;  one can't also execute on P1
;;;

(setq *test-structure-2*
      (make-constraints 
                        :processors (create-test-processors 3)
                        :tasks (create-test-tasks 5)
                        :P (make-array '(5 3) :element-type 'bit 
				       :initial-element 1)
			:E (make-array '(5 5) :element-type 'bit 
				       :initial-element 0)
			:C (make-array '(5 5) :initial-element 10)
			:D (make-array '(3 3) :initial-contents
				       '((0 10 10)
					 (10 0 10)
					 (10 10 0)))
			:Q (make-array '(5 3) :initial-element 100)
			))

(setf (bit (cnode-P *test-structure-2*) 0 0) 0)
(setf (bit (cnode-P *test-structure-2*) 1 0) 0)
(setf (bit (cnode-P *test-structure-2*) 1 1) 0)

 









