/* Frec: receive input from other program(s) via socket, as
 *      well as possibly stdin.  All input is simply copied to stdout.
 *      
 * Leonard Dickens, 9/2/92
 */
#include "error.h"
#include <fcntl.h>
#include <signal.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include "socket_server.h"


MNAME(__FILE__);
FILE *f_from_fd[64] = {stdin, stdout, stderr, NULL, };


void frec_exit()
{
  socket_server_shutdown();
  exit(0);
  }


void frec_close_file(sd)
     int sd;
{
  FILE *f = f_from_fd[sd];

  if (f != NULL) {
    fclose(f);
    f_from_fd[sd] = NULL;
    }
  }    


void frec_new_client(sd)
     int sd;
{
  FNAME("frec_new_client");

  if (NULL == (f_from_fd[sd] = fdopen(sd, "r")))
    SYS_ERROR("fdopen", 0, frec_exit()) ;
  if (-1 == fcntl(sd, F_SETFL, O_NONBLOCK))
    SYS_ERROR("fcntl", -1, frec_exit()) ;
  }


void frec_read_input(sd)
     int sd;
{
  int x;  
  char buffer[128];
  FILE *f = f_from_fd[sd];
  FNAME("frec_read_input");

  while (128 == (x = fread(buffer, 1, 128, f)))
    fwrite(buffer, 1, 128, stdout);
  if (x > 0)
    fwrite(buffer, 1, x, stdout);

  if (feof(f)) {
    socket_server_end_of_file(sd);
    return;
    }

  if (errno == EWOULDBLOCK)
    return;

  SYS_ERROR("fread", x, 0);
  }


int main(argc, argv)
     int argc;
     char *argv[];
{
  char *socket_port = NULL;
  int x, max_clients;
  int read_stdin = 0;
  fd_set stdin_set;
  FNAME("main");

  /* close all files except standards so that we can use them: */
  for (x = 3; x < 64; x++)
    close(x);

  x = 1;
  while (x < argc)
    {
    if (argv[x][0] == '-')
      switch (argv[x][1]) {
      case 'p': /* Port */
	socket_port = argv[++x];
	break;
      case 'c': /* Client limit */
	max_clients = atoi(argv[++x]);
	break;
      case 'i': /* Read stdin also */
	read_stdin = 1;
	}
    x++;
    }

  if (socket_port == NULL)
    {
    printf("\n\
Usage: frec [-c L] [-i] -p N\n\
          -c L  means `at maximum, allow L clients to connect at once'\n\
          -p N  means `use port N for connection socket'\n\
          -i    means `read input from stdin'\n\
\n");
    exit(0);
    }

  /* catch broken pipe signals (i.e. a client process died) harmlessly. */
  if (/* Catch control-c for smooth termination. */
      (-1 == (int) signal(SIGINT,  frec_exit))   ||
      (-1 == (int) signal(SIGTERM, frec_exit))   ||
      (-1 == (int) signal(SIGQUIT, frec_exit)))
    SYS_ERROR("signal", -1, 0);

  FD_ZERO(&stdin_set);
  if (read_stdin) {
    FD_SET(0, &stdin_set);
    if (-1 == fcntl(0, F_SETFL, O_NONBLOCK))
      SYS_ERROR("fcntl", -1, frec_exit()) ;
    }
  socket_server_initialize(frec_read_input, &stdin_set);

  if (socket_server_startup(socket_port, frec_read_input, max_clients, 
			    frec_new_client, frec_close_file))
    return;
  socket_server_poll(NULL);
  }

