
(defun l ()
  (load "socket-test"))

(load "socket")


;;;
;;; A simple read-print function useful for testing open-output-socket.
;;;
(defun send (port)
  (let ((s (socket:open-client :port port)))
    (unwind-protect
	(loop
	 (write-char (read-char) s)
	 (if (listen s)
	     (write-char (read-char s))))
      (close s))))


;;;
;;; A simple read-print function useful for testing socket-server-loop.
;;;

(defun reader (s)
  (declare (type stream s))
  (do ((ch (read-char-no-hang s nil) (read-char-no-hang s nil)))
      ((null ch) 0)
      (write-char ch)
      (cond ((eq ch #\Newline)
	     (write-char #\. s)
	     (finish-output s)))
      (finish-output *standard-output*)))

(defun reader2 (s)
  (declare (type stream s))
  (do ((ch (read-char-no-hang s nil) (read-char-no-hang s nil)))
      ((null ch) 0)
      (write-char #\x)
      (cond ((eq ch #\Newline)
	     (write-char ch)
	     (finish-output s)))
      (finish-output *standard-output*)))


;;; To test the server loop, use the following call:
(defun rec (port1 port2)
  (socket:server-initialize)
  (if (and (eq 0 (socket:server-startup :port port1 
					:read-stream-input-proc #'reader))
	   (eq 0 (socket:server-startup :port port2
					:read-stream-input-proc #'reader2)))
      (unwind-protect
	  (socket:server-poll -1)
	(socket:server-shutdown))))


;;; To test startup/polling, do these:
(defun init ()
  (socket:server-initialize))

(defun startup (port)
  (socket:server-startup :port port :read-stream-input-proc #'reader))

(defun poll ()
  (socket:server-poll 0))

(defun shutdown ()
  (socket:server-shutdown))
