# include <stdio.h>			/* troffmt.c (rev3.7) */
# include <ctype.h>
# include <signal.h>

char *tempfile;		/* to store contexts while counting */
int nocnt = 0;		/* toggle for not counting keyword */
int nokwd = 0;		/* toggle for suppressing keyword */
int nomacs = 0;		/* toggle for not supplying macros */

usage()			/* print proper usage and exit */
{
	puts("Usage: troffmt [-ckm] [filename(s)] [-]\t\t(rev3.7)");
	puts("-c: suppress counting of keyword frequency");
	puts("-k: entirely suppress printing of keyword");
	puts("-m: do not supply concordance macros automatically");
	puts("- : read standard input instead of files");
	exit(1);
}

main(argc, argv)	/* format concordance for sending to troff */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int i, j, onintr();
	char *mktemp();

	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, onintr);

	tempfile = "/tmp/FmtXXXXX";
	mktemp(tempfile);

	for (i = 1; argv[i] && *argv[i] == '-'; i++)
	{
		for (j = 1; argv[i][j] != NULL; j++)
		{
			if (argv[i][j] == 'c')
				nocnt = 1;
			else if (argv[i][j] == 'k')
				nokwd = 1;
			else if (argv[i][j] == 'm')
				nomacs = 1;
			else  /* bad option */
			{
				fprintf(stderr,
				"Illegal troffmt flag: -%c\n", argv[i][j]);
				usage();
			}
		}
	}
	if (!nomacs)
		pr_macs();
	if (i == argc)
	{
		if (nokwd)
			rmkwds(stdin);
		else if (nocnt)
			ffmt(stdin);
		else
			format(stdin);
	}
	for (; i < argc; i++)
	{
		if (argv[i][0] == '-' && argv[i][1] == NULL)
		{
			if (nokwd)
				rmkwds(stdin);
			else if (nocnt)
				ffmt(stdin);
			else
				format(stdin);
		}
		if ((fp = fopen(argv[i], "r")) != NULL)
		{
			if (nokwd)
				rmkwds(fp);
			else if (nocnt)
				ffmt(fp);
			else
				format(fp);
			fclose(fp);
		}
		else  /* attempt to open file failed */
		{
			fprintf(stderr,
			"Trfmt cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	unlink(tempfile);
	exit(0);
}

pr_macs()		/* supply concordance macros automatically */
{
	if (access("/usr/lib/ms/ms.acc", 4) == 0)	 /* -ms accent marks */
		printf(".so /usr/lib/ms/ms.acc\n");
	else if (access("/usr/lib/me/chars.me", 4) == 0) /* -me accent marks */
		printf(".so /usr/lib/me/chars.me\n");
	else	fprintf(stderr, "Install -ms or -me macros!\n");
	printf(".de KW\n.ne 2.1\n.sp 0.3\n.ta 20n\n.ft B\n..\n");
	printf(".de CX\n.sp 0.1\n.ta 3.6iR 3.75i\n.ft R\n..\n");
	printf(".de HD\n'sp 2\n.tl ''- %% -''\n'sp 2\n..\n");
	printf(".de FO\n'bp\n..\n.wh 0 HD\n.wh -5 FO\n");
	printf(".nf\n.po 0.5i\n.ll 7.0i\n.lt 7.0i\n");
}

format(fp)	  	/* print keyword and count only if different */
FILE *fp;
{
	FILE *fopen(), *tf;
	char s[BUFSIZ], okw[BUFSIZ/2], nkw[BUFSIZ/2], cntxt[BUFSIZ];
	char *sp, *kwp, *cxp, *strcpy();
	int kwfreq = 0;

	strcpy(okw,"~~~~~");	/* make sure 1st keyword is printed */
	tf = NULL;		/* to prevent core dump with no input */
	while (fgets(s, BUFSIZ, fp))
	{
		for (sp = s, kwp = nkw; *sp != ' ' && *sp != '|'; sp++, kwp++)
		{
			if (*sp == '\b')	/* interpolate troff string */
			{
				*kwp = '\\';
				*++kwp = '*';
			} else
				*kwp = *sp;
		}
		*kwp = NULL;
		for (; *sp && *sp != '|'; sp++)
			;
		for (++sp, cxp = cntxt; *sp && *sp != '\n'; sp++, cxp++)
		{
			if (*sp == '|')
				*cxp = '\t';
			else if (*sp == '\b')	/* interpolate troff string */
			{
				*cxp = '\\';
				*++cxp = '*';
			} else
				*cxp = *sp;
		}
		*cxp = '\n';
		*++cxp = NULL;

		if (strcmp(nkw, okw) != 0)  /* kwds different */
		{
			if (kwfreq != 0)
				prtmpfile(tf, kwfreq);
			printf(".KW\n%s\t", nkw);
			tf = fopen(tempfile, "w");
			fputs(cntxt, tf);
			kwfreq = 1;
		}
		else  /* if keywords are the same */
		{
			fputs(cntxt, tf);
			kwfreq++;
		}
		strcpy(okw, nkw);
	}
	prtmpfile(tf, kwfreq);
}

prtmpfile(tf, kwfreq)		/* print frequency and contexts */
FILE *tf;
int kwfreq;
{
	char save[BUFSIZ];

	if (tf == NULL)		/* exit without core dump */
		exit(1);

	printf("(%d)\n.CX\n", kwfreq);
	fclose(tf);
	tf = fopen(tempfile, "r");
	while (fgets(save, BUFSIZ, tf))
		printf(" %s", save);
	fclose(tf);
}

int onintr()		/* remove tempfile in case of interrupt */
{
	fprintf(stderr, "\nInterrupt\n");
	unlink(tempfile);
	exit(1);
}

ffmt(fp)	  	/* fast format routine, no keyword counting */
FILE *fp;
{
	char s[BUFSIZ], okw[BUFSIZ/2], nkw[BUFSIZ/2], cntxt[BUFSIZ];
	char *sp, *kwp, *cxp;

	strcpy(okw,"~~~~~");	/* make sure 1st keyword is printed */

	while (fgets(s, BUFSIZ, fp))
	{ 
		for (sp = s, kwp = nkw; *sp && *sp != ' '; sp++, kwp++)
		{
			if (*sp == '\b')	/* interpolate troff string */
			{
				*kwp = '\\';
				*++kwp = '*';
			} else
				*kwp = *sp;
		}
		*kwp = NULL;
		for (; *sp && *sp != '|'; sp++)
			;
		for (++sp, cxp = cntxt; *sp && *sp != '\n'; sp++, cxp++)
		{
			if (*sp == '|')
				*cxp = '\t';
			else if (*sp == '\b')	/* interpolate troff string */
			{
				*cxp = '\\';
				*++cxp = '*';
			} else
				*cxp = *sp;
		}
		*cxp = '\n';
		*++cxp = NULL;

		if (strcmp(nkw, okw) != 0)  /* kwds different */
			printf(".KW\n%s\n.CX\n %s", nkw, cntxt);
		else  /* if keywords are the same */
			printf(" %s", cntxt);
		strcpy(okw, nkw);
	}
}

rmkwds(fp)		/* completely suppress printing of keyword */
FILE *fp;
{
	char s[BUFSIZ], *sp;

	while (fgets(s, BUFSIZ, fp))
	{
		for (sp = s; *sp && *sp != '|'; sp++)
			;
		for (; *sp; sp++)
		{
			if (*sp == '|')
				putchar(' ');
			else
				putchar(*sp);
		}
	}
}
