# include <stdio.h>			/* sfind.c (rev3.7) */
# include <ctype.h>
# define LNGBUF (BUFSIZ*8)
# define isperiod(c)	(c == '.' || c == '?' || c == '!')

usage()			/* print usage and synopsis of options */
{
	puts("Find sentence (record) matching pattern\t\t\t(rev3.7)");
	puts("Usage: sfind [-sC -ln -pn -ic -r] 'pattern' [-] filename(s)");
	puts("-sC: record separator is C (or empty line with no C)");
	puts("-ln: line number set to n (instead of 1)");
	puts("-pn: page number set to n (default off)");
	puts("-ic: page incrementing character is c (not =)");
	puts("-r : reset linenumber to 1 with each new file");
	puts(" - : read standard input instead of files");
	puts("metacharacters:");
	puts("_ is any single character");
	puts("* any number of characters");
	puts("$ matches a newline");
	puts("\\ escape magic");
	exit(1);
}

char pattern[BUFSIZ];	/* pattern to be searched for */
int recds = 0;		/* toggle switch for record searching */
char sepc = NULL;	/* record separating character */
long lineno = 1;	/* count of line numbers */
int pageno = 0;		/* toggle and count page numbers */
char pgincr = '=';	/* page incrementing character */
int resetno = 0;	/* reset linenumber for new file */

main(argc, argv)	/* find all sentences matching a pattern */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int i, apat = 0;
	char *strcpy();

	if (argc < 3)
		usage();
	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
			getflag(argv[i]);
		else if (!apat)
		{
			strcpy(pattern, argv[i]);
			apat = 1;
		}
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			findsent(fp, argv[i]);
			fclose(fp);
		}
		else  /* attempt to open file failed */
		{
			fprintf(stderr,
			"Sfind cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	exit(0);
}

getflag(f)		/* parses command line to set options */
char *f;
{
	long atol();

	f++;
	switch(*f++)
	{
		case 's':
			recds = 1;
			sepc = *f;
			break;
		case 'l':
			lineno = atol(f);
			break;
		case 'p':
			pageno = atoi(f);
			break;
		case 'i':
			pgincr = *f;
			break;
		case 'r':
			resetno = 1;
			break;
		case NULL:
			findsent(stdin, "Stdin");
			break;
		default:
			fprintf(stderr, "Invalid sfind flag: -%s\n", --f);
			exit(1);
			break;
	}
}

findsent(fp, fname)	/* searches through text sentence by sentence */
FILE *fp;
char fname[15];
{
	char sent[LNGBUF];
	int more;

	/* do loop used in case last record has no final sepc */
	do {
		more = getsent(sent, LNGBUF, fp);
		if (index(sent, pattern) >= 0)
		{
			printf("===< %s >", fname);
			if (pageno)
				printf("===< page %d >", pageno);
			printf("===< line %ld >", lineno);
			printf("===< %s >===", pattern);
			if (sent[0] != '\n')
				putchar('\n');
			printf("%s\n", sent);
		}
	} while (more);
	if (resetno)
		lineno = 1;
}

char lastc = NULL;
int nl = 0;

getsent(s, lim, fp)	/* get sentence into s, return length */
char *s;
int lim;
FILE *fp;
{
	register int c;

	lineno += nl;
	nl = 0;
	while (--lim && (c = getc(fp)) != EOF && !is_eos(c, fp))
	{
		if (c == pgincr && isspace(lastc))
			pageno++;
		*s++ = c;
		lastc = c;
		if (c == '\n')
			nl++;
	}
	*s = NULL;
	lastc = c;
	if (c == '\n')
		nl++;
	if (c == EOF)
		return(0);
	return(1);
}

is_eos(c, fp)		/* determine if at end of sentence or record */
int c;
FILE *fp;
{
	int ch;

	if (recds)	/* searching records */
	{
		if (sepc == NULL)	/* RS is a blank line */
		{
			if (lastc == '\n' && c == '\n')
				return(1);
		}
		else if (c == sepc)	/* RS is single character */
			return(1);
	}
	else if (isperiod(lastc))	/* searching sentences */
	{
		if (c == '\n')		/* period before eoln */
			return(1);
		ch = c;			/* test the next char */
		c = getc(fp);
		if (c == EOF)		/* do nothing if at EOF */
			;
		if (isspace(ch) && isspace(c))	/* 2 spaces in row */
			return(1);
		if (ch == '"' && isspace(c))	/* quote and space */
			return(1);
		if (ch == ')' && isspace(c))	/* paren and space */
			return(1);
		ungetc(c, fp);
	}
	return(0);
}

index(s, pat)		/* return index of pat in s, -1 if no match */
char s[], pat[];
{
	register int i, j, k;
	int n, m;

	for (i = 0; s[i]; i++)
	{
		for (j = i, k = 0; pat[k]; j++, k++)
		{
			if (pat[k] == '\\')	/* escape char */
				if (s[j] != pat[++k])
					break;
			if (pat[k] == '$')	/* newline char */
				if (s[j] == '\n')
					continue;
			if (pat[k] == '_')	/* any character */
				continue;
			if (pat[k] == '*')	/* wildcard */
			{
				k++;
			 forward:
				while (s[j] && s[j] != pat[k])
					j++;
				for (m = j, n = k; s[m] && pat[n]; m++, n++) 
					if (s[m] != pat[n]) {
						j++;
						goto forward;
					}
			}
			if (s[j]=='\n' && pat[k]==' ')	/* ignore nl */
				continue;
			if (s[j] != pat[k])
				break;
		}
		if (pat[k] == NULL)
			return(i);
	}
	return(-1);
}
