# include <stdio.h>			/* revconc.c (3.7) */
# include <ctype.h>

main(argc, argv)	/* reverse concordance module */
int argc;
char *argv[];
{

	FILE *fp, *fopen();

	if (argc == 1)
		revconc(stdin);
	else
	{
		while (--argc > 0)
			if ((fp = fopen(*++argv, "r")) == NULL)
			{
				fprintf(stderr,
				"Revconc cannot access the file: %s\t\t(rev3.7)\n",
				*argv);
				continue;
			}
			else
			{
				revconc(fp);
				fclose(fp);
			}
		exit(0);
	}
}

revconc(fp) 		/* reverse first word (keyword) on each line */
FILE *fp;
{
	char line[512];

	while (fgets(line, 512, fp))
	{
		revwd(line);
		fputs(line, stdout);
	}
}

revwd(s)  		/* reverse first word of string s in place */
char s[];
{
	int i, j;
	char c;

	for (i = 0, j = firstwdlen(s) - 1; i < j; i++, j--)
	{
		c = s[i];
		s[i] = s[j];
		s[j] = c;
	}
	return;
}

firstwdlen(s) 		/* return length of first word in string s */
char *s;
{
	int i = 0;

	while (!isspace(*s++))
		i++;
	return(i);
}
