# include <stdio.h>				/* pair.c (rev3.7) */

main(argc, argv)	/* pair two files side by side (or intercalate) */
int argc;
char *argv[];
{
	FILE *fopen(), *fp1, *fp2;
	char s1[BUFSIZ], s2[BUFSIZ], fmt1[15], fmt2[15], *sprintf();
	int eof1, eof2, len1 = 40, len2 = 40;
	register int i;

	if (argc < 3 || argc > 5)
	{
		puts("Usage: pair [-m] file1 file2 [+len1 [+len2]]\t(rev3.7)");
		puts("-m: merge (intercalate) two files line by line");
		puts("- : read standard input instead of either file");
		puts("len1 and 2 denote screen width of file1 and 2");
		exit(1);
	}
	if (argv[1][0] == '-' && argv[1][1] == 'm')
	{
		merge(argv[2], argv[3]);
		exit(0);
	}
	if (argv[1][0] == '-' && argv[1][1] == '\0')
		fp1 = stdin;
	else if ((fp1 = fopen(argv[1], "r")) == NULL)
	{
		fprintf(stderr,
		"Pair cannot access the file: %s\n", argv[1]);
		exit(1);
	}
	if (argv[2][0] == '-' && argv[2][1] == '\0')
		fp2 = stdin;
	else if ((fp2 = fopen(argv[2], "r")) == NULL)
	{
		fprintf(stderr,
		"Pair cannot access the file: %s\n", argv[2]);
		exit(1);
	}
	if (argc > 3)
		len1 = atoi(argv[3]+1);
	if (argc > 4)
		len2 = atoi(argv[4]+1);
	sprintf(fmt1, "%%-%d.%ds", len1, len1 - 1);
	sprintf(fmt2, "%%-.%ds\n", len2 - 1);

	eof1 = eof2 = 0;
	while (!eof1 || !eof2)
	{
		if (fgets(s1, BUFSIZ, fp1))
		{
			s1[strlen(s1)-1] = '\0';
			printf(fmt1, s1);
		}
		else	eof1 = 1;

		if (fgets(s2, BUFSIZ, fp2))
		{
			if (eof1)
				for (i = 0; i < len1; i++)
					putchar(' ');
			s2[strlen(s2)-1] = '\0';
			printf(fmt2, s2);
		}
		else	eof2 = 1;

		if (eof2 && !eof1)
			putchar('\n');
	}
	exit(0);
}

merge(arg1, arg2)	/* intercalate two files line by line */
char arg1[], arg2[];
{
	FILE *fopen(), *fp1, *fp2;
	char s1[512], s2[512];
	int eof1, eof2, std = 0;

	if (arg1[0] == '-' && arg1[1] == NULL)
	{
		fp1 = stdin;
		std = 1;
	}
	else if ((fp1 = fopen(arg1, "r")) == NULL)
	{
		fprintf(stderr, "Pair cannot access the file: %s\n", arg1);
		exit(1);
	}
	if (arg2[0] == '-' && arg2[1] == NULL)
	{
		fp2 = stdin;
		std = 1;
	}
	else if ((fp2 = fopen(arg2, "r")) == NULL)
	{
		fprintf(stderr, "Pair cannot access the file: %s\n", arg2);
		exit(1);
	}
	eof1 = eof2 = 0;
	while (!eof1 || !eof2)
	{
		if (fgets(s1, 512, fp1))
		{
			fputs(s1, stdout);
			if (!isatty(fileno(stdout)) && std)
				fputs(s1, stderr);
		}
		else
			eof1 = 1;

		if (fgets(s2, 512, fp2))
		{
			if (eof1)
				putchar('\n');
			fputs(s2, stdout);
			if (!isatty(fileno(stdout)) && std)
				fputs(s2, stderr);
		}
		else
			eof2 = 1;

		if (eof2 && !eof1)
			putchar('\n');
	}
}
