# include <stdio.h>			/* maxwd.c (rev3.7) */
# include <ctype.h>
# define LNGBUF (BUFSIZ * 2)

char filename[15], mxword[BUFSIZ], mxline[LNGBUF];
int mxwdlen = 0, lineno = 0;
int mxlnlen = 0, doline = 0;

main(argc, argv)	/* find, measure and print longest word */
int argc;
char *argv[];
{
	FILE *fopen(), *fp;
	int i;

	if (argc == 1)
	{
		puts("Usage: maxwd [-l -dF -] filename(s)\t\t(rev3.7)");
		puts("will give file, linenumber, maximum word length,");
		puts("\tand then print the longest word");
		puts("-l: look for longest line instead of longest word");
		puts("-d: define punctuation set according to file F");
		puts("- : read standard input instead of files");
		exit(1);
	}
	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
			getflag(argv[i]);
		else if ((fp = fopen(argv[i], "r")) != NULL)
		{
			if (doline)
				maxline(fp, argv[i]);
			else
				maxword(fp, argv[i]);
			fclose(fp);
		}
		else  /* cannot open file */
		{
			fprintf(stderr,
			"Maxwd cannot access the file: %s\n", argv[i]);
			exit(1);
		}
	}
	printf("%s: line %d: ", filename, lineno);
	if (doline)
	{
		printf("%d characters:\n", mxlnlen-1);
		printf("%s", mxline);
	}
	else
	{
		printf("%d characters:\n", mxwdlen);
		printf("%s\n", mxword);
	}
	exit(0);
}

getflag(f)		/* parses command line to set options */
char *f;
{
	char *pfile;

	f++;
	switch(*f++)
	{
		case 'l':
			doline = 1;
			break;
		case 'd':
			pfile = f;
			getpunct(pfile);
			break;
		case NULL:
			if (doline)
				maxline(stdin, "Stdin");
			else
				maxword(stdin, "Stdin");
			break;
		default:
			fprintf(stderr,
			"Invalid maxwd flag: -%s\n", --f);
			exit(1);
			break;
	}
}

char punct[BUFSIZ] = ",.;:-?!\"()[]{}" ;

getpunct(pfile)		/* read user's punctuation from pfile */
char *pfile;
{
	FILE *pfp, *fopen();
	char s[BUFSIZ], *strcpy();

	if ((pfp = fopen(pfile, "r")) == NULL)
	{
		fprintf(stderr,
		"Maxwd cannot access Punctfile: %s\n", pfile);
		exit(1);
	}
	else
		while (fgets(s, BUFSIZ, pfp))
			strcpy(punct, s);
}

maxword(fp, fname)	/* inspect each file for longest word */
FILE *fp;
char fname[];
{
	char word[BUFSIZ];
	int c, i = 0, wdlen = 0, lno = 1;

	while ((c = getc(fp)) != EOF)
	{
		if (!isskip(c))
		{
			word[i++] = c;
			wdlen++;
		}
		else  /* if (isskip(c)) */
		{
			word[i] = NULL;
			i = 0;
			if ((wdlen = strlen(word)) > mxwdlen)
			{
				strcpy(filename, fname);
				lineno = lno;
				mxwdlen = wdlen;
				strcpy(mxword, word);
			}
		}
		if (c == '\n')
			lno++;
	}
}

isskip(c)		/* function to evaluate punctuation */
char c;
{
	char *ptr;

	if (isspace(c))
		return(1);
	for (ptr = punct; *ptr != c && *ptr != NULL; ptr++)
		;
	if (*ptr == NULL)
		return(0);
	else
		return(1);
}

maxline(fp, fname)	/* inspect each file for longest line */
FILE *fp;
char fname[];
{
	char line[LNGBUF];
	int lnlen = 0, lno = 0;

	while (fgets(line, LNGBUF, fp))
	{
		lno++;
		if ((lnlen = strlen(line)) > mxlnlen)
		{
			strcpy(filename, fname);
			lineno = lno;
			mxlnlen = lnlen;
			strcpy(mxline, line);
		}
	}
}
