# include <stdio.h>				/* kwal.c (rev3.7) */
# include <ctype.h>

usage()			/* print usage and synopsis of options */
{
	puts("Key Word And Line concordance program\t\t(rev3.7)");
	puts("Usage: kwal [-kn -m -wS -fn -sn -r -ln -x -dF + -] filename(s)");
	puts("-kn: keyword is n characters long (defaults to 15)");
	puts("-m : keywords not mapped from upper to lower case");
	puts("-wS: write string S onto id field (use quotes around blanks)");
	puts("-fn: filename (up to n characters) written onto id field");
	puts("-sn: skip n characters of lefthand id field in text and write as id");
	puts("-r : reset linenumber to 1 at beginning of every file");
	puts("-ln: line numbering begins with line n (instead of 1)");
	puts("-x : line numbering is suppressed entirely");
	puts("-d : define punctuation set according to file F");
	puts("+  : the + character indicates cedilla or umlaut");
	puts("-  : read text from standard input (terminal or pipe)");
	exit(1);
}

int kwlen = 15;		/* lefthand keyword length */
int kwmap = 1;		/* toggle for mapping keyword to lcase */
int wrtid = 0;		/* toggle write onto id field */
char *idfld;		/* string to write onto id field */
int wrtfnm = 0;		/* toggle writing of filename */
int skipid = 0;		/* skip and write imbedded id field */
long lineno = 1;	/* count line numbers */
int resetno = 0;	/* reset lineno for new file */
int plusm = 0;		/* toggle plus mark to indicate accents */
char punctuation[BUFSIZ] = ",.;:-?!\"()[]{}" ;

main(argc,argv)		/* Key Word And Line concordance program */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	int i;

	if (argc == 1)
		usage();

	for (i = 1; i < argc; i++)
	{
		if (*argv[i] == '-')
			getflag(argv[i]);
		else if (*argv[i] == '+')
			plusm = 1;
		else if ((fp = fopen(argv[i],"r")) != NULL)
		{
			kwal(fp, argv[i]);
			fclose(fp);
			if (resetno)
				lineno = 1;
		}
		else  /* cannot open file */
		{
			fprintf(stderr,
			"Kwal cannot access the file: %s\n", argv[i]);
			continue;
		}
	}
	exit(0);
}

getflag(f)		/* parses command line to set options */
char *f;
{
	char *pfile;
	long atol();

	f++;
	switch(*f++)
	{
		case 'k':
			kwlen = atoi(f);
			break;
		case 'm':
			kwmap = 0;
			break;
		case 'w':
			wrtid = 1;
			idfld = f;
			break;
		case 'f':
			wrtfnm = atoi(f);
			break;
		case 's':
			skipid = atoi(f);
			break;
		case 'r':
			resetno = 1;
			break;
		case 'l':
			lineno = atol(f);
			break;
		case 'x':
			lineno = 0;
			break;
		case 'd':
			pfile = f;
			getpunct(pfile);
			break;
		case NULL:
			kwal(stdin, "Stdin");
			break;
		default:
			fprintf(stderr,
			"Invalid kwal flag: -%s\n", --f);
			exit(1);
			break;
	}
}

getpunct(pfile)		/* read user's punctuation from pfile */
char *pfile;
{
	FILE *pfp, *fopen();
	char s[BUFSIZ], *strcpy();

	if ((pfp = fopen(pfile, "r")) == NULL)
	{
		fprintf(stderr,
		"Kwal cannot access Punctfile: %s\n", pfile);
		exit(1);
	}
	else
		while (fgets(s, BUFSIZ, pfp))
			strcpy(punctuation, s);
}

char line[BUFSIZ];	/* line buffer of text */
int pos;		/* position of current word */
char wrtskip[BUFSIZ];	/* storage for embedded id field */

kwal(fp, fname)		/* prints kwal entry for each word */
FILE *fp;
char *fname;
{
	char wd[BUFSIZ];

	while (fgets(line, BUFSIZ, fp) != NULL)
	{
		pos = 0;
		if (skipid)
			cp_skipid();
		while (getword(wd))
		{
			pr_keywd(wd);		/* lefthand keyword */
			pr_idfld(fname);	/* identification fld */
			fputs(line, stdout);	/* print context */
		}
		if (lineno)
			lineno++;
	}
}

cp_skipid()		/* handle strings of embedded id field */
{
	char lncpy[BUFSIZ];
	int i, j;

	strcpy(lncpy, line);

	for (i = 0; i < skipid; i++)
		wrtskip[i] = line[i];
	wrtskip[i] = NULL;

	for (i = 0, j = skipid; lncpy[j] != NULL; i++, j++)
		line[i] = lncpy[j];
	line[i] = NULL;
}

pr_keywd(wd)		/* print keyword, adjusting for backspaces */
char wd[];
{
	char *cp;
	int i, kwbsno = 0;

	cp = wd;
	for (i = 0; i < kwlen; i++)
		if (*cp)
		{
			if (*cp == '\b')
				kwbsno += 2;
			if (plusm && *cp == '+')
				kwbsno++;
			putchar(*cp++);
		}
		else
			putchar(' ');
	while (kwbsno-- > 0)
		putchar(' ');
	putchar('|');
}

pr_idfld(fname)		/* print specified id fields and number */
char *fname;
{
	char *wfile;
	int i;

	if (wrtid)
		printf("%s ", idfld);
	if (wrtfnm)
	{
		wfile = fname;
		for (i = 0; i < wrtfnm; i++)
			if (*wfile)
				putchar(*wfile++);
			else
				putchar(' ');
		putchar(' ');
	}
	if (skipid)
		printf("%s    ", wrtskip);
	if (lineno)
		printf("%6ld    ", lineno);
}

getword(wd)		/* gets next word on each line */
char *wd;
{
	int ln; 

	/* skip over blanks */
	while ((*wd = line[pos++]) && isskip(*wd) && *wd != '\n')
		;
	if (*wd == '\n')
		ln = 0;
	if (kwmap && isupper(*wd))
		*wd = tolower(*wd);

	/* load word from line */
	while ((*++wd = line[pos++]) && !isskip(*wd))
	{
		if (kwmap && isupper(*wd))
			*wd = tolower(*wd);
		ln = 1;
	}
	*wd = NULL;

	pos--;			/* unget newline character */
	return(ln);		/* true if there is more line */
}

isskip(c)		/* function to evaluate punctuation */
char c;
{
	char *ptr;

	if (isspace(c))
		return(1);
	for (ptr = punctuation; *ptr != c && *ptr != NULL; ptr++)
		;
	if (*ptr == NULL)
		return(0);
	else
		return(1);
}
