# include <stdio.h>			/* dict.c (rev3.7) */


main(argc, argv)	/* split file into dictionary sections */
int argc;
char *argv[];
{
	FILE *fp, *fopen();
	char *strcpy(), root[15];	/* root name of outfile */

	if (argc == 1 || argc > 3)
	{
		puts("Usage: dict [-]filename [outroot]\t\t(rev3.7)");
		puts("- : read standard input rather than file");
		exit(1);
	}
	if (argc == 2)
		*root = 'X';
	if (argc == 3)
		strcpy(root, argv[2]);

	if (argv[1][0] == '-' && argv[1][1] == NULL)
		dict(stdin, root);
	else if ((fp = fopen(argv[1], "r")) != NULL)
	{
		dict(fp, root);
		fclose(fp);
	}
	else  /* can't open input file */
	{
		fprintf(stderr,
		"Dict cannot access the file: %s\n", argv[1]);
		exit(1);
	}
	exit(0);
}

dict(fp, root)		/* write each letter to separate file */
FILE *fp;
char *root;
{
	FILE *sp, *fopen();
	char s[BUFSIZ], fname[20], ch = 'A';
	int first = 1, len;

	sp = NULL;
	while (fgets(s, BUFSIZ, fp))
	{
		if (s[0] != ch)		/* new letter found */
		{
			ch = s[0];
			first = 1;
		}
		if (!first && s[0] == ch)	/* same letter */
		{
			fputs(s, sp);
			if (ferror(sp))
			{
				perror(fname);
				exit(1);
			}
		}
		if (first)	/* first encounter with this letter */
		{
			strcpy(fname, root);	/* derive filename */
			len = strlen(fname);
			fname[len] = ch;
			fname[++len] = NULL;

			if (sp != NULL)
				fclose(sp);
			if ((sp = fopen(fname, "a")) == NULL)
			{
				perror(fname);
				exit(1);
			}
			fputs(s, sp);
			if (ferror(sp))
			{
				perror(fname);
				exit(1);
			}
			first = 0;
		}
	}
}
