.TH FREQ HUM (rev3.7)
.ds ]W UC Berkeley
.SH NAME
freq \- word frequency count
.SH SYNOPSIS
.nf
\fBfreq\fP  [ \fB\-n  \-m  \-d\fPpfile  \- ]  filename ...
\-n: list words in numerical order of frequency
\-m: disable mapping of letters to lower case
\-d: define punctuation set according to \fIpfile\fP
\- : read standard input instead of files
.fi
.SH DESCRIPTION
\fIFreq\fP reads through a list of files,
counting the number of occurrences of each word.
The frequencies and words are kept
in a binary tree structure in core memory,
so that the program will be as efficient as possible.
When reading is finished, the frequencies are listed on the left,
with the words, in alphabetical order, on the right.
The total number of words, and the number of different words,
is tabulated and given at the end of the wordlist.
The output can be formatted into columns with \fIpr,\fP if desired.
.PP
The \-n option will cause the words to be listed by
numerical order of frequency, with the most common words first.
The \-m flag will leave capital letters as they are.
The \-d option allows the user to define his own punctuation set.
If this option is called, \fIfreq\fP will replace
the default punctuation set ,.;:-?!"()[]{}
with the last line of the specified file.
.SH "SEE ALSO"
cfreq(hum), dissolve(hum)
.SH AUTHOR
Bill Tuthill
.SH BUGS
\fIFreq\fP will run out of core memory at about 64K bytes of storage.
In that case it is necessary to use \fIprep\fP, \fIsort\fP and \fIuniq\fP,
which is a much slower process, but which can handle large amounts of data.
